using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using Crownwood.DotNetMagic.Common;
using ChaKi.Entity.Search;
using ChaKi.Panels;
using ChaKi.Panels.ConditionsPanes;

namespace ChaKi.Panels
{
    /// <summary>
    /// ^u̎ʁi^uindexƈv邱Ɓj
    /// </summary>
    public enum ConditionsPanelType
    {
        CP_CORPUS = 0,
        CP_FILTER = 1,
        CP_STRING = 2,
        CP_TAG = 3,
        CP_DEP = 4,
        CP_COLLOCATION = 5,
    }

    public partial class ConditionsPanel : Form
    {
        public EventHandler TabChanged;

        private CorpusPane corpusPane;
        private FilterPane filterPane;
        private StringSearchPane stringSearchPane;
        private TagSearchPane tagSearchPane;
        private DepSearchPane depSearchPane;
        private CollocationPane collocationPane;

        private SearchConditions m_Cond;

        public ConditionsPanel(SearchConditions model)
        {
            m_Cond = model;

            InitializeComponent();

            corpusPane = new CorpusPane(model.CorpusCond);
            filterPane = new FilterPane(model.FilterCond);
            stringSearchPane = new StringSearchPane(model.StringCond);
            tagSearchPane = new TagSearchPane(model.TagCond);
            depSearchPane = new DepSearchPane(model.DepCond);
            collocationPane = new CollocationPane(model.CollCond);

            corpusPane.Dock = DockStyle.Fill;
            filterPane.Dock = DockStyle.Fill;
            stringSearchPane.Dock = DockStyle.Fill;
            tagSearchPane.Dock = DockStyle.Fill;
            depSearchPane.Dock = DockStyle.Fill;
            collocationPane.Dock = DockStyle.Fill;

            this.corpusTab.Controls.Add(corpusPane);
            this.filterTab.Controls.Add(filterPane);
            this.stringSearchTab.Controls.Add(stringSearchPane);
            this.tagSearchTab.Controls.Add(tagSearchPane);
            this.depSearchTab.Controls.Add(depSearchPane);
            this.collocationTab.Controls.Add(collocationPane);
        }

        public SearchConditions ChangeModel(SearchConditions model)
        {
            m_Cond = new SearchConditions( model );  // ̎_ŃRs[쐬
            this.corpusPane.SetCondition(m_Cond.CorpusCond);
            this.filterPane.SetCondition(m_Cond.FilterCond);
            this.stringSearchPane.SetCondition(m_Cond.StringCond);
            this.tagSearchPane.SetCondition(m_Cond.TagCond);
            this.depSearchPane.SetCondition(m_Cond.DepCond);
            this.collocationPane.SetCondition(m_Cond.CollCond);
            return m_Cond;
        }

        public VisualStyle Style
        {
            set { this.tabControl1.Style = value; }
        }

        /// <summary>
        /// IuWFNgRs[ĕԂB
        /// </summary>
        /// <returns></returns>
        public SearchConditions CreateConditions()
        {
            SearchConditions obj = new SearchConditions(this.GetConditions());
            return obj;
        }

        /// <summary>
        /// ݂̏IuWFNgQƂɂԂB
        /// </summary>
        /// <returns></returns>
        public SearchConditions GetConditions()
        {
            m_Cond.CorpusCond = this.corpusPane.GetCondition();
            m_Cond.StringCond = this.stringSearchPane.GetCondition();
            m_Cond.TagCond = this.tagSearchPane.GetCondition();
            m_Cond.DepCond = this.depSearchPane.GetCondition();
            m_Cond.CollCond = this.collocationPane.GetCondition();
            return m_Cond;
        }

        public int SelectedTabIndex
        {
            get
            {
                return this.tabControl1.SelectedIndex;
            }
            set
            {
                this.tabControl1.SelectedIndex = value;
            }
        }

        public ConditionsPanelType SelectedTab
        {
            get
            {
                return (ConditionsPanelType)this.SelectedTabIndex;
            }
            set
            {
                this.SelectedTabIndex = (int)value;
            }
        }

        private void tabControl1_SelectionChanged(Crownwood.DotNetMagic.Controls.TabControl sender, Crownwood.DotNetMagic.Controls.TabPage oldPage, Crownwood.DotNetMagic.Controls.TabPage newPage)
        {
            if (TabChanged != null)
            {
                TabChanged(this, null);
            }
        }
    }
}
