﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using Crownwood.DotNetMagic.Common;

namespace ChaKi.Options
{
    public partial class OptionDialog : Form
    {
        private static Dictionary<string, VisualStyle> m_PredefinedStyles = new Dictionary<string, VisualStyle>
        {
            { "Office 2007 Silver", VisualStyle.Office2007Silver },
            { "Office 2007 Blue", VisualStyle.Office2007Blue },
            { "Office 2007 Black", VisualStyle.Office2007Black },
            { "Office 2003", VisualStyle.Office2003 },
            { "VisualStudio 2005", VisualStyle.IDE2005 },
            { "Plain", VisualStyle.Plain }
        };

        private GUISetting m_TempData;

        public OptionDialog()
        {
            InitializeComponent();
        }

        private void comboBox1_SelectedIndexChanged(object sender, EventArgs e)
        {
            m_TempData.Visual = m_PredefinedStyles[(string)comboBox1.SelectedItem];
//            Program.MainForm.ChangeStyle(m_PredefinedStyles[comboBox1.SelectedText]);
        }

        /// <summary>
        /// ダイアログ開始時の設定値表示
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void OptionDialog_Shown(object sender, EventArgs e)
        {
            m_TempData = (GUISetting)GUISetting.Instance.Clone();

            this.comboBox1.Text = m_TempData.Visual.ToString();

            this.fontSampleLabel1.Font = m_TempData.GetBaseTextFont();
            this.fontSampleLabel2.Font = m_TempData.GetBaseAnsiFont();
        }

        private void button1_Click(object sender, EventArgs e)
        {
            Apply();
            Close();
        }

        private void button2_Click(object sender, EventArgs e)
        {
            Close();
        }

        private void button4_Click(object sender, EventArgs e)
        {
            Apply();
        }

        private void Apply()
        {
            GUISetting.Instance.Set(m_TempData);
        }

        /// <summary>
        /// Base Text Font変更ボタンが押されたときの処理
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void button3_Click(object sender, EventArgs e)
        {
            DoChangeFontDialog("BaseText");
        }

        private void button5_Click(object sender, EventArgs e)
        {
            DoChangeFontDialog("BaseAnsi");
        }

        private void DoChangeFontDialog(string tag)
        {
            FontDialog fd = new FontDialog();
            fd.Font = m_TempData.Fonts[tag];
            if (fd.ShowDialog() == DialogResult.OK)
            {
                m_TempData.SetFont(tag, fd.Font);
                this.fontSampleLabel1.Font = fd.Font;
            }
        }
    }
}
