using System;
using System.ComponentModel;
using System.Drawing;
using System.IO;
using System.Threading;
using System.Windows.Forms;
using System.Xml;
using System.Xml.Serialization;
using ChaKi.Common;
using ChaKi.Entity.Corpora;
using ChaKi.Entity.Kwic;
using ChaKi.Entity.Search;
using ChaKi.Panels;
using ChaKi.Service.Annotation;
using ChaKi.Service.Search;
using ChaKi.Service.Collocation;

namespace ChaKi
{
    partial class MainForm
    {
        public void OnBeginSearch()
        {
            KwicSearch(null);
        }

        public void OnBeginSearchNarrow()
        {
            if (this.historyGuidePanel.Current != null)
            {
                KwicSearch(this.historyGuidePanel.Current);
            }
        }

        private void KwicSearch(SearchHistory parent)
        {
            // Z[u
            SaveSearchCond(null);

            // AȂꍇ͋̂̂VK쐬
            SearchConditionsSequence condSeq;
            if (parent == null)
            {
                condSeq = new SearchConditionsSequence();
            }
            else
            {
                condSeq = new SearchConditionsSequence(parent.CondSeq);
            }

            // ServiceCommand쐬
            IServiceCommand cmd = null;
            SearchConditions conds = this.condPanel.CreateConditions();
            condSeq.Add(conds);
            SearchHistory hist = null;
            switch (this.condPanel.SelectedTab)
            {
                case ConditionsPanelType.CP_CORPUS:
                    conds.ActiveSearch = SearchType.SentenceSearch;
                    hist = SearchHistory.Create(condSeq);
                    cmd = new SentenceListService(hist.KwicList, condSeq, hist.Progress);
                    break;
                case ConditionsPanelType.CP_STRING:
                    conds.ActiveSearch = SearchType.StringSearch;
                    hist = SearchHistory.Create(condSeq);
                    cmd = new StringSearchService(hist.KwicList, condSeq, hist.Progress);
                    break;
                case ConditionsPanelType.CP_TAG:
                    conds.ActiveSearch = SearchType.TagSearch;
                    hist = SearchHistory.Create(condSeq);
                    cmd = new TagSearchService(hist.KwicList, condSeq, hist.Progress);
                    break;
                case ConditionsPanelType.CP_DEP:
                    conds.ActiveSearch = SearchType.DepSearch;
                    hist = SearchHistory.Create(condSeq);
                    cmd = new DepSearchService(hist.KwicList, condSeq, hist.Progress);
                    break;
            }
            if (cmd != null)
            {
                // Viewɑ΂ModelXV
                this.commandPanel.SetModel(hist.Progress);
                IChaKiView view = this.ChangeView(conds.ActiveSearch);
                view.SetModel(hist);

                // ServiceCommandɊÂAqXgVK쐬Ēǉ
                if (parent != null)
                {
                    parent.AddChild(hist);
                }
                else
                {
                    SearchHistory.Root.AddChild(hist);
                }

                // ServiceCommandsL[ɓ
                this.commandPanel.QueueCommand(cmd);
            }
        }

        public void OnBeginWordList()
        {
            // Z[u
            SaveSearchCond(null);

            // ServiceCommand쐬
            IServiceCommand cmd = null;
            SearchConditions conds = this.condPanel.CreateConditions();
            SearchConditionsSequence condSeq = new SearchConditionsSequence(conds);
            SearchHistory hist = null;
            switch (this.condPanel.SelectedTab)
            {
                case ConditionsPanelType.CP_TAG:
                    conds.ActiveSearch = SearchType.TagWordList;
                    hist = SearchHistory.Create(condSeq);
                    cmd = new WordListService(hist.LexemeList, condSeq, hist.Progress);
                    break;
                case ConditionsPanelType.CP_DEP:
                    conds.ActiveSearch = SearchType.DepWordList;
                    break;
            }
            if (cmd != null)
            {
                // Viewɑ΂ModelXV
                this.wordListView.SetCorpusList(conds.CorpusCond.Corpora);
                IChaKiView view = this.ChangeView(conds.ActiveSearch);
                view.SetModel(hist.LexemeList);
                this.commandPanel.SetModel(hist.Progress);

                // ServiceCommandɊÂAqXgVK쐬Ēǉ
                SearchHistory.Root.AddChild(hist);

                // ServiceCommandsL[ɓ
                this.commandPanel.QueueCommand(cmd);
            }
        }

        void OnBeginCollocation()
        {
            // Z[u
            SaveSearchCond(null);

            // HistorỹJgm[h܂͒߂ancestorKwicListł邱ƂmF
            SearchHistory curHistNode = this.historyGuidePanel.GetLastKwicListNode();
            if (curHistNode == null)
            {
                MessageBox.Show("Needs a Kwic Result List.");
                return;
            }

            // Collocation쐬
            SearchConditions conds = this.condPanel.CreateConditions();
            SearchConditionsSequence condSeq = new SearchConditionsSequence(conds);
            SearchHistory hist = null;

            conds.ActiveSearch = SearchType.Collocation;
            hist = SearchHistory.Create(condSeq);

            // CollocationService쐬ĎsiIServiceCommandł͂ȂBL[COsȂj
            CollocationService svc = new CollocationService(curHistNode.KwicList, hist.CollList, condSeq);
            try
            {
                svc.Exec();
            }
            catch (Exception ex)
            {
                ErrorReportDialog edlg = new ErrorReportDialog("Error while executing collocation:", ex);
                edlg.ShowDialog();
            }

            // Viewɑ΂ModelXV
            IChaKiView view = this.ChangeView(conds.ActiveSearch);
            view.SetModel(hist.CollList);

            // ServiceCommandɊÂAqXgVK쐬Ēǉ
            curHistNode.AddChild(hist);
        }

        public void Save(string filename, SearchHistory hist)
        {
            if (hist == null)
            {
                hist = this.historyGuidePanel.Current;
            }
            if (hist == null)
            {
                return;
            }
            try
            {
                using (FileStream fs = new FileStream(filename, FileMode.Create))
                {
                    XmlSerializer ser = new XmlSerializer(typeof(SearchHistory));
                    ser.Serialize(fs, hist);
                }
            }
            catch (Exception ex)
            {
                ErrorReportDialog edlg = new ErrorReportDialog("Error while Saving:", ex);
                edlg.ShowDialog();
            }

        }

        /// <summary>
        /// plɑ݂錻݂̏t@CɃZ[u
        /// </summary>
        /// <param name="filename">t@C̃pXBnullȂftHg"LastSearch.xml"gpB</param>
        public void SaveSearchCond(string filename)
        {
            if (filename == null)
            {
                filename = Program.SettingDir + @"\LastSearch.xml";
            }
            SearchConditions cond = this.condPanel.GetConditions();
            using (FileStream fs = new FileStream(filename, FileMode.Create))
            {
                XmlSerializer ser = new XmlSerializer(typeof(SearchConditions));
                //SoapFormatter ser = new SoapFormatter();
                ser.Serialize(fs, cond);
            }
        }

        protected void OnSaveConfig(XmlTextWriter xmlOut)
        {
            // DockStateݒt@Cւ̒ǉo
            xmlOut.WriteStartElement("WindowLocation");
            xmlOut.WriteAttributeString("X", String.Format("{0}", this.Bounds.X));
            xmlOut.WriteAttributeString("Y", String.Format("{0}", this.Bounds.Y));
            xmlOut.WriteAttributeString("Width", String.Format("{0}", this.Bounds.Width));
            xmlOut.WriteAttributeString("Height", String.Format("{0}", this.Bounds.Height));
            xmlOut.WriteEndElement();
        }

        protected void OnLoadConfig(XmlTextReader xmlIn)
        {
            // DockStateݒt@Cǂݍ񂾎_ł̒ǉ̏
            if (xmlIn.Name == "WindowLocation")
            {
                int x = 0;
                int y = 0;
                int width = 0;
                int height = 0;
                bool b = true;
                b = b && Int32.TryParse(xmlIn.GetAttribute("X"), out x);
                b = b && Int32.TryParse(xmlIn.GetAttribute("Y"), out y);
                b = b && Int32.TryParse(xmlIn.GetAttribute("Width"), out width);
                b = b && Int32.TryParse(xmlIn.GetAttribute("Height"), out height);
                if (b)
                {
                    this.Bounds = new Rectangle(x, y, width, height);
                }

                xmlIn.Read();
            }
        }

        /// <summary>
        /// 1. ̃qXgɏplč\B
        /// 2. Kwic/WordList/Collocatioñr[؂ւB
        /// 3. r[̒gNAB
        /// 4. qXgZ[uf[^ւ̃pXĂViewɃ[hB
        /// </summary>
        /// <param name="hist"></param>
        public void OnHistoryNavigating(SearchHistory hist)
        {
            SearchConditions cond = hist.CondSeq.Last;
            // ChangeModeĺAcondɃRs[𐶐ACondPanelModelɃATCBɃJgɃZbg.
            this.m_Model.CurrentSearchConditions = this.condPanel.ChangeModel(cond);

            // ɓKView&^uɐ؂ւ
            ChangeView(cond.ActiveSearch);

            this.commandPanel.SetModel(hist.Progress);
            this.kwicView.SetModel(hist);
            this.wordListView.SetModel(hist.LexemeList);
            this.collocationView.SetModel(hist.CollList);

            switch (cond.ActiveSearch)
            {
                case SearchType.SentenceSearch:
                    this.condPanel.SelectedTab = ConditionsPanelType.CP_CORPUS;
                    break;
                case SearchType.StringSearch:
                    this.condPanel.SelectedTab = ConditionsPanelType.CP_STRING;
                    break;
                case SearchType.TagSearch:
                case SearchType.TagWordList:
                    this.condPanel.SelectedTab = ConditionsPanelType.CP_TAG;
                    break;
                case SearchType.DepSearch:
                case SearchType.DepWordList:
                    this.condPanel.SelectedTab = ConditionsPanelType.CP_DEP;
                    break;
            }
        }

        /// <summary>
        /// Historyt@CɃZ[u.
        /// </summary>
        /// <param name="sender">SearchHistory</param>
        /// <param name="args"></param>
        public void OnHistorySaveRequested(object sender, EventArgs args)
        {
            SearchHistory hist = sender as SearchHistory;
            SaveFileDialog dlg = new SaveFileDialog();
            if (dlg.ShowDialog() == DialogResult.OK)
            {
                Save(dlg.FileName, hist);
                hist.FilePath = dlg.FileName;
            }
        }

        /// <summary>
        /// History폜.
        /// </summary>
        /// <param name="sender">SearchHistory</param>
        /// <param name="args"></param>
        public void OnDeleteHistoryRequested(object sender, EventArgs args)
        {
            SearchHistory hist = sender as SearchHistory;
            m_Model.DeleteHistory(hist);
            this.historyGuidePanel.UpdateView();
        }

        /// <summary>
        /// listindexԖڂ̕ɑ΂āȂO̕Context Panelɕ\B
        /// </summary>
        /// <param name="list"></param>
        /// <param name="index"></param>
        public void OnRequestContext(KwicList list, int index)
        {
            Corpus crps = list.Records[index].Crps;
            int senNo = list.Records[index].SenPos;
            int count = 3;//TODO: ̓̕IvV擾

            Cursor oldCur = this.Cursor;
            this.Cursor = Cursors.WaitCursor;
            SentenceContextService svc = new SentenceContextService(crps, senNo, count, this.contextPanel.Model);
            try
            {
                svc.Begin();
                this.contextPanel.UpdateView();
            }
            catch (Exception e)
            {
                MessageBox.Show(e.Message);
            }
            finally
            {
                this.Cursor = oldCur;
            }
        }

        public void OnRequestSentenceTagList(KwicList list, int index)
        {
            Corpus crps = list.Records[index].Crps;
            int senNo = list.Records[index].SenPos;

            SentenceTagService svc = new SentenceTagService(crps, senNo, this.sentenceTagListPanel.Model);
            Cursor oldCur = this.Cursor;
            this.Cursor = Cursors.WaitCursor;
            try
            {
                svc.Begin();
                this.sentenceTagListPanel.UpdateView();
            }
            catch (Exception e)
            {
                MessageBox.Show(e.Message);
            }
            finally
            {
                this.Cursor = oldCur;
            }
        }

        /// <summary>
        /// Annotation (Segment, Link, Group)[h
        /// </summary>
        public void LoadAnnotations()
        {
            SearchHistory hist = hist = this.historyGuidePanel.Current;
            if (hist == null)
            {
                return;
            }
            AnnotationLoadOperation op = new AnnotationLoadOperation();
            op.Execute(hist);

            Cursor oldCursor = this.Cursor;
            this.Cursor = Cursors.WaitCursor;
            kwicView.UpdateSegments(); // ̍XV@͗vlicallbackȂǁj
            this.Cursor = oldCursor;
        }

        private class AnnotationLoadOperation
        {
            private SearchHistory m_History;
            private AnnotationService m_Service;
            private ProgressDialog m_Dlg;
            private BackgroundWorker m_Worker;
            private ManualResetEvent m_WaitDone;
            private bool m_CancelFlag;

            public AnnotationLoadOperation()
            {
                m_Service = new AnnotationService();
                m_WaitDone = new ManualResetEvent(false);
            }

            public void Execute(SearchHistory hist)
            {
                m_CancelFlag = false;
                m_History = hist;

                m_Dlg = new ProgressDialog();
                m_Dlg.Text = "Querying...";
                m_Dlg.ProgressMax = 100;
                m_Dlg.ProgressReset();
                m_Dlg.Cancelled += new EventHandler(OnCancelled);
                m_Worker = new BackgroundWorker();
                m_Worker.WorkerReportsProgress = true;
                m_Worker.DoWork += new DoWorkEventHandler(OnLoadAnnotations);
                m_Worker.ProgressChanged += new ProgressChangedEventHandler(OnWorkerProgressChanged);
                m_Worker.RunWorkerAsync(hist);
                m_Dlg.ShowDialog();
                m_WaitDone.WaitOne();
                m_Dlg.Dispose();
                m_Worker.Dispose();
            }

            void OnCancelled(object sender, EventArgs e)
            {
                m_CancelFlag = true;
            }

            void OnLoadAnnotations(object sender, DoWorkEventArgs e)
            {
                try
                {
                    AnnotationService svc = new AnnotationService();
                    SearchHistory hist = (SearchHistory)e.Argument;
                    svc.Load(hist.KwicList, hist.AnnotationList, new Action<int>((int v) => { m_Worker.ReportProgress(v); }), ref m_CancelFlag);

                }
                catch (Exception ex)
                {
                    ErrorReportDialog edlg = new ErrorReportDialog("Error while executing query commands:", ex);
                    edlg.ShowDialog();
                }
                finally
                {
                    m_Dlg.DialogResult = DialogResult.Cancel;
                    m_WaitDone.Set();
                }
            }

            void OnWorkerProgressChanged(object sender, ProgressChangedEventArgs e)
            {
                m_Dlg.ProgressCount = e.ProgressPercentage;
            }
        }
    }
}
