﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Xml.Serialization;
using System.Drawing;
using System.Xml;

namespace ChaKi.Common
{
    [XmlRoot("FontDictionary")]
    public class FontDictionary : Dictionary<string, Font>, IXmlSerializable
    {
        public FontDictionary()
        {
        }

        #region IXmlSerializable メンバ
        public System.Xml.Schema.XmlSchema GetSchema()
        {
            return null;
        }

        public void ReadXml(System.Xml.XmlReader reader)
        {
            XmlSerializer keySerializer = new XmlSerializer(typeof(string));
            XmlSerializer guSerializer = new XmlSerializer(typeof(GraphicsUnit));
            XmlSerializer fsSerializer = new XmlSerializer(typeof(FontStyle));

            bool wasEmpty = reader.IsEmptyElement;
            reader.Read();
            if (wasEmpty)
            {
                return;
            }

            while (reader.NodeType != System.Xml.XmlNodeType.EndElement)
            {
                reader.ReadStartElement("item");
                reader.ReadStartElement("key");
                string key = (string)keySerializer.Deserialize(reader);
                reader.ReadEndElement();
                reader.ReadStartElement("value");
                string fontFamily = reader.ReadElementString("fontFamily");
                float fontSize = XmlConvert.ToSingle(reader.ReadElementString("fontSize"));
                GraphicsUnit graphicsUnit = (GraphicsUnit)guSerializer.Deserialize(reader);
                FontStyle fontStyle = (FontStyle)fsSerializer.Deserialize(reader);
                reader.ReadEndElement();
                reader.ReadEndElement();
                this.Add(key, new Font(fontFamily, fontSize, fontStyle, graphicsUnit));
                reader.MoveToContent();
            }
            reader.ReadEndElement();
        }

        public void WriteXml(System.Xml.XmlWriter writer)
        {
            XmlSerializer keySerializer = new XmlSerializer(typeof(string));
            XmlSerializer guSerializer = new XmlSerializer(typeof(GraphicsUnit));
            XmlSerializer fsSerializer = new XmlSerializer(typeof(FontStyle));

            foreach (string key in this.Keys)
            {
                writer.WriteStartElement("item");
                writer.WriteStartElement("key");
                keySerializer.Serialize(writer, key);
                writer.WriteEndElement();
                writer.WriteStartElement("value");
                // FontはそのままではXmlSerializeできない
                // --> <fontFamily/><fontSize/><GraphicsUnit/><FontStyle/>に分けて出力する
                Font font = this[key];
                writer.WriteElementString("fontFamily", font.FontFamily.Name);
                writer.WriteElementString("fontSize", XmlConvert.ToString(font.Size));
                guSerializer.Serialize(writer, font.Unit);
                fsSerializer.Serialize(writer, font.Style); 
                writer.WriteEndElement();
                writer.WriteEndElement();
            }
        }
        #endregion
    }
}
