﻿using System;
using System.Collections.Generic;
using System.Text;
using ChaKi.Entity.Kwic;
using ChaKi.Entity.Search;
using ChaKi.Entity.Corpora;
using NHibernate;
using System.Collections;
using System.Text.RegularExpressions;

namespace ChaKi.Service.Search
{
    public class StringSearchService : SearchServiceBase
    {

        private KwicList m_Model;

        public StringSearchService(KwicList model, SearchConditionsSequence condSeq, CommandProgress progress)
            : base(condSeq, progress)
        {
            m_Model = model;
        }

        /// <summary>
        /// コーパスごとのStringSearch本体
        /// </summary>
        /// <param name="c"></param>
        protected override void ExecuteSearchSession(Corpus c)
        {
            SearchConditions cond = m_CondSeq.Last;  //@todo: 絞り込み等ではCondSeqを順次検索しなければならない

            // strng searchのクエリを生成する
            string qstr = QueryBuilder.BuildStringSearchQuery(cond);
            IQuery query = m_Session.CreateQuery(qstr);
            IList queryResult = query.List();
            int totalCount = queryResult.Count;

            // ここまでで検索は終了。

            // 検索されたSentenceに対して、文内容をKwicに変換・出力する
            int n = 0;
            Regex regex = new Regex(cond.StringCond.Pattern);

            m_Progress.SetRange(totalCount);
            foreach (Sentence sen in queryResult)
            {
                KwicItem ki = new KwicItem(c, sen.ID, 0/*charPos*/);
                string text = sen.Text;
                Match m = regex.Match( text );
                if (!m.Success) {
                    continue;
                }
                ki.Left.AddText(text.Substring(0, m.Index),0);
                ki.Center.AddText(text.Substring(m.Index,m.Length), KwicWord.KWA_PIVOT);
                ki.Right.AddText(text.Substring(m.Index+m.Length), 0);
                m_Model.AddKwicItem(ki);
                m_Progress.Increment();
                n++;
            }
        }
    }
}
