﻿using System;
using System.Collections.Generic;
using System.Text;
using ChaKi.Entity.Corpora;
using System.IO;

namespace ChaKi.Service.Readers
{
    public class CorpusSourceReaderFactory
    {
        /// <summary>
        /// ファイルの先頭を読んでフォーマットを自動推定し、
        /// フォーマットに適したCorpusSourceReaderを生成する。
        /// </summary>
        /// <param name="path"></param>
        /// <param name="encoding"></param>
        /// <param name="cps"></param>
        /// <returns></returns>
        public static CorpusSourceReader Create(string path, string encoding, Corpus cps)
        {
            // 最初の100行までを読んで、以下の特徴フラグをセットする。
            int maxTabsInLine = 0;
            int maxCommasInLine = 0;
            int maxLineLength = 0;
            bool hasEOSLine = false;
            bool hasCabochaLine = false;   // "* "で始まる行があるか

            using (TextReader streamReader = new StreamReader(path, Encoding.GetEncoding(encoding)))
            {
                int n = 0;
                string s;
                while ((s = streamReader.ReadLine()) != null)
                {
                    maxLineLength = Math.Max(maxLineLength, s.Length);
                    if (s.StartsWith("*"))
                    {
                        hasCabochaLine = true;
                    }
                    else if (s.StartsWith("EOS"))
                    {
                        hasEOSLine = true;
                    }
                    else
                    {
                        int commas = 0;
                        int tabs = 0;
                        for (int i = 0; i < s.Length; i++)
                        {
                            if (s[i] == ',')
                            {
                                commas++;
                            }
                            else if (s[i] == '\t')
                            {
                                tabs++;
                            }
                        }
                        maxTabsInLine = Math.Max(maxTabsInLine, tabs);
                        maxCommasInLine = Math.Max(maxCommasInLine, commas);
                    }
                    if (n++ > 100)
                    {
                        break;
                    }
                }
            }

            // 判定
            if (hasEOSLine && maxTabsInLine > 3)
            {
                return new CabochaChasenReader(cps);
            }
            if (hasEOSLine && maxTabsInLine > 0 && maxCommasInLine > 2)
            {
                return new CabochaMecabReader(cps);
            }
            return new PlainTextReader(cps);
        }
    }
}
