﻿using System;
using System.Collections.Generic;
using System.Text;
using ChaKi.Entity.Corpora;
using NHibernate;
using ChaKi.Service.Search;
using ChaKi.Service.Database;

namespace ChaKi.Service.Lexicons
{
    public class SearchLexiconService
    {
        public SearchLexiconService()
        {
        }

        /// <summary>
        /// Surfaceの先頭がstrに一致するLexemeをすべて得る。
        /// </summary>
        /// <param name="str"></param>
        public IList<Lexeme> Search(Corpus cps, string str )
        {
            IList<Lexeme> list = new List<Lexeme>();

            // Corpus(DB)の種類に合わせてConfigurationをセットアップする
            DBService dbs = DBService.Create(cps.DBParam);
            NHibernate.Cfg.Configuration cfg = dbs.GetConnection();
            ISessionFactory factory = cfg.BuildSessionFactory();
            using (ISession session = factory.OpenSession())
            {
                for (int i = 1; i < str.Length; i++)
                {
                    string sstr = str.Substring(0, i);
                    string qstr = string.Format("from Lexeme l where l.Surface = '{0}'", sstr);
                    IQuery query = session.CreateQuery(qstr);
                    IList<Lexeme> result = query.List<Lexeme>();
                    foreach (Lexeme lex in result)
                    {
                        list.Add(lex);
                    }
                }
            }
            return list;
        }
    }
}
