using System;
using System.Collections.Generic;
using System.Text;
using System.Diagnostics;

namespace ChaKi.Entity.Search
{
    public class TagSearchCondition : ISearchCondition, ICloneable
    {
        public List<LexemeCondition> LexemeConds { get; set; }
        public char LeftConnection { get; set; }
        public char RightConnection { get; set; }

        public event EventHandler OnModelChanged;

        public TagSearchCondition()
        {
            this.LexemeConds = new List<LexemeCondition>();
            Reset();
        }

        public TagSearchCondition(TagSearchCondition src)
        {
            this.LexemeConds = new List<LexemeCondition>();
            foreach (LexemeCondition lexcond in src.LexemeConds)
            {
                LexemeConds.Add(new LexemeCondition(lexcond));
            }
            this.LeftConnection = src.LeftConnection;
            this.RightConnection = src.RightConnection;
            OnModelChanged = src.OnModelChanged;
        }

        public object Clone()
        {
            return new TagSearchCondition(this);
        }

        public void Reset()
        {
            LexemeConds.Clear();
            LeftConnection = ' ';
            RightConnection = ' ';
            // ftHgłP̍ڂ͍쐬
            LexemeCondition item = new LexemeCondition();
            item.IsPivot = true;
            LexemeConds.Add(item);
            if (OnModelChanged != null) OnModelChanged(this, null);
        }

        /// <summary>
        /// ɂЂƂLexemeǉB
        /// </summary>
        public LexemeCondition InsertLexemeConditionAtLeft()
        {
            LexemeCondition item = null;
            try
            {
                LexemeCondition right = this.LexemeConds[0];
                item = new LexemeCondition();
                item.RelativePosition = new Range(right.RelativePosition.Start-1,right.RelativePosition.Start-1);
                LexemeConds.Insert(0, item);
            }
            catch (ArgumentOutOfRangeException e)
            {
                Debug.WriteLine(e);
                return null;
            }
            if (OnModelChanged != null) OnModelChanged(this, null);
            return item;
        }

        /// <summary>
        /// EɂЂƂLexemeǉB
        /// </summary>
        public LexemeCondition InsertLexemeConditionAtRight()
        {
            LexemeCondition item = null;
            try
            {
                LexemeCondition left = this.LexemeConds[LexemeConds.Count - 1];
                item = new LexemeCondition();
                item.RelativePosition = new Range(left.RelativePosition.End + 1, left.RelativePosition.End + 1);
                LexemeConds.Add(item);
            }
            catch (ArgumentOutOfRangeException e)
            {
                Debug.WriteLine(e);
                return null;
            }
            if (OnModelChanged != null) OnModelChanged(this, null);
            return item;
        }

        /// <summary>
        /// wʒuɂЂƂLexemeǉB
        /// ǉꂽRelativePosition͏lƂȂB
        /// </summary>
        /// <param name="i"></param>
        public LexemeCondition InsertAt(int i)
        {
            LexemeCondition item = new LexemeCondition();
            LexemeConds.Insert(i, item);
            if (OnModelChanged != null) OnModelChanged(this, null);
            return item;
        }

        public void RemoveAt(int i)
        {
            LexemeConds.RemoveAt(i);
            if (OnModelChanged != null) OnModelChanged(this, null);
        }

        public void SetConnection(int pos, char conn_char)
        {
            LexemeCondition lcond;
            // pos̍
            if (pos >= 0 && pos < LexemeConds.Count)
            {
                lcond = LexemeConds[pos];
                lcond.LeftConnection = conn_char;
            }
            // pos-1̉E
            if (pos-1 >= 0 && pos-1 < LexemeConds.Count)
            {
                lcond = LexemeConds[pos - 1];
                lcond.RightConnection = conn_char;
            }
            // View update͍sȂ
        }


        /// <summary>
        /// TagSearchɊ܂܂PivotԂB
        /// </summary>
        /// <returns>Pivot[0..LexemeConds.Count-1]̂ꂩ̒lBȂ-1</returns>
        public LexemeCondition GetPivot()
        {
            foreach (LexemeCondition item in this.LexemeConds)
            {
                if (item.IsPivot)
                {
                    return item;
                }
            }
            return null;
        }

        /// <summary>
        /// TagSearchɊ܂܂PivoẗʒuԂB
        /// </summary>
        /// <returns>Pivot[0..LexemeConds.Count-1]̂ꂩ̒lBȂ-1</returns>
        public int GetPivotPos()
        {
            for (int i = 0; i < this.LexemeConds.Count; i++)
            {
                if (this.LexemeConds[i].IsPivot)
                {
                    return i;
                }
            }
            return -1;
        }

        public void Shift(int shift)
        {
            foreach (LexemeCondition lcond in this.LexemeConds)
            {
                lcond.OffsetRange(shift);
            }
            if (OnModelChanged != null) OnModelChanged(this, null);
        }
    }
}
