﻿using System;
using System.Collections.Generic;
using System.Text;

namespace ChaKi.Entity.Kwic
{
    public class KwicItemComparer : IComparer<KwicItem>
    {
        private int col;
        private bool isAscending;

        public KwicItemComparer(int col, bool isAscending)
        {
            this.col = col;
            this.isAscending = isAscending;
        }

        public int Compare(KwicItem x, KwicItem y)
        {
//            "Index", "Check", "Corpus", "Char", "Sen",
//            "Left", "Center", "Right", "Bib" };
            int res = 0;

            switch (col)
            {
                case 0: // by Index
                    res = (x.ID - y.ID);
                    break;
                case 1: // by Check
                    res = 0;
                    break;
                case 2:
                    res = string.Compare(x.Crps.Name, y.Crps.Name);
                    break;
                case 3:
                    res = (x.CharPos - y.CharPos);
                    break;
                case 4:
                    res = (x.SenPos - y.SenPos);
                    break;
                case 5:
                    res = KwicPortion.Compare(x.Left, y.Left, true);
                    break;
                case 6:
                    res = KwicPortion.Compare(x.Center, y.Center, false);
                    break;
                case 7:
                    res = KwicPortion.Compare(x.Right, y.Right, false);
                    break;
                case 8:
                    res = 0;
                    break;
            }
            if (!isAscending)
            {
                return -res;
            }
            return res;
        }
    }
}
