﻿using System;
using System.Collections.Generic;
using System.Text;

namespace ChaKi.Entity.Corpora
{
    public class Link : Tag
    {
        private int m_id;
        private Segment m_From;
        private Segment m_To;
        private bool m_IsDirected;
        private bool m_IsTransitive;

        public Link()
        {
            m_id = 0;
            m_From = null;
            m_To = null;
            m_IsDirected = true;
            m_IsTransitive = false;
        }

        public virtual int ID
        {
            get { return m_id; }
            set { m_id = value; }
        }

        public virtual Segment From
        {
            get { return m_From; }
            set { m_From = value; }
        }

        public virtual Segment To
        {
            get { return m_To; }
            set { m_To = value; }
        }

        public virtual bool IsDirected
        {
            get { return m_IsDirected; }
            set { m_IsDirected = value; }
        }

        public virtual bool IsTransitive
        {
            get { return m_IsTransitive; }
            set { m_IsTransitive = value; }
        }

    }
}
