using System;
using System.Collections.Generic;
using System.Text;
using System.IO;
using System.Data.Common;
using ChaKi.Entity.Properties;
using System.Xml.Serialization;
using System.Collections.ObjectModel;
using System.Collections;
using System.Diagnostics;

namespace ChaKi.Entity.Corpora
{
    public class Corpus
    {
        public string Name
        {
            get { return DBParam.Name; }
        }

        public DBParameter DBParam { get; set; }

        // ePvl(DBService.LoadCorpusInfo()Ŏ擾)
        public int NLexemes { get; set; }
        public int NWords { get; set; }
        public int NSentences { get; set; }
        public int NBunsetsus { get; set; }
        public int NSegments { get; set; }
        public int NLinks { get; set; }
        public int NGroups { get; set; }

        public Corpus()
        {
            DBParam = new DBParameter();
            Sentences = new List<Sentence>();
            Lex = new Lexicon();
            Segments = new List<Segment>();
            Links = new List<Link>();
        }

        public static Corpus CreateFromFile(string path)
        {
            Corpus c = new Corpus();
            string ext = Path.GetExtension(path).ToUpper();
            // nameSQLitȅꍇDB(pXjAʏDB`t@C
            if (ext.Equals(".DEF"))
            {
                //deft@CǂݍŊep[^𓾂
                c.DBParam.ParseDefFile(path);
            }
            else if (ext.Equals(".DB"))
            {
                c.DBParam.DBType = "SQLite";
                c.DBParam.DBPath = path;
                c.DBParam.Name = Path.GetFileNameWithoutExtension(path);
            }
            return c;
        }

        // ̊Ǘ
        [XmlIgnore]
        public List<Sentence> Sentences
        {
            get { return m_Sentences; }
            set { m_Sentences = value; }
        }
        private List<Sentence> m_Sentences;

        public void AddSentence(Sentence sen)
        {
            m_Sentences.Add(sen);
        }

        // Lexicon̊Ǘ
        [XmlIgnore]
        public Lexicon Lex
        {
            get {
                return m_Lex;
            }
            set
            {
                this.m_Lex = value;
            }
        }
        private Lexicon m_Lex;

        // Segment̊Ǘ
        [XmlIgnore]
        public List<Segment> Segments
        {
            get { return m_Segments; }
            set { m_Segments = value; }
        }
        private List<Segment> m_Segments;

        // Link̊Ǘ
        [XmlIgnore]
        public List<Link> Links
        {
            get { return m_Links; }
            set { m_Links = value; }
        }
        private List<Link> m_Links;

        public virtual void AddSegment(Segment seg)
        {
            m_Segments.Add(seg);
        }

        public virtual void AddLink(Link lnk)
        {
            m_Links.Add(lnk);
        }

        /// <summary>
        /// R[pX̊{CorpusPropertỹXgƂĕԂ.
        /// </summary>
        /// <returns></returns>
        public List<CorpusProperty> GetCorpusProperties()
        {
            List<CorpusProperty> cprops = new List<CorpusProperty>();
            cprops.Add(new CorpusProperty("Name", this.Name));
            cprops.Add(new CorpusProperty("DBType", this.DBParam.DBType));
            cprops.Add(new CorpusProperty("Path", this.DBParam.DBPath));
            cprops.Add(new CorpusProperty("Server", this.DBParam.Server));
            cprops.Add(new CorpusProperty("User", this.DBParam.User));
            string dummy = new string('*', this.DBParam.Password.Length);
            cprops.Add(new CorpusProperty("Password", dummy));
            cprops.Add(new CorpusProperty("#Words", this.NWords.ToString()));
            cprops.Add(new CorpusProperty("#Lexemes", this.NLexemes.ToString()));
            cprops.Add(new CorpusProperty("#Sentences", this.NSentences.ToString()));
            cprops.Add(new CorpusProperty("#Bunsetsu", this.NBunsetsus.ToString()));
            cprops.Add(new CorpusProperty("#Segments", this.NSegments.ToString()));
            cprops.Add(new CorpusProperty("#Links", this.NLinks.ToString()));
            cprops.Add(new CorpusProperty("#Groups", this.NGroups.ToString()));
            return cprops;
        }
    }
}
