﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Diagnostics;
using System.Text;
using System.Windows.Forms;
using ChaKi.Entity.Corpora;

namespace DependencyEdit
{
    public partial class TagLabel : Label
    {
        public event EventHandler TagChanged;

        public Link Link { get; set; }

        public TagLabel(Link link)
        {
            InitializeComponent();
            this.Link = link;
        }

        private void TagLabel_MouseUp(object sender, MouseEventArgs e)
        {
            this.contextMenuStrip1.Show(this.PointToScreen( e.Location ));
        }

        private void OnTagChanged(object sender)
        {
            string s = ((ToolStripMenuItem)sender).Text;
            s = s.Replace("&", "");
            this.Text = s;
            if (this.TagChanged != null)
            {
                this.TagChanged(this, null);
            }
        }

        private void toolStripMenuItem1_Click(object sender, EventArgs e)
        {
            OnTagChanged(sender);
        }

        private void toolStripMenuItem2_Click(object sender, EventArgs e)
        {
            OnTagChanged(sender);
        }

        private void toolStripMenuItem3_Click(object sender, EventArgs e)
        {
            OnTagChanged(sender);
        }
    }
}
