﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.IO;
using ChaKi.Entity.Settings;

namespace ChaKi
{
    public partial class CreateMySQLCorpus : Form
    {
        public List<string> DatabaseCandidates { get; set; }

        public string DBMS { get; set; }
        public string Server { get; set; }
        public string User { get; set; }
        public string Password { get; set; }

        public CreateMySQLCorpus()
        {
            InitializeComponent();

            this.comboBox1.SelectedItem = UserSettings.GetInstance().DefaultCorpusSourceEncoding;
            this.comboBox2.SelectedItem = UserSettings.GetInstance().DefaultCorpusSourceType;
        }

        private void button2_Click(object sender, EventArgs e)
        {
            OpenFileDialog dlg = new OpenFileDialog();
            dlg.CheckFileExists = true;
            dlg.Title = "Select Input File";
            dlg.Filter = "Input files (*.cabocha)|*.cabocha|ChaSen files (*.chasen)|*.chasen|MeCab files (*.mecab)|*.mecab|All files (*.*)|*.*";
            if (dlg.ShowDialog() == DialogResult.OK)
            {
                this.textBox1.Text = dlg.FileName;
            }
        }

        private void button3_Click(object sender, EventArgs e)
        {
            ShowDatabaseListDialog dlg = new ShowDatabaseListDialog();
            dlg.Data = DatabaseCandidates;
            if (dlg.ShowDialog() == DialogResult.OK)
            {
                this.textBox2.Text = dlg.DatabaseName;
            }
            dlg.Dispose();
        }

        private void button1_Click(object sender, EventArgs e)
        {
            SaveFileDialog dlg = new SaveFileDialog();
            dlg.Title = "Create Def File to Store DB Connection Parameters";
            dlg.Filter = "Def files (*.def)|*.def|All files (*.*)|*.*";
            if (dlg.ShowDialog() == DialogResult.OK)
            {
                string def_path = dlg.FileName;
                // Defファイルを作成
                using (StreamWriter st = new StreamWriter(def_path))
                {
                    st.WriteLine(string.Format("db={0}", this.DBMS));
                    st.WriteLine(string.Format("corpusname={0}", this.textBox2.Text));
                    st.WriteLine(string.Format("server={0}", this.Server));
                    st.WriteLine(string.Format("user={0}", this.User));
                    st.WriteLine(string.Format("password={0}", this.Password));
                }
                // CabochaファイルとDefファイルを指定してCreateCorpus.exeを起動
                string args = "";
                if (this.comboBox1.Text.Length > 0)
                {
                    args += string.Format("-e={0} ", this.comboBox1.Text);
                }
                if (this.comboBox2.Text.Length > 0)
                {
                    args += string.Format("-t={0} ", this.comboBox2.Text);
                }
                args += string.Format("\"{0}\" \"{1}\"", this.textBox1.Text, def_path);
                this.process1.StartInfo.Arguments = args; 
                this.process1.StartInfo.WorkingDirectory = Program.ProgramDir;
                this.process1.Start();
            }
        }

        private void process1_Exited(object sender, EventArgs e)
        {
            this.Close();
        }

        private void button4_Click(object sender, EventArgs e)
        {
            this.Close();
        }

        private void CreateMySQLCorpus_FormClosing(object sender, FormClosingEventArgs e)
        {
            UserSettings.GetInstance().DefaultCorpusSourceEncoding = this.comboBox1.Text;
            UserSettings.GetInstance().DefaultCorpusSourceType = this.comboBox2.Text;
        }
    }
}
