﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Windows.Forms;
using ChaKi.VirtualGrid;
using ChaKi.Entity.Corpora;
using System.Collections;

namespace ChaKi.ToolDialogs
{
    public partial class CorpusInfo : Form
    {
        private Corpus m_Corpus;
        private Cache m_MemoryCache;

        public CorpusInfo()
        {
            InitializeComponent();
            m_Corpus = null;

            this.dataGridView2.VirtualMode = true;
            this.dataGridView2.CellValueNeeded += new DataGridViewCellValueEventHandler(dataGridView2_CellValueNeeded);
        }

        public void SetCorpus(Corpus c)
        {
            m_Corpus = c;
        }

        private void CorpusInfo_Load(object sender, EventArgs e)
        {
            if (m_Corpus == null)
            {
                return;
            }

            LoadSummary();
            LoadLexicon();
            LoadPOS();
            LoadCForms();
            LoadCTypes();
            LoadSegmentTags();
            LoadLinkTags();
            LoadGroupTags();
        }

        private void LoadSummary()
        {
            IList<CorpusProperty> cprops = m_Corpus.GetCorpusProperties();
            this.dataGridView1.DataSource = cprops;
            this.dataGridView1.Columns[0].Width = 100;
            this.dataGridView1.Columns[1].Width = 300;
        }

        private void LoadLexicon()
        {
            Lexicon lexicon = m_Corpus.Lex;
            DataGridView dg = this.dataGridView2;

            /*
            LexiconDataRetriever retriever = new LexiconDataRetriever();
            m_MemoryCache = new Cache(retriever, 16);
            foreach (DataColumn column in retriever.Columns)
            {
                dataGridView1.Columns.Add(column.ColumnName, column.ColumnName);
            }
            dg.RowCount = retriever.RowCount;
             */
            dg.RowCount = m_Corpus.Lex.Entries.Count;
/*
            int r = 0;
            foreach (KeyValuePair<string, Lexeme> pair in lexicon.Entries)
            {
                Lexeme lex = pair.Value;
                dg.RowCount++;
                dg[0, r].Value = lex.Surface;
                dg[1, r].Value = lex.Reading;
                dg[2, r].Value = lex.Pronunciation;

                dg[4, r].Value = lex.PartOfSpeech.Name;
                dg[5, r].Value = lex.CType.Name;
                dg[6, r].Value = lex.CForm.Name;
                r++;
            }
 * */
        }

        private void dataGridView2_CellValueNeeded(object sender, DataGridViewCellValueEventArgs e)
        {
            Lexeme lex = null;
            try
            {
                lex = m_Corpus.Lex.Entries.Values[e.RowIndex];
            }
            catch (Exception)
            {
                return;
            }

            switch (e.ColumnIndex)
            {
                case 0: e.Value = lex.Surface; break;
                case 1: e.Value = lex.Reading; break;
                case 2: e.Value = lex.Pronunciation; break;
                case 3: e.Value = (lex.BaseLexeme != null) ? lex.BaseLexeme.Surface : ""; break;
                case 4: e.Value = lex.PartOfSpeech.Name; break;
                case 5: e.Value = lex.CType.Name; break;
                case 6: e.Value = lex.CForm.Name; break;
                case 7: e.Value = lex.Frequency; break;
            }
//            e.Value = this.m_MemoryCache.RetrieveElement(e.RowIndex, e.ColumnIndex);
        }

        private void LoadPOS()
        {
            this.propertyTree1.Cps = m_Corpus;
            this.propertyTree1.PopulateWithPOSSelections();
        }
        private void LoadCForms()
        {
            this.propertyTree2.Cps = m_Corpus;
            this.propertyTree2.PopulateWithCFormSelections();
        }
        private void LoadCTypes()
        {
            this.propertyTree3.Cps = m_Corpus;
            this.propertyTree3.PopulateWithCTypeSelections();
        }
        private void LoadSegmentTags()
        {
            //@todo
            DataGridView dg = this.dataGridView3;
            dg.RowCount++;
            dg[0, 0].Value = "Bunsetsu";
        }
        private void LoadLinkTags()
        {
            //@todo
            DataGridView dg = this.dataGridView4;
            dg.RowCount++;
            dg[0, 0].Value = "D";
            dg[1, 0].Value = "Bunsetsu";
            dg[2, 0].Value = "Bunsetsu";
            dg[3, 0].Value = true;
            dg[4, 0].Value = false;
            dg.RowCount++;
            dg[0, 1].Value = "A";
            dg[1, 1].Value = "Bunsetsu";
            dg[2, 1].Value = "Bunsetsu";
            dg[3, 1].Value = true;
            dg[4, 1].Value = false;
            dg.RowCount++;
            dg[0, 2].Value = "O";
            dg[1, 2].Value = "Bunsetsu";
            dg[2, 2].Value = "Bunsetsu";
            dg[3, 2].Value = true;
            dg[4, 2].Value = false;
        }
        private void LoadGroupTags()
        {
        }
    }
}
