using System;
using System.Collections.Generic;
using System.Text;
using System.Xml;
using System.IO;
using System.Xml.Serialization;
using System.Runtime.Serialization.Formatters.Soap;
using ChaKi.Service.Search;
using ChaKi.Entity.Search;
using System.Drawing;
using ChaKi.Entity.Kwic;
using Crownwood.DotNetMagic.Controls;
using System.Windows.Forms;
using ChaKi.Entity.Corpora;

namespace ChaKi
{
    partial class MainForm
    {
        public void BeginSearchHandler()
        {
            KwicSearch(null);
        }

        public void BeginSearchNarrowHandler()
        {
            if (this.historyGuidePanel.Current != null)
            {
                KwicSearch(this.historyGuidePanel.Current);
            }
        }

        private void KwicSearch(SearchHistory parent)
        {
            // Z[u
            SaveSearchCond(null);

            // AȂꍇ͋̂̂VK쐬
            SearchConditionsSequence condSeq;
            if (parent == null)
            {
                condSeq = new SearchConditionsSequence();
            }
            else
            {
                condSeq = new SearchConditionsSequence(parent.CondSeq);
            }

            // ServiceCommand쐬
            IServiceCommand cmd = null;
            SearchConditions conds = this.condPanel.CreateConditions();
            condSeq.Add(conds);
            SearchHistory hist = null;
            switch (this.condPanel.SelectedTab)
            {
                case ConditionsPanelType.CP_CORPUS:
                    conds.ActiveSearch = SearchType.SentenceSearch;
                    hist = SearchHistory.Create(condSeq);
                    cmd = new SentenceListService(hist.KwicList, condSeq, hist.Progress);
                    break;
                case ConditionsPanelType.CP_STRING:
                    conds.ActiveSearch = SearchType.StringSearch;
                    hist = SearchHistory.Create(condSeq);
                    cmd = new StringSearchService(hist.KwicList, condSeq, hist.Progress);
                    break;
                case ConditionsPanelType.CP_TAG:
                    conds.ActiveSearch = SearchType.TagSearch;
                    hist = SearchHistory.Create(condSeq);
                    cmd = new TagSearchService(hist.KwicList, condSeq, hist.Progress);
                    break;
                case ConditionsPanelType.CP_DEP:
                    conds.ActiveSearch = SearchType.DepSearch;
                    hist = SearchHistory.Create(condSeq);
                    cmd = new DepSearchService(hist.KwicList, condSeq, hist.Progress);
                    break;
            }
            if (cmd != null)
            {
                // Viewɑ΂ModelXV
                this.commandPanel.SetModel(hist.Progress);
                IChaKiView view = this.ChangeView(conds.ActiveSearch);
                view.SetModel(hist.KwicList);

                // ServiceCommandɊÂAqXgVK쐬Ēǉ
                if (parent != null)
                {
                    parent.AddChild(hist);
                }
                else
                {
                    SearchHistory.Root.AddChild(hist);
                }

                // ServiceCommandsL[ɓ
                this.commandPanel.QueueCommand(cmd);
            }
        }

        public void BeginWordListHandler()
        {
            // Z[u
            SaveSearchCond(null);

            // ServiceCommand쐬
            IServiceCommand cmd = null;
            SearchConditions conds = this.condPanel.CreateConditions();
            SearchConditionsSequence condSeq = new SearchConditionsSequence(conds);
            SearchHistory hist = null;
            switch (this.condPanel.SelectedTab)
            {
                case ConditionsPanelType.CP_TAG:
                    conds.ActiveSearch = SearchType.TagWordList;
                    hist = SearchHistory.Create(condSeq);
                    cmd = new WordListService(hist.LexemeList, condSeq, hist.Progress);
                    break;
                case ConditionsPanelType.CP_DEP:
                    conds.ActiveSearch = SearchType.DepWordList;
                    break;
            }
            if (cmd != null)
            {
                // Viewɑ΂ModelXV
                this.wordListView.SetCorpusList(conds.CorpusCond.Corpora);
                IChaKiView view = this.ChangeView(conds.ActiveSearch);
                view.SetModel(hist.LexemeList);
                this.commandPanel.SetModel(hist.Progress);

                // ServiceCommandɊÂAqXgVK쐬Ēǉ
                SearchHistory.Root.AddChild(hist);

                // ServiceCommandsL[ɓ
                this.commandPanel.QueueCommand(cmd);
            }
        }

        public void Save(string filename, SearchHistory hist)
        {
            if (hist == null)
            {
                hist = this.historyGuidePanel.Current;
            }
            if (hist == null)
            {
                return;
            }
            using (FileStream fs = new FileStream(filename, FileMode.Create))
            {
                XmlSerializer ser = new XmlSerializer(typeof(SearchHistory));
                ser.Serialize(fs, hist);
            }
        }

        /// <summary>
        /// plɑ݂錻݂̏t@CɃZ[u
        /// </summary>
        /// <param name="filename">t@C̃pXBnullȂftHg"LastSearch.xml"gpB</param>
        public void SaveSearchCond(string filename)
        {
            if (filename == null)
            {
                filename = Program.SettingDir + @"\LastSearch.xml";
            }
            SearchConditions cond = this.condPanel.GetConditions();
            using (FileStream fs = new FileStream(filename, FileMode.Create))
            {
                XmlSerializer ser = new XmlSerializer(typeof(SearchConditions));
                //SoapFormatter ser = new SoapFormatter();
                ser.Serialize(fs, cond);
            }
        }

        protected void OnSaveConfig(XmlTextWriter xmlOut)
        {
            // DockStateݒt@Cւ̒ǉo
            xmlOut.WriteStartElement("WindowLocation");
            xmlOut.WriteAttributeString("X", String.Format("{0}", this.Bounds.X));
            xmlOut.WriteAttributeString("Y", String.Format("{0}", this.Bounds.Y));
            xmlOut.WriteAttributeString("Width", String.Format("{0}", this.Bounds.Width));
            xmlOut.WriteAttributeString("Height", String.Format("{0}", this.Bounds.Height));
            xmlOut.WriteAttributeString("SplitterHeight", String.Format("{0}", this.kwicView.SplitterDistance));
            xmlOut.WriteEndElement();
        }

        protected void OnLoadConfig(XmlTextReader xmlIn)
        {
            // DockStateݒt@Cǂݍ񂾎_ł̒ǉ̏
            if (xmlIn.Name == "WindowLocation")
            {
                int x = 0;
                int y = 0;
                int width = 0;
                int height = 0;
                int splitterHeight = 0;
                bool b = true;
                b = b && Int32.TryParse(xmlIn.GetAttribute("X"), out x);
                b = b && Int32.TryParse(xmlIn.GetAttribute("Y"), out y);
                b = b && Int32.TryParse(xmlIn.GetAttribute("Width"), out width);
                b = b && Int32.TryParse(xmlIn.GetAttribute("Height"), out height);
                b = b && Int32.TryParse(xmlIn.GetAttribute("SplitterHeight"), out splitterHeight);
                if (b)
                {
                    this.Bounds = new Rectangle(x, y, width, height);
                    this.kwicView.Panel1Collapsed = false;
                    this.kwicView.Panel2Collapsed = false;
                    this.kwicView.SplitterDistance = splitterHeight;
                }

                xmlIn.Read();
            }
        }

        /// <summary>
        /// 1. ̃qXgɏplč\B
        /// 2. Kwic/WordList/Collocatioñr[؂ւB
        /// 3. r[̒gNAB
        /// 4. qXgZ[uf[^ւ̃pXĂViewɃ[hB
        /// </summary>
        /// <param name="hist"></param>
        public void NavigateHistoryHandler(SearchHistory hist)
        {
            SearchConditions cond = hist.CondSeq.Last;
            // ChangeModeĺAcondɃRs[𐶐ACondPanelModelɃATCBɃJgɃZbg.
            this.m_Model.CurrentSearchConditions = this.condPanel.ChangeModel(cond);
            this.commandPanel.SetModel(hist.Progress);
            this.kwicView.SetModel(hist.KwicList);
            this.wordListView.SetModel(hist.LexemeList);

            // ɓKView&^uɐ؂ւ
            ChangeView(cond.ActiveSearch);

            switch (cond.ActiveSearch)
            {
                case SearchType.SentenceSearch:
                    this.condPanel.SelectedTab = ConditionsPanelType.CP_CORPUS;
                    break;
                case SearchType.StringSearch:
                    this.condPanel.SelectedTab = ConditionsPanelType.CP_STRING;
                    break;
                case SearchType.TagSearch:
                case SearchType.TagWordList:
                    this.condPanel.SelectedTab = ConditionsPanelType.CP_TAG;
                    break;
                case SearchType.DepSearch:
                case SearchType.DepWordList:
                    this.condPanel.SelectedTab = ConditionsPanelType.CP_DEP;
                    break;
            }
        }

        /// <summary>
        /// Historyt@CɃZ[u.
        /// </summary>
        /// <param name="sender">SearchHistory</param>
        /// <param name="args"></param>
        public void SaveHistoryHandler(object sender, EventArgs args)
        {
            SearchHistory hist = sender as SearchHistory;
            SaveFileDialog dlg = new SaveFileDialog();
            if (dlg.ShowDialog() == DialogResult.OK)
            {
                Save(dlg.FileName, hist);
                hist.FilePath = dlg.FileName;
            }
        }

        /// <summary>
        /// History폜.
        /// </summary>
        /// <param name="sender">SearchHistory</param>
        /// <param name="args"></param>
        public void DeleteHistoryHandler(object sender, EventArgs args)
        {
            SearchHistory hist = sender as SearchHistory;
            m_Model.DeleteHistory(hist);
            this.historyGuidePanel.UpdateView();
        }

        /// <summary>
        /// listindexԖڂ̕ɑ΂āȂO̕Context Panelɕ\B
        /// </summary>
        /// <param name="list"></param>
        /// <param name="index"></param>
        public void RequestContextHandler(KwicList list, int index)
        {
            Corpus crps = list.Records[index].Crps;
            int senNo = list.Records[index].SenPos;
            int count = 3;//@todo: ̓̕IvV擾

            SentenceContextService svc = new SentenceContextService(crps, senNo, count, this.contextPanel.Model);
            try
            {
                svc.Begin();
            }
            catch (Exception e)
            {
                MessageBox.Show(e.Message);
                return;
            }
            this.contextPanel.UpdateView();
        }
    }
}
