﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Text;
using System.Windows.Forms;
using ChaKi.Entity.Corpora;

namespace ChaKi.Common
{
    public partial class PropertyTree : TreeView
    {
        public PropertyTree()
        {
            InitializeComponent();

            this.Cps = null;
        }

        public Corpus Cps { get; set; }

        public void PopulateWithPOSSelections()
        {
            if (Cps != null)
            {
                this.Nodes.Clear();
                this.Nodes.Add(".*", ".*");
                foreach (KeyValuePair<string, PartOfSpeech> pair in Cps.Lex.PartsOfSpeech)
                {
                    string[] tags = new string[4] {
                        pair.Value.Name1, pair.Value.Name2, pair.Value.Name3, pair.Value.Name4};
                    AddNode(tags);
                }
            }
            this.ExpandAll();
            this.SelectedNode = null;
        }

        public void PopulateWithCTypeSelections()
        {
            if (Cps != null)
            {
                this.Nodes.Clear();
                this.Nodes.Add(".*", ".*");
                foreach (KeyValuePair<string, CType> pair in Cps.Lex.CTypes)
                {
                    string[] tags = new string[2] {
                        pair.Value.Name1, pair.Value.Name2};
                    AddNode(tags);
                }
            }
            this.ExpandAll();
            this.SelectedNode = null;
        }

        public void PopulateWithCFormSelections()
        {
            if (Cps != null)
            {
                this.Nodes.Clear();
                this.Nodes.Add(".*", ".*");
                foreach (KeyValuePair<string, CForm> pair in Cps.Lex.CForms)
                {
                    string[] tags = new string[1] { pair.Value.Name };
                    AddNode(tags);
                }
            }
            this.ExpandAll();
            this.SelectedNode = null;
        }

        /// <summary>
        /// 最大４階層のツリーを作成する
        /// </summary>
        /// <param name="pos"></param>
        private TreeNode AddNode(string[] tags)
        {
            TreeNode cur = null;
            TreeNodeCollection children = this.Nodes;
            TreeNode[] found;
            for (int n = 0; n < tags.Length; n++)
            {
                // 第n階層
                if (tags[n] == null || tags[n].Length == 0)
                {
                    break;
                }
                found = children.Find(tags[n], false);
                if (found.Length == 0)  // not found
                {
                    cur = children.Add(tags[n], tags[n]);
                }
                else
                {
                    cur = found[0];
                }
                children = cur.Nodes;
            }
            return cur;
        }
    }
}
