package jp.sourceforge.cfneo.at4ie2.api.test.impl;

import static org.junit.Assert.*;
import jp.sourceforge.cfneo.at4ie2.api.test.CommandEnum;
import jp.sourceforge.cfneo.at4ie2.api.test.TestCase;
import jp.sourceforge.cfneo.at4ie2.api.test.TestCaseList;

import org.junit.Test;

public class DefaultTestCaseListTest {

	@Test
	public void testAddTestCase() {
		TestCaseList list = this.createTestData();
		assertEquals(5, list.size());
		list.addTestCase(6, CommandEnum.DUMMY, "", "");
		assertEquals(6, list.size());
	}
	@Test
	public void testGetTestCase() {
		TestCaseList list = this.createTestData();
		TestCase case1 = list.getTestCase(0);
		assertEquals(CommandEnum.DUMMY, case1.getCommand());
		assertEquals("id=a", case1.getTarget().getTargetStream());
		assertEquals("1", case1.getValue());
		TestCase case2 = list.getTestCase(1);
		assertEquals(CommandEnum.DUMMY, case2.getCommand());
		assertEquals("name=b", case2.getTarget().getTargetStream());
		assertEquals("2", case2.getValue());
	}

	private DefaultTestCaseList createTestData() {
		DefaultTestCaseList list = new DefaultTestCaseList(
				DefaultContext.getInstance());
		list.addTestCase(1, CommandEnum.DUMMY, "id=a", "1");
		list.addTestCase(2, CommandEnum.DUMMY, "name=b", "2");
		list.addTestCase(3, CommandEnum.DUMMY, "identifier=c", "3");
		list.addTestCase(4, CommandEnum.DUMMY, "xpath=d", "4");
		list.addTestCase(5, CommandEnum.DUMMY, "link=e", "5");
		return list;
	}

}
