package jp.sourceforge.cfneo.at4ie2;

import static org.junit.Assert.assertEquals;

import java.util.List;

import jp.sourceforge.cfneo.at4ie2.api.browser.Browser;
import jp.sourceforge.cfneo.at4ie2.api.browser.CheckBox;
import jp.sourceforge.cfneo.at4ie2.api.browser.impl.ie.BTInternetExplorer;

import org.junit.Test;

public class BrowserIntegrationTest3 {

	@Test
	public void test() {
		Browser browser = new BTInternetExplorer();
		browser.open(TestSupport.TARGET_PATH + TestSupport.TARGET_FILE);

		/*
		 * Checkbox
		 */
		CheckBox checkBox1 = browser.getCheckBoxByName("check1");
		assertEquals("1", checkBox1.getValue());
		CheckBox checkBox2 = browser.getCheckBox("chk2");
		assertEquals("2", checkBox2.getValue());
		List<CheckBox> checkBoxList1 = browser.getCheckBoxListByName("check1");
		assertEquals(0, browser.getCheckedCheckBoxByName("check1").size());
		checkBoxList1.get(0).check();
		checkBoxList1.get(2).check();
		assertEquals(2, browser.getCheckedCheckBoxByName("check1").size());
		List<CheckBox> checkedList = browser.getCheckedCheckBoxByName("check1");
		assertEquals(2, browser.getCheckedCheckBoxByName("check1").size());
		assertEquals("1", checkedList.get(0).getValue());
		assertEquals("3", checkedList.get(1).getValue());
		checkedList.get(1).unCheck();
		assertEquals(1, browser.getCheckedCheckBoxByName("check1").size());

		browser.close();
	}

}
