package jp.sourceforge.cfneo.at4ie2.utils;

import java.util.List;

import jp.sourceforge.cfneo.at4ie2.api.test.LocatorTypeEnum;

public class StringUtil {

	static String DELIMITER = "=";

	public static boolean isNumeric(String s) {
		if (isInteger(s) == false) {
			return isDouble(s);
		}
		return true;
	}

	public static boolean isInteger(String s) {
		try {
			new Long(s);
			return true;
		} catch (NumberFormatException e) {
			return false;
		}
	}

	public static boolean isDouble(String s) {
		try {
			new Double(s);
			return true;
		} catch (NumberFormatException e) {
			return false;
		}
	}

	public static boolean isLocatorFormat(String value) {
		if (LocatorTypeEnum.OTHER != getLocatorType(value)) {
			return true;
		}
		return false;
	}

	public static LocatorTypeEnum getLocatorType(String value) {
		if (value == null) {
			return LocatorTypeEnum.OTHER;
		}
		if (value.trim().length() == 0) {
			return LocatorTypeEnum.OTHER;
		}
		int first = value.indexOf(DELIMITER);
		if (first <= 0) {
			return LocatorTypeEnum.OTHER;
		}
		return LocatorTypeEnum.get(value.split(DELIMITER)[0]);
	}

	public static String getLocatorValue(String value) {
		if (value == null) {
			return null;
		}
		if (value.trim().length() == 0) {
			return value;
		}
		LocatorTypeEnum locator = getLocatorType(value);
		if (LocatorTypeEnum.OTHER == locator) {
			return value;
		}
		int p = value.indexOf(DELIMITER);
		return value.substring(p + 1, value.length()).trim();
	}

	public static String[] splitComma(String value) {
		String[] returnValue = value.split(",");
		for (int i = 0; i < returnValue.length; i++) {
			returnValue[i] = returnValue[i].trim();
		}
		return returnValue;
	}

	public static String createLine(String[] array) {
		StringBuffer sb = new StringBuffer();
		for (String s: array) {
			sb.append(s).append(",");
		}
		return sb.toString().substring(0, sb.length() - 1);
	}

	public static String createLine(List<String> list) {
		StringBuffer sb = new StringBuffer();
		for (String s: list) {
			sb.append(s).append(",");
		}
		return sb.toString().substring(0, sb.length() - 1);
	}

}
