package jp.sourceforge.cfneo.at4ie2.api.test.impl.invoker;

import jp.sourceforge.cfneo.at4ie2.api.test.AbstractInvoker;
import jp.sourceforge.cfneo.at4ie2.api.test.BTAssertException;
import jp.sourceforge.cfneo.at4ie2.api.test.CommandEnum;
import jp.sourceforge.cfneo.at4ie2.api.test.Context;
import jp.sourceforge.cfneo.at4ie2.api.test.TestCase;

public class VerifyProxyInvoker extends AbstractInvoker {

	public VerifyProxyInvoker(Context context) {
		super(context);
	}

	@Override
	public void invoke(TestCase testCase) {
		String key = testCase.getCommand().toString().replaceAll("verify", "assert");
		CommandEnum newCommand = CommandEnum.get(key);
		try {
			this.getContext().getInvokerFactory().getInvoker(newCommand).invoke(testCase);
		} catch (BTAssertException e) {
			this.getContext().getResultLogger().writeResult(e);
		}
	}

}
