package jp.sourceforge.cfneo.at4ie2.api.test.impl.invoker;

import jp.sourceforge.cfneo.at4ie2.api.browser.HtmlDataComponent;
import jp.sourceforge.cfneo.at4ie2.api.test.AbstractInvoker;
import jp.sourceforge.cfneo.at4ie2.api.test.BTAssertException;
import jp.sourceforge.cfneo.at4ie2.api.test.Context;
import jp.sourceforge.cfneo.at4ie2.api.test.LocatorTypeEnum;
import jp.sourceforge.cfneo.at4ie2.api.test.TestCase;

import org.apache.log4j.Logger;

public class AssertValueInvoker extends AbstractInvoker {

	Logger logger = Logger.getLogger(AssertValueInvoker.class);

	public AssertValueInvoker(Context context) {
		super(context);
	}

	@Override
	public void invoke(TestCase testCase) {
		String expected = testCase.getValue();

		LocatorTypeEnum locatorType = testCase.getTarget().getLocatorType();
		HtmlDataComponent htmlDataComponent = null;
		switch (locatorType) {
		case DOM:
			break;
		case ID:
			htmlDataComponent = this.getBrowser().getHtmlDataComponent(testCase.getTarget().getValue());
			break;
		case IDENTIFIER:
			htmlDataComponent = this.getBrowser().getHtmlDataComponent(testCase.getTarget().getValue());
			if (htmlDataComponent.exists() == false) {
				htmlDataComponent = this.getBrowser().gethtmlDataComponentByName(testCase.getTarget().getValue());
			}
			break;
		case LINK:
			break;
		case NAME:
			htmlDataComponent = this.getBrowser().gethtmlDataComponentByName(testCase.getTarget().getValue());
			break;
		case OTHER:
			break;
		case VALUE:
			break;
		case XPATH:
			break;
		default:
			;
		}

		String actual = htmlDataComponent.getValue();
		logger.debug("AssertValueInvoker#invoke ... expected=[" + expected + "]/actual=[" + actual + "]");
		if (expected.equals(actual) == false) {
			throw new BTAssertException(expected, actual);
		}
	}

}
