package jp.sourceforge.cfneo.at4ie2.api.test.impl.invoker;

import org.apache.log4j.Logger;

import jp.sourceforge.cfneo.at4ie2.api.test.AbstractInvoker;
import jp.sourceforge.cfneo.at4ie2.api.test.BTAssertException;
import jp.sourceforge.cfneo.at4ie2.api.test.Context;
import jp.sourceforge.cfneo.at4ie2.api.test.TestCase;

public class AssertLocationInvoker extends AbstractInvoker {

	Logger logger = Logger.getLogger(AssertLocationInvoker.class);

	public AssertLocationInvoker(Context context) {
		super(context);
	}

	@Override
	public void invoke(TestCase testCase) {
		String expected = testCase.getTarget().getTargetStream();
		String actual = this.getBrowser().getUrl();
		logger.debug("AssertLocationInvoker#invoke ... expected=[" + expected + "]/actual=[" + actual + "]");
		if (expected.equals(actual) == false) {
			throw new BTAssertException(expected, actual);
		}
	}

}
