package jp.sourceforge.cfneo.at4ie2.api.test.impl;

import org.apache.log4j.Logger;

import jp.sourceforge.cfneo.at4ie2.BTRuntimeError;
import jp.sourceforge.cfneo.at4ie2.api.test.TestCase;
import jp.sourceforge.cfneo.at4ie2.api.test.TestCaseList;
import jp.sourceforge.cfneo.at4ie2.api.test.TestRunner;

public class DefaultTestRunner implements TestRunner {

	Logger logger = Logger.getLogger(DefaultTestRunner.class);

	TestCaseList testCaseList;

	public DefaultTestRunner(TestCaseList testCaseList) {
		this.testCaseList = testCaseList;
	}

	@Override
	public void run() {
		try {
			DefaultContext.getInstance().getResultLogger().resetLog();
			for (int row = 0; row < this.testCaseList.size(); row++) {
				TestCase testCase = this.testCaseList.getTestCase(row);
				logger.debug(testCase);
				testCase.doTest();
			}
		} catch (BTRuntimeError e) {
			DefaultContext.getInstance().getResultLogger().writeResult(e.getMessage());
			throw e;
		} finally {
			logger.info("******************************");
			logger.info("***** Result log - start *****");
			logger.info(DefaultContext.getInstance().getResultLogger().readResult());
			logger.info("***** Result log - end   *****");
			logger.info("******************************");
		}
	}

}
