package jp.sourceforge.cfneo.at4ie2.api.test.impl;

import jp.sourceforge.cfneo.at4ie2.api.test.LocatorTypeEnum;
import jp.sourceforge.cfneo.at4ie2.api.test.Target;
import jp.sourceforge.cfneo.at4ie2.utils.StringUtil;

public class DefaultTarget implements Target {

	static String DELIMITER = "=";

	private String targetStream;
	private LocatorTypeEnum location;
	private String value;

	public DefaultTarget(String targetStream) {
		this.targetStream = targetStream;
		this.location = StringUtil.getLocatorType(targetStream);
		this.value = StringUtil.getLocatorValue(targetStream);
	}

	@Override
	public String toString() {
		return "location=[" + this.location.toString()
				+ "] value=[" + this.value
				+ "] targetStream=" + this.targetStream;
	}
	@Override
	public LocatorTypeEnum getLocatorType() {
		return this.location;
	}
	@Override
	public String getTargetStream() {
		return this.targetStream;
	}
	@Override
	public String getValue() {
		return value;
	}

}
