package jp.sourceforge.cfneo.at4ie2.api.test.impl;

import java.util.HashMap;
import java.util.Map;

import jp.sourceforge.cfneo.at4ie2.api.test.CommandEnum;
import jp.sourceforge.cfneo.at4ie2.api.test.CommandInvoker;
import jp.sourceforge.cfneo.at4ie2.api.test.DummyInvoker;
import jp.sourceforge.cfneo.at4ie2.api.test.TesterMap;
import jp.sourceforge.cfneo.at4ie2.api.test.impl.invoker.AssertAlertInvoker;
import jp.sourceforge.cfneo.at4ie2.api.test.impl.invoker.AssertLocationInvoker;
import jp.sourceforge.cfneo.at4ie2.api.test.impl.invoker.AssertSelectOptionsInvoker;
import jp.sourceforge.cfneo.at4ie2.api.test.impl.invoker.AssertSelectedInvoker;
import jp.sourceforge.cfneo.at4ie2.api.test.impl.invoker.AssertTextInvoker;
import jp.sourceforge.cfneo.at4ie2.api.test.impl.invoker.AssertTitleInvoker;
import jp.sourceforge.cfneo.at4ie2.api.test.impl.invoker.AssertValueInvoker;
import jp.sourceforge.cfneo.at4ie2.api.test.impl.invoker.ClickAndWaitInvoker;
import jp.sourceforge.cfneo.at4ie2.api.test.impl.invoker.ClickInvoker;
import jp.sourceforge.cfneo.at4ie2.api.test.impl.invoker.CloseInvoker;
import jp.sourceforge.cfneo.at4ie2.api.test.impl.invoker.GoBackInvoker;
import jp.sourceforge.cfneo.at4ie2.api.test.impl.invoker.OpenInvoker;
import jp.sourceforge.cfneo.at4ie2.api.test.impl.invoker.PauseInvoker;
import jp.sourceforge.cfneo.at4ie2.api.test.impl.invoker.ScreenShotInvoker;
import jp.sourceforge.cfneo.at4ie2.api.test.impl.invoker.SelectInvoker;
import jp.sourceforge.cfneo.at4ie2.api.test.impl.invoker.StoreInvoker;
import jp.sourceforge.cfneo.at4ie2.api.test.impl.invoker.StoreTextInvoker;
import jp.sourceforge.cfneo.at4ie2.api.test.impl.invoker.StoreValueInvoker;
import jp.sourceforge.cfneo.at4ie2.api.test.impl.invoker.TypeInvoker;
import jp.sourceforge.cfneo.at4ie2.api.test.impl.invoker.UnsupportCommandInvoker;
import jp.sourceforge.cfneo.at4ie2.api.test.impl.invoker.VerifyProxyInvoker;

public class DefaultInvokerMap implements TesterMap {

	static DefaultInvokerMap _instance;

	public static DefaultInvokerMap getInstance() {
		if (_instance == null) {
			_instance = new DefaultInvokerMap();
		}
		return _instance;
	}

	DefaultInvokerMap() {
		setup();
	}

	private Map<CommandEnum, Class<? extends CommandInvoker>> invokerMap;

	@Override
	public Class<? extends CommandInvoker> getInvokerClass(CommandEnum command) {
		return this.invokerMap.get(command);
	}

	protected void setup() {
		this.invokerMap = new HashMap<CommandEnum, Class<? extends CommandInvoker>>();
		/*
		 * nR}hB
		 */
		// OPEN("open"),
		this.invokerMap.put(CommandEnum.OPEN, OpenInvoker.class);
		// CLICK("click"),
		this.invokerMap.put(CommandEnum.CLICK, ClickInvoker.class);
		// CLICK_AND_WAIT("clickAndWait"),
		this.invokerMap.put(CommandEnum.CLICK_AND_WAIT, ClickAndWaitInvoker.class);
		// TYPE("type"),
		this.invokerMap.put(CommandEnum.TYPE, TypeInvoker.class);
		// SELECT("select"),
		this.invokerMap.put(CommandEnum.SELECT, SelectInvoker.class);
		// TODO	SELECT_WINDOW("selectWindow"),
		this.invokerMap.put(CommandEnum.SELECT_WINDOW, DummyInvoker.class);
		// GO_BACK("goBack"),
		this.invokerMap.put(CommandEnum.GO_BACK, GoBackInvoker.class);
		// CLOSE("close"),
		this.invokerMap.put(CommandEnum.CLOSE, CloseInvoker.class);
		// PAUSE("pause"),
		this.invokerMap.put(CommandEnum.PAUSE, PauseInvoker.class);
		// TODO	FIRE_EVENT("fireEvent"),
		this.invokerMap.put(CommandEnum.FIRE_EVENT, DummyInvoker.class);
		// TODO	WAIT_FOR_VALUE("waitForValue"),
		this.invokerMap.put(CommandEnum.WAIT_FOR_VALUE, DummyInvoker.class);
		// STORE("store"),
		this.invokerMap.put(CommandEnum.STORE, StoreInvoker.class);
		// STORE_VALUE("storeValue"),
		this.invokerMap.put(CommandEnum.STORE_VALUE, StoreValueInvoker.class);
		// STORE_TEXT("storeText"),
		this.invokerMap.put(CommandEnum.STORE_TEXT, StoreTextInvoker.class);
		// TODO	STORE_ATTRIBUTE("storeAttribute"),
		this.invokerMap.put(CommandEnum.STORE_ATTRIBUTE, DummyInvoker.class);
		// TODO	CHOOSE_CANCEL_ON_NEXT_CONFIRMATION("chooseCancelOnNextConfirmation"),
		this.invokerMap.put(CommandEnum.CHOOSE_CANCEL_ON_NEXT_CONFIRMATION, DummyInvoker.class);
		// TODO	ANSWER_ON_NEXT_PROMPT("answerOnNextPrompt"),
		this.invokerMap.put(CommandEnum.ANSWER_ON_NEXT_PROMPT, DummyInvoker.class);
		// TODO	CLICK_ALERT_DIALOG_OK("clickAlertDialogOk"),
		this.invokerMap.put(CommandEnum.CLICK_ALERT_DIALOG_OK, DummyInvoker.class);

		/*
		 * nR}h(assert)B
		 */
		// ASSERT_LOCATION("assertLocation"),
		this.invokerMap.put(CommandEnum.ASSERT_LOCATION, AssertLocationInvoker.class);
		// ASSERT_TITLE("assertTitle"),
		this.invokerMap.put(CommandEnum.ASSERT_TITLE, AssertTitleInvoker.class);
		// ASSERT_VALUE("assertValue"),
		this.invokerMap.put(CommandEnum.ASSERT_VALUE, AssertValueInvoker.class);
		// ASSERT_SELECTED("assertSelected"),
		this.invokerMap.put(CommandEnum.ASSERT_SELECTED, AssertSelectedInvoker.class);
		// ASSERT_SELECTED_OPTIONS("assertSelectOptions"),
		this.invokerMap.put(CommandEnum.ASSERT_SELECTED_OPTIONS, AssertSelectOptionsInvoker.class);
		// ASSERT_TEXT("assertText"),
		this.invokerMap.put(CommandEnum.ASSERT_TEXT, AssertTextInvoker.class);
		// TODO	ASSERT_ATTRIBUTE("assertAttribute"),
		this.invokerMap.put(CommandEnum.ASSERT_ATTRIBUTE, DummyInvoker.class);
		// TODO	ASSERT_TEXT_PRESENT("assertTextPresent"),
		this.invokerMap.put(CommandEnum.ASSERT_TEXT_PRESENT, DummyInvoker.class);
		// TODO	ASSERT_TEXT_NOT_PRESENT("ssertTextNotPresent"),
		this.invokerMap.put(CommandEnum.ASSERT_TEXT_NOT_PRESENT, DummyInvoker.class);
		// TODO	ASSERT_ELEMENT_PRESENT("assertElementPresent"),
		this.invokerMap.put(CommandEnum.ASSERT_ELEMENT_PRESENT, DummyInvoker.class);
		// TODO	ASSERT_ELEMENT_NOT_PRESENT("assertElementNotPresent"),
		this.invokerMap.put(CommandEnum.ASSERT_ELEMENT_NOT_PRESENT, DummyInvoker.class);
		// TODO	ASSERT_TABLE("assertTable"),
		this.invokerMap.put(CommandEnum.ASSERT_TABLE, DummyInvoker.class);
		// TODO	ASSERT_VISIBLE("assertVisible"),
		this.invokerMap.put(CommandEnum.ASSERT_VISIBLE, DummyInvoker.class);
		// TODO	ASSERT_NOT_VISIBLE("assertNotVisible"),
		this.invokerMap.put(CommandEnum.ASSERT_NOT_VISIBLE, DummyInvoker.class);
		// TODO	ASSERT_EDIT_TABLE("assertEditable"),
		this.invokerMap.put(CommandEnum.ASSERT_EDIT_TABLE, DummyInvoker.class);
		// TODO	ASSERT_NOT_EDIT_TABLE("assertNotEditable"),
		this.invokerMap.put(CommandEnum.ASSERT_NOT_EDIT_TABLE, DummyInvoker.class);
		// ASSERT_ALERT("assertAlert"),
		this.invokerMap.put(CommandEnum.ASSERT_ALERT, AssertAlertInvoker.class);
		// TODO	ASSERT_CONFIRMATION("assertConfirmation"),
		this.invokerMap.put(CommandEnum.ASSERT_CONFIRMATION, DummyInvoker.class);
		// TODO	ASSERT_PROMPT("assertPrompt"),
		this.invokerMap.put(CommandEnum.ASSERT_PROMPT, DummyInvoker.class);

		/*
		 * nR}h(verify)B
		 */
		// VERIFY_LOCATION("verifyLocation"),
		this.invokerMap.put(CommandEnum.VERIFY_LOCATION, VerifyProxyInvoker.class);
		// VERIFY_TITLE("verifyTitle"),
		this.invokerMap.put(CommandEnum.VERIFY_TITLE, VerifyProxyInvoker.class);
		// VERIFY_VALUE("verifyValue"),
		this.invokerMap.put(CommandEnum.VERIFY_VALUE, VerifyProxyInvoker.class);
		// VERIFY_SELECTED("verifySelected"),
		this.invokerMap.put(CommandEnum.VERIFY_SELECTED, VerifyProxyInvoker.class);
		// VERIFY_SELECTED_OPTIONS("verifySelectOptions"),
		this.invokerMap.put(CommandEnum.VERIFY_SELECTED_OPTIONS, VerifyProxyInvoker.class);
		// VERIFY_TEXT("verifyText"),
		this.invokerMap.put(CommandEnum.VERIFY_TEXT, VerifyProxyInvoker.class);
		// VERIFY_ATTRIBUTE("verifyAttribute"),
		this.invokerMap.put(CommandEnum.VERIFY_ATTRIBUTE, VerifyProxyInvoker.class);
		// VERIFY_TEXT_PRESENT("verifyTextPresent"),
		this.invokerMap.put(CommandEnum.VERIFY_TEXT_PRESENT, VerifyProxyInvoker.class);
		// VERIFY_TEXT_NOT_PRESENT("ssertTextNotPresent"),
		this.invokerMap.put(CommandEnum.VERIFY_TEXT_NOT_PRESENT, VerifyProxyInvoker.class);
		// VERIFY_ELEMENT_PRESENT("verifyElementPresent"),
		this.invokerMap.put(CommandEnum.VERIFY_ELEMENT_PRESENT, VerifyProxyInvoker.class);
		// VERIFY_ELEMENT_NOT_PRESENT("verifyElementNotPresent"),
		this.invokerMap.put(CommandEnum.VERIFY_ELEMENT_NOT_PRESENT, VerifyProxyInvoker.class);
		// VERIFY_TABLE("verifyTable"),
		this.invokerMap.put(CommandEnum.VERIFY_TABLE, VerifyProxyInvoker.class);
		// VERIFY_VISIBLE("verifyVisible"),
		this.invokerMap.put(CommandEnum.VERIFY_VISIBLE, VerifyProxyInvoker.class);
		// VERIFY_NOT_VISIBLE("verifyNotVisible"),
		this.invokerMap.put(CommandEnum.VERIFY_NOT_VISIBLE, VerifyProxyInvoker.class);
		// VERIFY_EDIT_TABLE("verifyEditable"),
		this.invokerMap.put(CommandEnum.VERIFY_EDIT_TABLE, VerifyProxyInvoker.class);
		// VERIFY_NOT_EDIT_TABLE("verifyNotEditable"),
		this.invokerMap.put(CommandEnum.VERIFY_NOT_EDIT_TABLE, VerifyProxyInvoker.class);
		// VERIFY_ALERT("verifyAlert"),
		this.invokerMap.put(CommandEnum.VERIFY_ALERT, VerifyProxyInvoker.class);
		// VERIFY_CONFIRMATION("verifyConfirmation"),
		this.invokerMap.put(CommandEnum.VERIFY_CONFIRMATION, VerifyProxyInvoker.class);
		// VERIFY_PROMPT("verifyPrompt"),
		this.invokerMap.put(CommandEnum.VERIFY_PROMPT, VerifyProxyInvoker.class);

		/*
		 * IWiR}hB
		 */
		// WAIT("wait"),
		this.invokerMap.put(CommandEnum.WAIT, PauseInvoker.class);
		// SCREEN_SHOT("screenshot"),
		this.invokerMap.put(CommandEnum.SCREEN_SHOT, ScreenShotInvoker.class);
		// TODO	INJECTION("injection")
		this.invokerMap.put(CommandEnum.INJECTION, DummyInvoker.class);
		// UNKNOWN("unknown")
		this.invokerMap.put(CommandEnum.UNKNOWN, UnsupportCommandInvoker.class);
	}

}
