package jp.sourceforge.cfneo.at4ie2.api.browser.impl.ie;

import java.util.ArrayList;
import java.util.List;

import jp.sourceforge.cfneo.at4ie2.BTRuntimeError;
import jp.sourceforge.cfneo.at4ie2.api.browser.MonoRadio;
import jp.sourceforge.cfneo.at4ie2.api.browser.Radio;
import watij.elements.Radios;
import watij.finders.SymbolFactory;

public class BTRadio implements Radio {

	Radios radios;

	BTRadio(Radios radios) {
		this.radios = radios;
	}

	@Override
	public boolean exists() {
		try {
			if (this.radios == null || this.radios.length() == 0) {
				return false;
			}
			return true;
		} catch (Exception e) {
			throw new BTRuntimeError(e);
		}
	}
	@Override
	@Deprecated
	public String getId() {
		return null;
	}
	@Override
	public int getCount() {
		try {
			return this.radios.length();
		} catch (Exception e) {
			throw new BTRuntimeError(e);
		}
	}
	@Override
	public String getName() {
		try {
			return this.radios.get(0).name();
		} catch (Exception e) {
			throw new BTRuntimeError(e);
		}
	}
	@Override
	public String getValue() {
		try {
			for (watij.elements.Radio radio: this.radios) {
				if (radio.checked()) {
					return radio.value();
				}
			}
			return null;
		} catch (Exception e) {
			throw new BTRuntimeError(e);
		}
	}
	@Override
	public List<String> getIdList() {
		try {
			List<String> idList = new ArrayList<String>();
			for (watij.elements.Radio radio: this.radios) {
				idList.add(radio.id());
			}
			return idList;
		} catch (Exception e) {
			throw new BTRuntimeError(e);
		}
	}
	@Override
	public List<MonoRadio> getMonoRadioList() {
		try {
			List<MonoRadio> radioList = new ArrayList<MonoRadio>();
			for (watij.elements.Radio radio: this.radios) {
				radioList.add(new BTMonoRadio(radio));
			}
			return radioList;
		} catch (Exception e) {
			throw new BTRuntimeError(e);
		}
	}
	@Override
	public void check(String value) {
		try {
			this.radios.radio(SymbolFactory.value, value).checked();
		} catch (Exception e) {
			throw new BTRuntimeError(e);
		}
	}

}
