/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper;

import com.jniwrapper.DefaultLibraryLoader;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public class JNIWrapperInfo {
    public static final String JAR_LOCATION = "jniwrapper.jar";
    public static final String JAR_VERSION = "jniwrapper.jar.version";
    public static final String JAR_BUILD = "jniwrapper.jar.build";
    public static final String LIBRARY_LOCATION = "jniwrapper.library";
    public static final String LIBRARY_VERSION = "jniwrapper.library.version";

    public static Map getProperties() {
        HashMap hashMap = new HashMap();
        hashMap.putAll(JNIWrapperInfo.a());
        hashMap.putAll(JNIWrapperInfo.b());
        return Collections.unmodifiableMap(hashMap);
    }

    private static Map a() {
        String string = System.getProperty("java.class.path");
        String string2 = System.getProperty("path.separator");
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken().toLowerCase();
            if (string3.indexOf("jniwrap") == -1 || !string3.toLowerCase().endsWith(".jar")) continue;
            return JNIWrapperInfo.a(string3);
        }
        return Collections.EMPTY_MAP;
    }

    private static Map a(String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(JAR_LOCATION, "NotFound");
        hashMap.put(JAR_VERSION, "NotFound");
        hashMap.put(JAR_BUILD, "NotFound");
        try {
            JarFile jarFile = new JarFile(string);
            Manifest manifest = jarFile.getManifest();
            Attributes attributes = manifest.getMainAttributes();
            hashMap.put(JAR_LOCATION, string);
            hashMap.put(JAR_VERSION, attributes.getValue("Version"));
            hashMap.put(JAR_BUILD, attributes.getValue("Build"));
            jarFile.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return hashMap;
    }

    private static Map b() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(LIBRARY_LOCATION, "NotFound");
        hashMap.put(LIBRARY_VERSION, "NotFound");
        try {
            File file = DefaultLibraryLoader.getInstance().findLibrary("jniwrap");
            if (file != null) {
                hashMap.put(LIBRARY_LOCATION, file.getAbsolutePath());
                hashMap.put(LIBRARY_VERSION, "3.6");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return hashMap;
    }
}

