/*
 * Decompiled with CFR 0.152.
 */
package watij.runtime.ie;

import com.jniwrapper.AnsiString;
import com.jniwrapper.Function;
import com.jniwrapper.Int;
import com.jniwrapper.Int32;
import com.jniwrapper.IntegerParameter;
import com.jniwrapper.Library;
import com.jniwrapper.Parameter;
import com.jniwrapper.Pointer;
import com.jniwrapper.UInt;
import com.jniwrapper.win32.automation.IDispatch;
import com.jniwrapper.win32.automation.OleMessageLoop;
import com.jniwrapper.win32.automation.types.Variant;
import com.jniwrapper.win32.automation.types.VariantBool;
import com.jniwrapper.win32.com.IUnknown;
import com.jniwrapper.win32.com.impl.IUnknownImpl;
import com.jniwrapper.win32.ie.AuthenticateHandler;
import com.jniwrapper.win32.ie.IEAutomation;
import com.jniwrapper.win32.ie.KeyFilter;
import com.jniwrapper.win32.ie.ReadyState;
import com.jniwrapper.win32.ie.WebBrowser;
import com.jniwrapper.win32.ie.command.BrowserCommand;
import com.jniwrapper.win32.ie.dom.Cookie;
import com.jniwrapper.win32.ie.dom.DomFactory;
import com.jniwrapper.win32.ie.dom.HTMLDocument;
import com.jniwrapper.win32.ie.dom.HTMLElement;
import com.jniwrapper.win32.ie.event.DialogEventHandler;
import com.jniwrapper.win32.ie.event.IEApplicationEventListener;
import com.jniwrapper.win32.ie.event.NavigationEventListener;
import com.jniwrapper.win32.ie.event.NewWindowEventHandler;
import com.jniwrapper.win32.ie.event.NewWindowEventListener;
import com.jniwrapper.win32.ie.event.ScriptErrorListener;
import com.jniwrapper.win32.ie.event.StatusCode;
import com.jniwrapper.win32.ie.event.StatusEventListener;
import com.jniwrapper.win32.ie.event.WebBrowserEventsHandler;
import com.jniwrapper.win32.mshtml.IHTMLDocument2;
import com.jniwrapper.win32.mshtml.impl.IHTMLDocument2Impl;
import com.jniwrapper.win32.shdocvw.IWebBrowser2;
import com.jniwrapper.win32.ui.Wnd;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.imageio.ImageIO;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import watij.WatijBrowser;
import watij.dialogs.AlertDialog;
import watij.dialogs.ConfirmDialog;
import watij.dialogs.FileDownloadDialog;
import watij.dialogs.ModalDialog;
import watij.dialogs.PromptDialog;
import watij.elements.HtmlElement;
import watij.finders.Symbol;
import watij.finders.TitleFinder;
import watij.finders.UrlFinder;
import watij.runtime.BrowserControllerException;
import watij.runtime.MissingWayOfFindingObjectException;
import watij.runtime.NotImplementedYetException;
import watij.runtime.ie.IEAlertDialog;
import watij.runtime.ie.IEConfirmDialog;
import watij.runtime.ie.IEContainer;
import watij.runtime.ie.IEFileDownloadDialog;
import watij.runtime.ie.IEModalDialog;
import watij.runtime.ie.IEPromptDialog;
import watij.runtime.ie.IEUtil;
import watij.time.Ready;
import watij.time.WaiterImpl;
import watij.utilities.Debug;
import watij.utilities.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IE
extends IEContainer
implements WatijBrowser {
    WebBrowser webBrowser;
    String additionalHttpHeaders;
    List<IE> childBrowsers;
    IE parentIE;
    IEEventHandler ieEventHandler;
    long hwnd;
    protected static final int TIMEOUT_NAVIGATE = 180000;
    protected static final int TIMEOUT_CHILDBROWSER = 60000;
    protected static final int TIMEOUT_WAIT_CLOSED = 10000;
    protected static final int TIMEOUT_BROWSER = 180000;
    protected static final int TIMEOUT_DOCUMENT = 180000;
    public static final String TITLE = "7".equals(System.getProperty("ie_version")) ? "Windows Internet Explorer" : "Microsoft Internet Explorer";
    public static final String WOW = "wow";

    public IE() {
    }

    protected IE(WebBrowser webBrowser, boolean init) throws Exception {
        this.webBrowser = webBrowser;
        if (init) {
            this.init();
        }
    }

    protected IE(WebBrowser webBrowser) throws Exception {
        this(webBrowser, false);
    }

    protected IE(WebBrowser webBrowser, IE parentIE) throws Exception {
        this(webBrowser);
        this.init();
        this.parentIE = parentIE;
        parentIE.childBrowsers.add(this);
    }

    @Override
    public void attach(Symbol how, String what) throws Exception {
        if (how instanceof UrlFinder) {
            this.webBrowser = IEUtil.attach(what, true);
        } else if (how instanceof TitleFinder) {
            this.webBrowser = IEUtil.attach(what, false);
        } else {
            throw new MissingWayOfFindingObjectException();
        }
        this.init();
    }

    @Override
    public void start() throws Exception {
        this.webBrowser = new IEAutomation();
        this.init();
    }

    private void init() throws Exception {
        this.hwnd = this.iWebBrowser2().getHWND().getValue();
        this.childBrowsers = new ArrayList<IE>();
        this.setupEventHandler();
        this.visible(true);
        this.waitUntilExists();
    }

    protected void setupEventHandler() {
        this.ieEventHandler = new IEEventHandler(this);
        if (this.isIEAutomationClass()) {
            ((IEAutomation)this.webBrowser).addIEApplicationEventListener((IEApplicationEventListener)this.ieEventHandler);
        }
        this.webBrowser.setEventHandler((WebBrowserEventsHandler)this.ieEventHandler);
        this.webBrowser.addNewWindowListener((NewWindowEventListener)this.ieEventHandler);
        this.webBrowser.addNavigationListener((NavigationEventListener)this.ieEventHandler);
    }

    public IWebBrowser2 iWebBrowser2() throws Exception {
        return (IWebBrowser2)this.webBrowser.getBrowserPeer();
    }

    @Override
    protected HTMLDocument htmlDocument() throws Exception {
        this.waitUntilReady();
        return this.webBrowser.getDocument();
    }

    @Override
    protected IE ie() {
        return this;
    }

    @Override
    protected OleMessageLoop oleMessageLoop() {
        return this.webBrowser.getOleMessageLoop();
    }

    @Override
    public AlertDialog alertDialog() throws Exception {
        this.bringToFront();
        return IEAlertDialog.findAlertDialog(this);
    }

    public ConfirmDialog confirmDialog() throws Exception {
        this.bringToFront();
        return IEConfirmDialog.findConfirmDialog(this);
    }

    public PromptDialog promptDialog() throws Exception {
        this.bringToFront();
        return IEPromptDialog.findPromptDialog(this);
    }

    public FileDownloadDialog fileDownloadDialog() throws Exception {
        this.bringToFront();
        return IEFileDownloadDialog.findFileDownloadDialog(this);
    }

    public FileDownloadDialog fileDownloadDialog(final String url) throws Exception {
        this.bringToFront();
        new Thread(new Runnable(){

            public void run() {
                try {
                    IE.this.goTo(url);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }).start();
        return IEFileDownloadDialog.findFileDownloadDialog(this);
    }

    @Override
    public String text() throws Exception {
        HTMLElement body = this.htmlDocument().getBody();
        return body.getText();
    }

    @Override
    public void refresh() throws Exception {
        this.webBrowser.refresh();
    }

    @Override
    public void minimize() throws Exception {
        Wnd ieWindow = this.getBrowserWindow();
        ieWindow.show(Wnd.ShowWindowCommand.SHOWMINIMIZED);
    }

    protected Wnd getBrowserWindow() throws Exception {
        return new Wnd(this.hwnd);
    }

    @Override
    public void maximize() throws Exception {
        Wnd ieWindow = this.getBrowserWindow();
        ieWindow.show(Wnd.ShowWindowCommand.SHOWMAXIMIZED);
    }

    @Override
    public void restore() throws Exception {
        Wnd ieWindow = this.getBrowserWindow();
        ieWindow.show(Wnd.ShowWindowCommand.RESTORE);
    }

    @Override
    public void navigate(String url) throws Exception {
        this.ieEventHandler.trackNavigationCompleted();
        try {
            this.webBrowser.navigate(url);
            new WaiterImpl(180000L, 200L).waitUntil(new Ready(){

                public boolean isReady() throws Exception {
                    Debug.getInstance().println("navigating");
                    return IE.this.ieEventHandler.isNavigationCompleted();
                }

                public String getNotReadyReason() {
                    return "Navigation never completed";
                }
            });
        }
        catch (Throwable t) {
            Debug.handleException(t);
        }
    }

    @Override
    public void bringToFront() throws Exception {
        IEUtil.switchToThisWindow(this.getBrowserWindow());
    }

    @Override
    public void sendKeys(String title, String keys, boolean blocking) throws Exception {
        this.bringToFront();
        IEUtil.sendKeys(title, keys, blocking, this.oleMessageLoop());
    }

    @Override
    public void sendKeys(String title, String keys) throws Exception {
        this.sendKeys(title, keys, true);
    }

    @Override
    public void sendKeys(String keys) throws Exception {
        this.sendKeys(keys, true);
    }

    @Override
    public void sendKeys(String keys, boolean blocking) throws Exception {
        this.sendKeys(this.title(), keys, blocking);
    }

    @Override
    public Object executeScript(String script) throws Exception {
        this.waitUntilReady();
        Object o = this.webBrowser.executeScript(script);
        return o;
    }

    @Override
    public void setAdditionalHttpHeaders(String additionalHttpHeaders) {
        this.additionalHttpHeaders = additionalHttpHeaders;
    }

    public String getAdditionalHttpHeaders() {
        return this.additionalHttpHeaders;
    }

    @Override
    public String html() throws Exception {
        Debug.getInstance().println("Begin IE.html()");
        this.waitUntilReady();
        String content = this.webBrowser.getContent();
        Debug.getInstance().println("End IE.html()");
        return content;
    }

    private void waitUntilExists() throws Exception {
        new WaiterImpl(180000L, 200L).waitUntil(new Ready(){

            public boolean isReady() throws Exception {
                return IE.this.exists();
            }

            public String getNotReadyReason() {
                return "Browser doesn't exist";
            }
        });
    }

    @Override
    public void waitUntilReady() throws Exception {
        Debug.getInstance().println("Begin IE.waitUntilReady()");
        this.doWaitUntilReady(180000L);
        Debug.getInstance().println("End IE.waitUntilReady()");
    }

    public void waitUntilReady(int seconds) throws Exception {
        Debug.getInstance().println("Begin IE.waitUntilReady(int seconds)");
        this.doWaitUntilReady(seconds * 1000);
        Debug.getInstance().println("End IE.waitUntilReady(int seconds)");
    }

    private void doWaitUntilReady(long timeMillis) throws Exception {
        Debug.getInstance().println("Begin IE.doWaitUntilReady(long timeMillis)");
        this.webBrowser.waitReady(timeMillis);
        this.waitUntilDocumentInitializedAndComplete();
        Debug.getInstance().println("End IE.doWaitUntilReady(long timeMillis)");
    }

    protected void waitUntilDocumentInitializedAndComplete() throws Exception {
        Debug.getInstance().println("Begin IE.waitUntilDocumentInitializedAndComplete()");
        new WaiterImpl(180000L, 200L).waitUntil(new Ready(){

            public boolean isReady() throws Exception {
                boolean notNull = IE.this.webBrowser.getDocument() != null;
                IE.this.debug("Document is null = " + !notNull);
                return notNull;
            }

            public String getNotReadyReason() {
                return "Document is null";
            }
        });
        this.waitUntilDocumentComplete(this.webBrowser.getDocument(), this.webBrowser.getOleMessageLoop());
        Debug.getInstance().println("End IE.waitUntilDocumentInitializedAndComplete()");
    }

    protected void waitUntilDocumentComplete(HTMLDocument htmlDocument, OleMessageLoop oleMessageLoop) throws Exception {
        IHTMLDocument2 ihtmlDocument2 = (IHTMLDocument2)oleMessageLoop.bindObject((IUnknown)htmlDocument.getDocumentPeer());
        IEUtil.waitUntilDocumentComplete(ihtmlDocument2);
    }

    private void checkExists() throws Exception {
        if (!this.exists()) {
            throw new BrowserControllerException("Browser Does Not Exist");
        }
    }

    protected Document document() throws Exception {
        Debug.getInstance().println("Begin IE.document()");
        Document d = this.document(this.html());
        Debug.getInstance().println("End IE.document()");
        return d;
    }

    @Override
    public Element element() throws Exception {
        Debug.getInstance().println("Begin IE.element()");
        Element e = this.document().getDocumentElement();
        Debug.getInstance().println("End IE.element()");
        return e;
    }

    @Override
    public IE childBrowser() throws Exception {
        return this.childBrowser(0);
    }

    @Override
    public IE childBrowser(int index) throws Exception {
        this.waitForChildBrowser(index);
        IE childIE = this.childBrowsers.get(index);
        return childIE;
    }

    @Override
    public int childBrowserCount() throws Exception {
        return this.childBrowsers.size();
    }

    public void waitForChildBrowser(final int i) throws Exception {
        WaiterImpl waiter = new WaiterImpl(60000L, 1000L);
        waiter.waitUntil(new Ready(){

            public boolean isReady() {
                return IE.this.childBrowsers.size() > i;
            }

            public String getNotReadyReason() {
                return "ChildBrowser does not exist yet";
            }
        });
    }

    protected void removeSelfFromParent() {
        if (this.parentIE != null) {
            this.parentIE.childBrowsers.remove(this);
        }
    }

    @Override
    public void show() throws Exception {
        this.htmlElements().show();
    }

    @Override
    public HtmlElement active() throws NotImplementedYetException {
        throw new NotImplementedYetException();
    }

    @Override
    public void start(String url) throws Exception {
        this.start();
        this.goTo(url);
    }

    @Override
    public void addChecker(Object checker) throws NotImplementedYetException {
        throw new NotImplementedYetException();
    }

    @Override
    public void attachInit(Symbol how, String what) throws NotImplementedYetException {
        throw new NotImplementedYetException();
    }

    @Override
    public void back() throws Exception {
        this.webBrowser.goBack();
    }

    @Override
    public void checkForHttpError(WatijBrowser watijBrowser) throws NotImplementedYetException {
        throw new NotImplementedYetException();
    }

    @Override
    public void clearUrlList() throws NotImplementedYetException {
        throw new NotImplementedYetException();
    }

    public boolean exists() throws Exception {
        return new Wnd(this.hwnd).isWindow();
    }

    public void waitUntilClosed() throws Exception {
        this.doWaitUntilClosed(10000);
    }

    public void waitUntilClosed(int seconds) throws Exception {
        this.doWaitUntilClosed(seconds * 1000);
    }

    private void doWaitUntilClosed(int timeMillis) throws Exception {
        new WaiterImpl(timeMillis, 200L).waitUntil(new Ready(){

            public boolean isReady() throws Exception {
                Debug.getInstance().println("waiting for browser to be gone");
                return !IE.this.exists();
            }

            public String getNotReadyReason() {
                return "webBrowser never closed.";
            }
        });
        this.removeSelfFromParent();
    }

    @Override
    public void close() throws Exception {
        if (this.exists()) {
            IEUtil.closeAllDialogs();
            try {
                Debug.getInstance().println("About to Close Browser");
                this.webBrowser.close();
                this.waitUntilClosed();
            }
            catch (Throwable t) {
                Debug.handleException(t);
            }
            Thread.sleep(200L);
            this.removeSelfFromParent();
        }
    }

    @Override
    public boolean containsText(String textOrRegex) throws Exception {
        return StringUtils.matchesOrContains(textOrRegex, this.text());
    }

    @Override
    public Object dir() throws NotImplementedYetException {
        throw new NotImplementedYetException();
    }

    @Override
    public void disableChecker(Object checker) throws NotImplementedYetException {
        throw new NotImplementedYetException();
    }

    @Override
    public void focus() throws Exception {
        this.getBrowserWindow().setFocus();
    }

    @Override
    public void forward() throws Exception {
        this.webBrowser.goForward();
    }

    public void fullScreen(boolean full) throws Exception {
        this.iWebBrowser2().setFullScreen(new VariantBool(full));
    }

    public boolean fullScreen() throws Exception {
        return this.iWebBrowser2().getFullScreen().getBooleanValue();
    }

    @Override
    public boolean isFront() throws NotImplementedYetException {
        throw new NotImplementedYetException();
    }

    @Override
    public void goTo(String url) throws Exception {
        this.navigate(url);
    }

    @Override
    public void log(String what) throws NotImplementedYetException {
        throw new NotImplementedYetException();
    }

    @Override
    public void screenCapture(String fullyQualifiedFileName_PngFormat) throws Exception {
        this.screenCapture(fullyQualifiedFileName_PngFormat, "png");
    }

    public void windowCapture(String fullyQualifiedFileName_PngFormat) throws Exception {
        this.windowCapture(fullyQualifiedFileName_PngFormat, "png");
    }

    @Override
    public void screenCapture(String fullyQualifiedFileName, String format) throws Exception {
        this.bringToFront();
        BufferedImage bufferedImage = this.takeCapture(new Rectangle(Toolkit.getDefaultToolkit().getScreenSize()));
        this.writeCapture(bufferedImage, format, fullyQualifiedFileName);
    }

    public void windowCapture(String fullyQualifiedFileName, String format) throws Exception {
        this.bringToFront();
        BufferedImage bufferedImage = this.takeCapture(new Rectangle(this.left(), this.top(), this.width(), this.height()));
        this.writeCapture(bufferedImage, format, fullyQualifiedFileName);
    }

    private void writeCapture(BufferedImage image, String format, String fullyQualifiedFileName) throws Exception {
        ImageIO.write((RenderedImage)image, format, new File(fullyQualifiedFileName));
    }

    private BufferedImage takeCapture(Rectangle rec) throws Exception {
        Robot robot = new Robot();
        return robot.createScreenCapture(rec);
    }

    public void left(int left) throws Exception {
        this.iWebBrowser2().setLeft(new Int32(left));
    }

    public int left() throws Exception {
        return this.iWebBrowser2().getLeft().toLong().intValue();
    }

    public void top(int top) throws Exception {
        this.iWebBrowser2().setTop(new Int32(top));
    }

    public int top() throws Exception {
        return this.iWebBrowser2().getTop().toLong().intValue();
    }

    @Override
    public void width(int width) throws Exception {
        this.iWebBrowser2().setWidth(new Int32(width));
    }

    @Override
    public void height(int height) throws Exception {
        this.iWebBrowser2().setHeight(new Int32(height));
    }

    @Override
    public int width() throws Exception {
        return this.iWebBrowser2().getWidth().toLong().intValue();
    }

    @Override
    public int height() throws Exception {
        return this.iWebBrowser2().getHeight().toLong().intValue();
    }

    @Override
    public void runErrorChecks() throws NotImplementedYetException {
        throw new NotImplementedYetException();
    }

    @Override
    public void setFastSpeed() throws NotImplementedYetException {
        throw new NotImplementedYetException();
    }

    @Override
    public void setSlowSpeed() throws NotImplementedYetException {
        throw new NotImplementedYetException();
    }

    @Override
    public String status() throws NotImplementedYetException {
        throw new NotImplementedYetException();
    }

    @Override
    public String title() throws Exception {
        return this.htmlDocument().getTitle();
    }

    public void theatreMode(boolean theatre) throws Exception {
        this.iWebBrowser2().setTheaterMode(new VariantBool(theatre));
    }

    public boolean theatreMode() throws Exception {
        return this.iWebBrowser2().getTheaterMode().getBooleanValue();
    }

    @Override
    public String url() throws Exception {
        this.waitUntilReady();
        return this.webBrowser.getLocationURL();
    }

    @Override
    public List<String> urlList() throws NotImplementedYetException {
        throw new NotImplementedYetException();
    }

    public void visible(boolean visible) throws Exception {
        if (!this.isIEAutomationClass()) {
            throw new UnsupportedOperationException();
        }
        ((IEAutomation)this.webBrowser).setVisible(visible);
    }

    private boolean isIEAutomationClass() {
        return this.webBrowser instanceof IEAutomation;
    }

    public boolean visible() throws Exception {
        this.waitUntilReady();
        if (this.isIEAutomationClass()) {
            return ((IEAutomation)this.webBrowser).isVisible();
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public ModalDialog modalDialog() throws Exception {
        this.waitUntilReady();
        OleMessageLoop modalDialogMessageLoop = new OleMessageLoop("modalDialogMessageLoop");
        ModalDialogFinder modalDialogFinder = new ModalDialogFinder((int)this.hwnd, modalDialogMessageLoop);
        modalDialogMessageLoop.doStart();
        modalDialogMessageLoop.doInvokeAndWait((Runnable)modalDialogFinder);
        return new IEModalDialog(modalDialogFinder.getHtmlDocument(), modalDialogMessageLoop, modalDialogFinder.getIE());
    }

    public static class IEEventHandler
    implements WebBrowserEventsHandler,
    NewWindowEventListener,
    NavigationEventListener,
    IEApplicationEventListener {
        IE ie;
        private boolean hasNavigated = false;
        private boolean navigationCompleted = false;

        public IEEventHandler(IE ie) {
            this.ie = ie;
        }

        public void trackNavigationCompleted() {
            this.navigationCompleted = false;
        }

        public boolean isNavigationCompleted() {
            return this.navigationCompleted;
        }

        public void onQuit() {
            Debug.getInstance().println("IE$IEEventHandler.onQuit");
            this.ie.removeSelfFromParent();
        }

        public void onVisible(boolean b) {
        }

        public void onToolBar(boolean b) {
        }

        public void onMenuBar(boolean b) {
        }

        public void onStatusBar(boolean b) {
        }

        public boolean beforeNavigate(WebBrowser webBrowser, String url, String targetFrameName, String postData, String headers) {
            if (this.ie.getAdditionalHttpHeaders() != null && !this.hasNavigated) {
                String newAddHeaders = this.existingHeadersValue(headers) + this.ie.getAdditionalHttpHeaders();
                IWebBrowser2 iWebBrowser2 = (IWebBrowser2)webBrowser.getBrowserPeer();
                iWebBrowser2.stop();
                iWebBrowser2.navigate2(new Variant((Object)url), new Variant(0), new Variant((Object)targetFrameName), new Variant((Object)postData), new Variant((Object)newAddHeaders));
                this.hasNavigated = true;
                return true;
            }
            return false;
        }

        private String existingHeadersValue(String existingHeaders) {
            return existingHeaders == null ? "" : existingHeaders;
        }

        public boolean beforeFileDownload() {
            Debug.getInstance().println("***************IE$IEEventHandler.beforeFileDownload");
            return false;
        }

        public boolean windowClosing(boolean b) {
            System.out.println("windowclosing");
            Debug.getInstance().println("IE$IEEventHandler.windowClosing");
            return false;
        }

        public Dimension clientAreaSizeRequested(Dimension dimension) {
            return null;
        }

        public boolean navigationErrorOccured(WebBrowser webBrowser, String string, String string1, StatusCode statusCode) {
            return false;
        }

        public void windowOpened(WebBrowser webBrowser) {
            try {
                new IE(webBrowser, this.ie);
            }
            catch (Exception e) {
                Debug.handleException(e);
            }
        }

        public void downloadBegin() {
        }

        public void downloadCompleted() {
            Debug.getInstance().println("IE$IEEventHandler.downloadCompleted");
        }

        public void documentCompleted(WebBrowser webBrowser, String string) {
        }

        public void entireDocumentCompleted(WebBrowser webBrowser, String string) {
        }

        public void navigationCompleted(WebBrowser webBrowser, String string) {
            Debug.getInstance().println("IE$IEEventHandler.navigationCompleted");
            this.hasNavigated = false;
            this.navigationCompleted = true;
        }

        public void progressChanged(int i, int i1) {
        }
    }

    public static class DummyWB
    implements WebBrowser {
        OleMessageLoop oleMessageLoop;
        HTMLDocument htmlDocument;

        public DummyWB(OleMessageLoop oleMessageLoop) {
            this.oleMessageLoop = oleMessageLoop;
        }

        public void setDocument(HTMLDocument htmlDocument) {
            this.htmlDocument = htmlDocument;
        }

        public void navigate(String string) {
        }

        public void navigate(String string, String string1) {
        }

        public void navigate(String string, String string1, String string2) {
        }

        public String getLocationURL() {
            return null;
        }

        public HTMLDocument getDocument() {
            return this.htmlDocument;
        }

        public WebBrowser getParentBrowser() {
            return null;
        }

        public void setParentBrowser(WebBrowser webBrowser) {
        }

        public void goForward() {
        }

        public void goBack() {
        }

        public void goHome() {
        }

        public void stop() {
        }

        public void refresh() {
        }

        public void execute(BrowserCommand browserCommand) {
        }

        public void setContent(String string) {
        }

        public String getContent() {
            return null;
        }

        public Object executeScript(String string) {
            return null;
        }

        public ReadyState getReadyState() {
            return null;
        }

        public String getStatusText() {
            return null;
        }

        public void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        }

        public void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        }

        public void waitReady() {
        }

        public void waitReady(long l) {
        }

        public Object getBrowserPeer() {
            return null;
        }

        public void addNavigationListener(NavigationEventListener navigationEventListener) {
        }

        public void removeNavigationListener(NavigationEventListener navigationEventListener) {
        }

        public List getNavigationListeners() {
            return null;
        }

        public void addStatusListener(StatusEventListener statusEventListener) {
        }

        public void removeStatusListener(StatusEventListener statusEventListener) {
        }

        public List getStatusListeners() {
            return null;
        }

        public void setEventHandler(WebBrowserEventsHandler webBrowserEventsHandler) {
        }

        public WebBrowserEventsHandler getEventHandler() {
            return null;
        }

        public void setAuthenticateHandler(AuthenticateHandler authenticateHandler) {
        }

        public AuthenticateHandler getAuthenticateHandler() {
            return null;
        }

        public void setDialogEventHandler(DialogEventHandler dialogEventHandler) {
        }

        public DialogEventHandler getDialogEventHandler() {
            return null;
        }

        public void setScriptErrorListener(ScriptErrorListener scriptErrorListener) {
        }

        public ScriptErrorListener getScriptErrorListener() {
            return null;
        }

        public void close() {
        }

        public void setSilent(boolean b) {
        }

        public boolean isSilent() {
            return false;
        }

        public void setCookie(String string, Cookie cookie) {
        }

        public Set getCookies(String string) {
            return null;
        }

        public void setNewWindowHandler(NewWindowEventHandler newWindowEventHandler) {
        }

        public NewWindowEventHandler getNewWindowHandler() {
            return null;
        }

        public void addNewWindowListener(NewWindowEventListener newWindowEventListener) {
        }

        public void removeNewWindowListener(NewWindowEventListener newWindowEventListener) {
        }

        public List getNewWindowListeners() {
            return null;
        }

        public void setKeyFilter(KeyFilter keyFilter) {
        }

        public KeyFilter getKeyFilter() {
            return null;
        }

        public WebBrowser.Properties getProperties() {
            return null;
        }

        public OleMessageLoop getOleMessageLoop() {
            return this.oleMessageLoop;
        }

        public void trackChildren() {
        }

        public WebBrowser getRecentChild() {
            return null;
        }

        public WebBrowser waitChildCreation() {
            return null;
        }

        public WebBrowser waitChildCreation(Runnable runnable) {
            return null;
        }
    }

    public static class DummyIE
    extends IE {
        public void setWebBrowser(WebBrowser webBrowser) {
            this.webBrowser = webBrowser;
        }

        public void waitUntilReady() throws Exception {
        }
    }

    static class ModalDialogFinder
    implements Runnable {
        Pointer.Void popupDocPointer = new Pointer.Void();
        Int hWndParent = new Int();
        HTMLDocument htmlDocument = null;
        DummyWB dummyWB;
        DummyIE dummyIE;
        OleMessageLoop oleMessageLoop;
        final UInt GW_ENABLEDPOPUP = new UInt(6L);
        final UInt GW_CHILD = new UInt(5L);
        final UInt GW_HWNDNEXT = new UInt(2L);
        final UInt SMTO_ABORTIFHUNG = new UInt(2L);
        Int32 hWnd = new Int32(0);
        Int32 hWnd2 = new Int32(0);
        AnsiString className = new AnsiString();

        public ModalDialogFinder(int _hWndParent, OleMessageLoop oleMessageLoop) {
            this.hWndParent.setValue((long)_hWndParent);
            this.oleMessageLoop = oleMessageLoop;
        }

        public HTMLDocument getHtmlDocument() {
            return this.htmlDocument;
        }

        public Wnd getModalWnd() {
            return new Wnd(this.hWnd.getValue());
        }

        public IE getIE() {
            return this.dummyIE;
        }

        public void run() {
            try {
                final Library user32 = new Library("user32");
                new WaiterImpl(60000L, 200L).waitUntil(new Ready(){

                    public boolean isReady() throws Exception {
                        user32.getFunction("GetWindow").invoke((Parameter)ModalDialogFinder.this.hWnd2, (Parameter)new Int32((IntegerParameter)ModalDialogFinder.this.hWndParent), (Parameter)ModalDialogFinder.this.GW_ENABLEDPOPUP);
                        return ModalDialogFinder.this.hWnd2.getValue() != 0L;
                    }

                    public String getNotReadyReason() {
                        return "Handle to Browser not found";
                    }
                });
                new WaiterImpl(60000L, 200L).waitUntil(new Ready(){

                    public boolean isReady() throws Exception {
                        user32.getFunction("GetWindow").invoke((Parameter)ModalDialogFinder.this.hWnd, (Parameter)ModalDialogFinder.this.hWnd2, (Parameter)ModalDialogFinder.this.GW_CHILD);
                        if (ModalDialogFinder.this.hWnd.getValue() != 0L) {
                            do {
                                user32.getFunction("GetClassNameA").invoke(null, (Parameter)ModalDialogFinder.this.hWnd, (Parameter)ModalDialogFinder.this.className, (Parameter)new UInt(255L));
                                if (ModalDialogFinder.this.className.getValue().compareTo("Internet Explorer_Server") == 0) {
                                    return true;
                                }
                                user32.getFunction("GetWindow").invoke((Parameter)ModalDialogFinder.this.hWnd, (Parameter)ModalDialogFinder.this.hWnd, (Parameter)ModalDialogFinder.this.GW_HWNDNEXT);
                            } while (ModalDialogFinder.this.hWnd.getValue() != 0L);
                        }
                        return false;
                    }

                    public String getNotReadyReason() {
                        return "Handle to Internet Explorer_Server not found";
                    }
                });
                Int lResult = new Int(0L);
                Pointer lresPointer = new Pointer((Parameter)lResult);
                UInt nMsg = new UInt(0L);
                user32.getFunction("RegisterWindowMessageA").invoke((Parameter)nMsg, (Parameter)new AnsiString("WM_HTML_GETOBJECT"));
                Parameter[] params = new Parameter[]{this.hWnd, nMsg, new UInt(0L), new UInt(0L), this.SMTO_ABORTIFHUNG, new UInt(100L), lresPointer};
                user32.getFunction("SendMessageTimeoutA").invoke(null, params);
                IHTMLDocument2Impl doc2Impl = new IHTMLDocument2Impl();
                Pointer ppDoc = new Pointer((Parameter)this.popupDocPointer);
                Int retVal = new Int(0L);
                Function.call((String)"oleacc", (String)"ObjectFromLresult", (Parameter)retVal, (Parameter)lResult, (Parameter)new Pointer((Parameter)doc2Impl.getIID()), (Parameter)new UInt(0L), (Parameter)ppDoc);
                IHTMLDocument2Impl doc2 = new IHTMLDocument2Impl((IUnknown)new IUnknownImpl(this.popupDocPointer));
                IEUtil.waitUntilDocumentComplete((IHTMLDocument2)doc2);
                this.dummyWB = new DummyWB(this.oleMessageLoop);
                this.dummyIE = new DummyIE();
                this.htmlDocument = DomFactory.getInstance((WebBrowser)this.dummyWB).createDocument((IDispatch)doc2);
                this.dummyWB.setDocument(this.htmlDocument);
                this.dummyIE.setWebBrowser(this.dummyWB);
            }
            catch (Exception e) {
                Debug.handleException(e);
            }
        }
    }

    public class Counter {
        int i = 0;

        public void add(int i) {
            this.i += i;
        }

        public int getCount() {
            return this.i;
        }
    }
}

