/*
 * Decompiled with CFR 0.152.
 */
package watij.jniwrapper;

import com.jniwrapper.win32.ie.IEAutomation;
import com.jniwrapper.win32.ie.WebBrowser;
import com.jniwrapper.win32.ie.dom.HTMLElement;
import com.jniwrapper.win32.ie.event.NavigationEventListener;
import java.io.FileInputStream;
import java.util.Properties;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.w3c.dom.NodeList;

public class UnicodeTeamDevTest
extends TestCase {
    private static final String HTML_ROOT = System.getProperty("HTML_ROOT");
    private IEAutomation webBrowser;
    private IEListener listener;

    public void testTeamDevUnicodeSupport() {
        try {
            Properties props = new Properties();
            props.load(new FileInputStream(HTML_ROOT + "..\\unicode.properties"));
            new ConditionRunner(10000L, 200L).waitUntil(new Condition(){

                public boolean isSatisfied() {
                    try {
                        UnicodeTeamDevTest.this.webBrowser = new IEAutomation();
                        return true;
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                        return false;
                    }
                }
            });
            this.listener = new IEListener();
            this.webBrowser.addNavigationListener((NavigationEventListener)this.listener);
            this.webBrowser.setVisible(true);
            this.listener.setNavigationCompleted(false);
            this.webBrowser.navigate(HTML_ROOT + "unicode.html");
            new ConditionRunner(180000L, 200L).waitUntil(new Condition(){

                public boolean isSatisfied() {
                    return UnicodeTeamDevTest.this.listener.isNavigationCompleted();
                }
            });
            this.webBrowser.waitReady();
            this.findButtonByText(props.getProperty("simplified_chinese")).click();
            this.webBrowser.waitReady();
            this.findButtonByText(props.getProperty("french")).click();
            this.webBrowser.waitReady();
            this.webBrowser.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            UnicodeTeamDevTest.fail((String)"Should not have thrown an exception");
        }
    }

    private HTMLElement findButtonByText(String name) {
        NodeList list = this.webBrowser.getDocument().getElementsByTagName("button");
        for (int i = 0; i < list.getLength(); ++i) {
            HTMLElement elem = (HTMLElement)list.item(i);
            if (!name.equals(elem.getText())) continue;
            return elem;
        }
        throw new RuntimeException("Can't find button with name " + name);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)UnicodeTeamDevTest.suite());
    }

    public static Test suite() {
        return new TestSuite(UnicodeTeamDevTest.class);
    }

    public static class IEListener
    implements NavigationEventListener {
        private boolean navigationCompleted;

        public void setNavigationCompleted(boolean navigationCompleted) {
            this.navigationCompleted = navigationCompleted;
        }

        public boolean isNavigationCompleted() {
            return this.navigationCompleted;
        }

        public void downloadBegin() {
        }

        public void downloadCompleted() {
        }

        public void documentCompleted(WebBrowser webBrowser, String string) {
        }

        public void entireDocumentCompleted(WebBrowser webBrowser, String string) {
        }

        public void navigationCompleted(WebBrowser webBrowser, String string) {
            this.navigationCompleted = true;
        }

        public void progressChanged(int i, int i1) {
        }
    }

    public static class ConditionRunner {
        private long timeout;
        private long waitIncrement;

        public ConditionRunner(long timeout, long waitIncrement) {
            this.timeout = timeout;
            this.waitIncrement = waitIncrement;
        }

        public void waitUntil(Condition cond) throws Exception {
            long started = System.currentTimeMillis();
            while (!cond.isSatisfied()) {
                if (System.currentTimeMillis() - started > this.timeout) {
                    throw new RuntimeException("Timeout exceeded");
                }
                try {
                    Thread.sleep(this.waitIncrement);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    public static interface Condition {
        public boolean isSatisfied();
    }
}

