/*
 * Decompiled with CFR 0.152.
 */
package watij.elements;

import watij.WatijTestCase;
import watij.elements.Image;
import watij.elements.Link;
import watij.elements.Table;
import watij.elements.TableBody;
import watij.elements.TableCell;
import watij.elements.TableRow;
import watij.finders.SymbolFactory;
import watij.runtime.UnknownObjectException;

public class TableTest
extends WatijTestCase {
    protected void setUp() throws Exception {
        super.setUp();
        ie.goTo(HTML_ROOT + "table1.html");
    }

    public void testTableExists() throws Exception {
        TableTest.assertTrue((!ie.table(SymbolFactory.id, "missingTable").exists() ? 1 : 0) != 0);
        TableTest.assertTrue((!ie.table(32).exists() ? 1 : 0) != 0);
        TableTest.assertTrue((boolean)ie.table(SymbolFactory.id, "t1").exists());
        TableTest.assertTrue((boolean)ie.table(SymbolFactory.id, "/t/").exists());
        TableTest.assertTrue((!ie.table(SymbolFactory.id, "/missing_table/").exists() ? 1 : 0) != 0);
        TableTest.assertTrue((boolean)ie.table(0).exists());
        TableTest.assertTrue((boolean)ie.table(1).exists());
    }

    public void testRows() throws Exception {
        try {
            ie.table(SymbolFactory.id, "missingTable").rowCount();
            this.failUnknownObjectException();
        }
        catch (UnknownObjectException e) {
            // empty catch block
        }
        try {
            ie.table(66).rowCount();
            this.failUnknownObjectException();
        }
        catch (UnknownObjectException e) {
            // empty catch block
        }
        TableTest.assertEquals((int)2, (int)ie.table(0).rowCount());
        TableTest.assertEquals((int)2, (int)ie.table(0).rows().length());
        TableTest.assertEquals((int)5, (int)ie.table(SymbolFactory.id, "t1").rowCount());
        TableTest.assertEquals((int)5, (int)ie.table(1).rowCount());
        TableTest.assertEquals((int)5, (int)ie.table(SymbolFactory.id, "t1").rows().length());
        TableRow row = ie.table(1).row(1);
        int count = 0;
        for (TableCell cell : row.cells()) {
            if (count == 0) {
                TableTest.assertEquals((String)"Row 1 Col1", (String)cell.text().trim());
            } else if (count == 1) {
                TableTest.assertEquals((String)"Row 1 Col2", (String)cell.text().trim());
            }
            ++count;
        }
        TableTest.assertEquals((int)2, (int)count);
        TableTest.assertEquals((int)2, (int)ie.table(0).row(1).columnCount());
    }

    public void testDynamicTables() throws Exception {
        Table t = ie.table(SymbolFactory.id, "t1");
        TableTest.assertEquals((int)5, (int)t.rowCount());
        ie.button(SymbolFactory.value, "add row").click();
        TableTest.assertEquals((int)5, (int)t.rowCount());
        t = ie.table(SymbolFactory.id, "t1");
        TableTest.assertEquals((int)6, (int)t.rowCount());
    }

    public void testColumns() throws Exception {
        try {
            ie.table(SymbolFactory.id, "missingTable").columnCount();
            this.failUnknownObjectException();
        }
        catch (UnknownObjectException e) {
            // empty catch block
        }
        try {
            ie.table(77).columnCount();
            this.failUnknownObjectException();
        }
        catch (UnknownObjectException unknownObjectException) {
            // empty catch block
        }
        TableTest.assertEquals((int)2, (int)ie.table(0).columnCount());
        TableTest.assertEquals((int)1, (int)ie.table(SymbolFactory.id, "t1").columnCount());
    }

    public void testLinksAndImagesInTable() throws Exception {
        Table table = ie.table(SymbolFactory.id, "pic_table");
        Image image = table.cell(0, 1).image(0);
        TableTest.assertEquals((int)106, (int)image.width());
        TableTest.assertEquals((int)106, (int)ie.cell(SymbolFactory.xpath, "//TABLE[@id='pic_table']//TR[1]/TD[2]").image(0).width());
        Link link = table.cell(0, 3).link(0);
        TableTest.assertEquals((String)"Google", (String)link.innerText());
    }

    public void test_cell_directly() throws Exception {
        TableTest.assertTrue((boolean)ie.cell(SymbolFactory.id, "cell1").exists());
        TableTest.assertTrue((!ie.cell(SymbolFactory.id, "no_exist").exists() ? 1 : 0) != 0);
        TableTest.assertEquals((String)"Row 1 Col1", (String)ie.cell(SymbolFactory.id, "cell1").text().trim());
        TableTest.assertEquals((String)"Row 1 Col1", (String)ie.table(0).cell(0, 0).text().trim());
    }

    public void test_row_directly() throws Exception {
        TableTest.assertTrue((boolean)ie.row(SymbolFactory.id, "row1").exists());
        TableTest.assertTrue((!ie.row(SymbolFactory.id, "no_exist").exists() ? 1 : 0) != 0);
        TableTest.assertEquals((String)"Row 2 Col1", (String)ie.row(SymbolFactory.id, "row1").cell(0).text().trim());
    }

    public void test_row_iterator() throws Exception {
        Table t = ie.table(0);
        int count = 0;
        for (TableRow row : t.rows()) {
            if (count == 0) {
                TableTest.assertEquals((String)"Row 1 Col1", (String)row.cell(0).text().trim());
                TableTest.assertEquals((String)"Row 1 Col2", (String)row.cell(1).text().trim());
            } else if (count == 1) {
                TableTest.assertEquals((String)"Row 2 Col1", (String)row.cell(0).text().trim());
                TableTest.assertEquals((String)"Row 2 Col2", (String)row.cell(1).text().trim());
            }
            ++count;
        }
    }

    public void test_cell_collection() throws Exception {
        Table t = ie.table(0);
        int count = 0;
        for (TableCell c : t.cells()) {
            if (count == 0) {
                TableTest.assertEquals((String)"Row 1 Col1", (String)c.text().trim());
            } else if (count == 1) {
                TableTest.assertEquals((String)"Row 1 Col2", (String)c.text().trim());
            } else if (count == 2) {
                TableTest.assertEquals((String)"Row 2 Col1", (String)c.text().trim());
            } else if (count == 3) {
                TableTest.assertEquals((String)"Row 2 Col2", (String)c.text().trim());
            }
            ++count;
        }
    }

    public void test_table_body() throws Exception {
        TableTest.assertEquals((int)1, (int)ie.table(0).bodies().length());
        TableTest.assertEquals((int)3, (int)ie.table(SymbolFactory.id, "body_test").bodies().length());
        int count = 0;
        String compareText = null;
        for (TableBody n : ie.table(SymbolFactory.id, "body_test").bodies()) {
            if (count == 0) {
                compareText = "This text is in the FRST TBODY.";
            } else if (count == 1) {
                compareText = "This text is in the SECOND TBODY.";
            } else if (count == 2) {
                compareText = "This text is in the THIRD TBODY.";
            }
            TableTest.assertEquals((String)compareText, (String)n.cell(0, 0).text().trim());
            ++count;
        }
        TableTest.assertEquals((int)count, (int)ie.table(SymbolFactory.id, "body_test").bodies().length());
        TableTest.assertEquals((String)"This text is in the THIRD TBODY.", (String)ie.table(SymbolFactory.id, "body_test").body(2).cell(0, 0).text().trim());
        count = 0;
        for (TableRow row : ie.table(SymbolFactory.id, "body_test").body(1).rows()) {
            if (count == 0) {
                TableTest.assertEquals((String)"This text is in the SECOND TBODY.", (String)row.cell(0).text().trim());
            } else if (count == 1) {
                TableTest.assertEquals((String)"This text is also in the SECOND TBODY.", (String)row.cell(0).text().trim());
            }
            ++count;
        }
    }

    public void testTableHead() throws Exception {
        TableTest.assertEquals((String)"This text is in the TH. ", (String)((TableRow)ie.table(SymbolFactory.id, "th_test").rows().get(0)).cell(0).innerText());
    }

    public void test_simple_table_access() throws Exception {
        ie.goTo(HTML_ROOT + "simple_table.html");
        Table table = ie.table(0);
        TableTest.assertEquals((String)"Row 3 Col1", (String)table.cell(2, 0).text().trim());
        TableTest.assertEquals((String)"Row 1 Col1", (String)table.cell(0, 0).text().trim());
        TableTest.assertEquals((String)"Row 3 Col2", (String)table.cell(2, 1).text().trim());
        TableTest.assertEquals((int)2, (int)table.columnCount());
    }

    public void test_simple_table_buttons() throws Exception {
        ie.goTo(HTML_ROOT + "simple_table_buttons.html");
        Table table = ie.table(0);
        table.cell(0, 0).button(0).click();
        TableTest.assertTrue((boolean)ie.textField(SymbolFactory.name, "confirmtext").verifyContains("/CLICK1/"));
        table.cell(1, 0).button(0).click();
        TableTest.assertTrue((boolean)ie.textField(SymbolFactory.name, "confirmtext").verifyContains("/CLICK2/"));
        table.cell(0, 0).button(SymbolFactory.id, "b1").click();
        TableTest.assertTrue((boolean)ie.textField(SymbolFactory.name, "confirmtext").verifyContains("/CLICK1/"));
        try {
            table.cell(0, 0).button(SymbolFactory.id, "b_missing").click();
            this.failUnknownObjectException();
        }
        catch (UnknownObjectException unknownObjectException) {
            // empty catch block
        }
        table.cell(2, 0).button(1).click();
        TableTest.assertTrue((boolean)ie.textField(SymbolFactory.name, "confirmtext").verifyContains("/TOO/"));
        table.cell(2, 0).button(SymbolFactory.value, "Click too").click();
        TableTest.assertTrue((boolean)ie.textField(SymbolFactory.name, "confirmtext").verifyContains("/TOO/"));
        ie.table(0).cell(3, 0).textField(0).set("123");
        TableTest.assertTrue((boolean)ie.textField(1).verifyContains("123"));
        TableTest.assertEquals((String)"Click ->", (String)ie.table(0).cell(4, 0).textField(0).value());
        ie.table(0).cell(4, 0).textField(0).click();
        TableTest.assertEquals((String)"Click ->", (String)ie.table(0).cell(4, 0).textField(0).value());
        ie.table(0).cell(4, 0).button(0).click();
        TableTest.assertEquals((String)"", (String)ie.table(0).cell(4, 0).textField(0).value());
    }

    public void test_simple_table_gif() throws Exception {
        ie.goTo(HTML_ROOT + "simple_table_buttons.html");
        Table table = ie.table(1);
        this.assertMatches("/1.gif/", table.cell(0, 0).image(0).src());
        this.assertMatches("/2.gif/", table.cell(0, 1).image(0).src());
        this.assertMatches("/3.gif/", table.cell(0, 2).image(0).src());
        this.assertMatches("/1.gif/", table.cell(2, 0).image(0).src());
        this.assertMatches("/2.gif/", table.cell(2, 1).image(0).src());
        this.assertMatches("/3.gif/", table.cell(2, 2).image(0).src());
        table = ie.table(2);
        this.assertMatches("/1.gif/", table.cell(0, 0).image(0).src());
        this.assertMatches("/2.gif/", table.cell(0, 0).image(1).src());
        this.assertMatches("/3.gif/", table.cell(0, 0).image(2).src());
        this.assertMatches("/1.gif/", table.cell(2, 0).image(0).src());
        this.assertMatches("/2.gif/", table.cell(2, 0).image(1).src());
        this.assertMatches("/3.gif/", table.cell(2, 0).image(2).src());
    }

    public void test_table_with_hidden_or_visible_rows() throws Exception {
        Image image;
        ie.goTo(HTML_ROOT + "simple_table_buttons.html");
        ie.bringToFront();
        Table t = ie.table(SymbolFactory.id, "show_hide");
        for (TableRow r : t.rows()) {
            image = r.cell(0).image(SymbolFactory.src, "/plus/");
            if (!image.exists()) continue;
            image.click();
        }
        for (TableRow r : t.rows()) {
            image = r.cell(0).image(SymbolFactory.src, "/minus/");
            if (!image.exists()) continue;
            image.click();
        }
    }

    public void test_colspan() throws Exception {
        ie.goTo(HTML_ROOT + "simple_table_columns.html");
        TableTest.assertEquals((int)2, (int)ie.table(2).cell(1, 0).colspan());
        TableTest.assertEquals((int)1, (int)ie.table(2).cell(0, 0).colspan());
        TableTest.assertEquals((int)3, (int)ie.table(2).cell(3, 0).colspan());
    }

    public void test_complex_table_access() throws Exception {
        ie.goTo(HTML_ROOT + "complex_table.html");
        Table table = ie.table(0);
        TableTest.assertEquals((String)"subtable1 Row 1 Col1", (String)table.cell(0, 0).table(0).cell(0, 0).text().trim());
        TableTest.assertEquals((String)"subtable1 Row 1 Col2", (String)table.cell(0, 0).table(0).cell(0, 1).text().trim());
        TableTest.assertEquals((String)"subtable2 Row 1 Col2", (String)table.cell(1, 0).table(0).cell(0, 1).text().trim());
        TableTest.assertEquals((String)"subtable2 Row 1 Col1", (String)table.cell(1, 0).table(0).cell(0, 0).text().trim());
    }
}

