/*
 * Decompiled with CFR 0.152.
 */
package watij.elements;

import watij.WatijTestCase;
import watij.finders.SymbolFactory;

public class RadiosXpathTest
extends WatijTestCase {
    protected void setUp() throws Exception {
        super.setUp();
        ie.goTo(HTML_ROOT + "radioButtons1.html");
    }

    public void testRadioExists() throws Exception {
        RadiosXpathTest.assertTrue((boolean)ie.radio(SymbolFactory.xpath, "//INPUT[@name='box1']").exists());
        RadiosXpathTest.assertTrue((boolean)ie.radio(SymbolFactory.xpath, "//INPUT[@id='box5']").exists());
        RadiosXpathTest.assertFalse((boolean)ie.radio(SymbolFactory.xpath, "//INPUT[@name='missingname']").exists());
        RadiosXpathTest.assertFalse((boolean)ie.radio(SymbolFactory.xpath, "//INPUT[@id='missingid']").exists());
    }

    public void testRadio_Enabled() throws Exception {
        this.assertRaisesUnknownObjectExceptionForMethodEnabled(ie.radio(SymbolFactory.xpath, "//INPUT[@name='noName']"));
        this.assertRaisesUnknownObjectExceptionForMethodEnabled(ie.radio(SymbolFactory.xpath, "//INPUT[@id='noName']"));
        this.assertRaisesUnknownObjectExceptionForMethodEnabled(ie.radio(SymbolFactory.xpath, "//INPUT[@name='box4' and @value='6']"));
        RadiosXpathTest.assertFalse((boolean)ie.radio(SymbolFactory.xpath, "//INPUT[@name='box2']").enabled());
        RadiosXpathTest.assertTrue((boolean)ie.radio(SymbolFactory.xpath, "//INPUT[@id='box5']").enabled());
        RadiosXpathTest.assertTrue((boolean)ie.radio(SymbolFactory.xpath, "//INPUT[@name='box1']").enabled());
    }

    public void testLittle() throws Exception {
        RadiosXpathTest.assertFalse((boolean)ie.button(SymbolFactory.xpath, "//INPUT[@name='foo']").enabled());
    }

    public void testOnClick() throws Exception {
        RadiosXpathTest.assertFalse((boolean)ie.button(SymbolFactory.xpath, "//INPUT[@name='foo']").enabled());
        ie.radio(SymbolFactory.xpath, "//INPUT[@name='box5' and @value='1']").set();
        RadiosXpathTest.assertTrue((boolean)ie.button(SymbolFactory.xpath, "//INPUT[@name='foo']").enabled());
        ie.radio(SymbolFactory.xpath, "//INPUT[@name='box5' and @value='2']").set();
        RadiosXpathTest.assertFalse((boolean)ie.button(SymbolFactory.xpath, "//INPUT[@name='foo']").enabled());
    }

    public void testRadioIsSet() throws Exception {
        this.assertRaisesUnknownObjectExceptionForMethodIsSet(ie.radio(SymbolFactory.xpath, "//INPUT[@name='noName']"));
        RadiosXpathTest.assertFalse((boolean)ie.radio(SymbolFactory.xpath, "//INPUT[@name='box1']").isSet());
        RadiosXpathTest.assertTrue((boolean)ie.radio(SymbolFactory.xpath, "//INPUT[@name='box3']").isSet());
        RadiosXpathTest.assertFalse((boolean)ie.radio(SymbolFactory.xpath, "//INPUT[@name='box2']").isSet());
        RadiosXpathTest.assertTrue((boolean)ie.radio(SymbolFactory.xpath, "//INPUT[@name='box4' and @value='1']").isSet());
        RadiosXpathTest.assertFalse((boolean)ie.radio(SymbolFactory.xpath, "//INPUT[@name='box4' and @value='2']").isSet());
    }

    public void testRadioClear() throws Exception {
        this.assertRaisesUnknownObjectExceptionForMethodClear(ie.radio(SymbolFactory.xpath, "//INPUT[@name='noName']"));
        ie.radio(SymbolFactory.xpath, "//INPUT[@name='box1']").clear();
        RadiosXpathTest.assertFalse((boolean)ie.radio(SymbolFactory.xpath, "//INPUT[@name='box1']").isSet());
        this.assertRaisesDisabledObjectExceptionForMethodClear(ie.radio(SymbolFactory.xpath, "//INPUT[@name='box2']"));
        RadiosXpathTest.assertFalse((boolean)ie.radio(SymbolFactory.xpath, "//INPUT[@name='box2']").isSet());
        ie.radio(SymbolFactory.xpath, "//INPUT[@name='box3']").clear();
        RadiosXpathTest.assertFalse((boolean)ie.radio(SymbolFactory.xpath, "//INPUT[@name='box3']").isSet());
        ie.radio(SymbolFactory.xpath, "//INPUT[@name='box4' and @value='1']").clear();
        RadiosXpathTest.assertFalse((boolean)ie.radio(SymbolFactory.xpath, "//INPUT[@name='box4' and @value='1']").isSet());
    }

    public void testRadioGetState() throws Exception {
        this.assertRaisesUnknownObjectExceptionForMethodGetState(ie.radio(SymbolFactory.xpath, "//INPUT[@name='noName']"));
        RadiosXpathTest.assertEquals((boolean)false, (boolean)ie.radio(SymbolFactory.xpath, "//INPUT[@name='box1']").getState());
        RadiosXpathTest.assertEquals((boolean)true, (boolean)ie.radio(SymbolFactory.xpath, "//INPUT[@name='box3']").getState());
        RadiosXpathTest.assertEquals((boolean)false, (boolean)ie.radio(SymbolFactory.xpath, "//INPUT[@name='box4' and @value='2']").getState());
        RadiosXpathTest.assertEquals((boolean)true, (boolean)ie.radio(SymbolFactory.xpath, "//INPUT[@name='box4' and @value='1']").getState());
    }

    public void testRadioSet() throws Exception {
        this.assertRaisesUnknownObjectExceptionForMethodSet(ie.radio(SymbolFactory.xpath, "//INPUT[@name='noName']"));
        ie.radio(SymbolFactory.xpath, "//INPUT[@name='box1']").set();
        RadiosXpathTest.assertTrue((boolean)ie.radio(SymbolFactory.xpath, "//INPUT[@name='box1']").isSet());
        this.assertRaisesDisabledObjectExceptionForMethodSet(ie.radio(SymbolFactory.xpath, "//INPUT[@name='box2']"));
        ie.radio(SymbolFactory.xpath, "//INPUT[@name='box3']").set();
        RadiosXpathTest.assertTrue((boolean)ie.radio(SymbolFactory.xpath, "//INPUT[@name='box3']").isSet());
        ie.radio(SymbolFactory.xpath, "//INPUT[@name='box4' and @value='3']").set();
        RadiosXpathTest.assertTrue((boolean)ie.radio(SymbolFactory.xpath, "//INPUT[@name='box4' and @value='3']").isSet());
    }
}

