/*
 * Decompiled with CFR 0.152.
 */
package watij.elements;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Element;
import watij.BaseHtmlFinder;
import watij.elements.HtmlElement;
import watij.elements.HtmlElementFactory;
import watij.elements.HtmlElements;
import watij.finders.Finder;
import watij.finders.Matcher;
import watij.utilities.Debug;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class HtmlElementCollections<HtmlElement>
extends BaseHtmlFinder
implements Iterable<HtmlElement>,
Matcher {
    HtmlElementFactory htmlElementFactory;
    List<Element> list;

    protected HtmlElementCollections(List<Element> list, HtmlElementFactory htmlElementFactory) throws Exception {
        this.list = list;
        this.htmlElementFactory = htmlElementFactory;
        this.filter();
    }

    protected abstract HtmlElement get(Element var1) throws Exception;

    @Override
    protected HtmlElementFactory htmlElementFactory() {
        return this.htmlElementFactory;
    }

    @Override
    public List<Element> elements() throws Exception {
        return this.list;
    }

    public HtmlElement get(int index) throws Exception {
        return this.get(index >= this.list.size() ? null : this.list.get(index));
    }

    protected void filter() throws Exception {
        ArrayList<Element> newList = new ArrayList<Element>();
        for (int i = 0; i < this.list.size(); ++i) {
            Element element = this.list.get(i);
            if (!this.matches(element)) continue;
            newList.add(element);
        }
        this.list = newList;
    }

    @Override
    public HtmlElements htmlElements(Finder ... finder) throws Exception {
        return this.find(this.elements(), finder);
    }

    public int length() throws Exception {
        return this.list.size();
    }

    @Override
    public Iterator<HtmlElement> iterator() {
        ArrayList<HtmlElement> htmlElementList = new ArrayList<HtmlElement>();
        for (Element element : this.list) {
            try {
                htmlElementList.add(this.get(element));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return htmlElementList.iterator();
    }

    public void show() {
        System.out.println(this.toString());
    }

    public void flash() throws Exception {
        ThreadGroup flashGroup = new ThreadGroup("FlashThreadGroup");
        int i = 0;
        while (i < this.length()) {
            final int count = i++;
            new Thread(flashGroup, new Runnable(){

                public void run() {
                    try {
                        ((HtmlElement)HtmlElementCollections.this.get(count)).flash();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }).start();
        }
        while (flashGroup.activeCount() > 0) {
            Thread.sleep(100L);
        }
    }

    public String toString() {
        Debug.getInstance().println("Begin HtmlElementCollections.toString()");
        Debug.getInstance().println("list.size() = " + this.list.size());
        StringBuffer s = new StringBuffer();
        s.append("\n");
        s.append("[");
        for (int i = 0; i < this.list.size(); ++i) {
            Object htmlElement = null;
            try {
                htmlElement = this.get(i);
            }
            catch (Exception e) {
                // empty catch block
            }
            Debug.getInstance().println("about to call toString on element i=" + i);
            s.append("\t").append(htmlElement.toString());
            if (i >= this.list.size() - 1) continue;
            s.append(",");
        }
        s.append("\n");
        s.append("]");
        Debug.getInstance().println("End HtmlElementCollections.toString()");
        return s.toString();
    }
}

