/*
 * Decompiled with CFR 0.152.
 */
package watij;

import junit.framework.TestCase;
import watij.elements.Div;
import watij.elements.HtmlElement;
import watij.elements.Image;
import watij.elements.Label;
import watij.elements.RadioCheckCommon;
import watij.elements.Span;
import watij.elements.TextField;
import watij.runtime.NavigationException;
import watij.runtime.ObjectDisabledException;
import watij.runtime.ObjectReadOnlyException;
import watij.runtime.UnknownObjectException;
import watij.runtime.ie.IE;
import watij.utilities.StringUtils;

public abstract class WatijTestCase
extends TestCase {
    public static final String HTML_ROOT = System.getProperty("HTML_ROOT");
    public static IE ie;

    protected static void initIEForTesting() throws Exception {
        IE throwAway = new IE();
        throwAway.start();
        Thread.sleep(1000L);
        ie = new IE();
        ie.start();
        ie.bringToFront();
    }

    protected void setUp() throws Exception {
        ie.bringToFront();
    }

    protected void assertRaisesUnknownObjectExceptionForMethodId(HtmlElement htmlElement) throws Exception {
        try {
            htmlElement.id();
            this.failUnknownObjectException();
        }
        catch (UnknownObjectException unknownObjectException) {
            // empty catch block
        }
    }

    protected void assertRaisesUnknownObjectExceptionForMethodValue(HtmlElement htmlElement) throws Exception {
        try {
            htmlElement.value();
            this.failUnknownObjectException();
        }
        catch (UnknownObjectException unknownObjectException) {
            // empty catch block
        }
    }

    protected void assertRaisesUnknownObjectExceptionForMethodName(HtmlElement htmlElement) throws Exception {
        try {
            htmlElement.name();
            this.failUnknownObjectException();
        }
        catch (UnknownObjectException unknownObjectException) {
            // empty catch block
        }
    }

    protected void assertRaisesUnknownObjectExceptionForMethodDisabled(HtmlElement htmlElement) throws Exception {
        try {
            htmlElement.disabled();
            this.failUnknownObjectException();
        }
        catch (UnknownObjectException unknownObjectException) {
            // empty catch block
        }
    }

    protected void assertRaisesUnknownObjectExceptionForMethodType(HtmlElement htmlElement) throws Exception {
        try {
            htmlElement.type();
            this.failUnknownObjectException();
        }
        catch (UnknownObjectException unknownObjectException) {
            // empty catch block
        }
    }

    protected void assertRaisesUnknownObjectExceptionForMethodInnerText(HtmlElement htmlElement) throws Exception {
        try {
            htmlElement.innerText();
            this.failUnknownObjectException();
        }
        catch (UnknownObjectException unknownObjectException) {
            // empty catch block
        }
    }

    protected void assertRaisesUnknownObjectExceptionForMethodFor(Label label) throws Exception {
        try {
            label.htmlFor();
            this.failUnknownObjectException();
        }
        catch (UnknownObjectException unknownObjectException) {
            // empty catch block
        }
    }

    protected void assertRaisesUnknownObjectExceptionForMethodVerifyContains(TextField textField, String what) throws Exception {
        try {
            textField.verifyContains(what);
            this.failUnknownObjectException();
        }
        catch (UnknownObjectException unknownObjectException) {
            // empty catch block
        }
    }

    protected void assertRaisesUnknownObjectExceptionForMethodClick(HtmlElement htmlElement) throws Exception {
        try {
            htmlElement.click();
            this.failUnknownObjectException();
        }
        catch (UnknownObjectException unknownObjectException) {
            // empty catch block
        }
    }

    protected void assertRaisesUnknownObjectExceptionForMethodClassName(HtmlElement htmlElement) throws Exception {
        try {
            htmlElement.className();
            this.failUnknownObjectException();
        }
        catch (UnknownObjectException unknownObjectException) {
            // empty catch block
        }
    }

    protected void assertRaisesUnknownObjectExceptionForMethodEnabled(HtmlElement htmlElement) throws Exception {
        try {
            htmlElement.enabled();
            this.failUnknownObjectException();
        }
        catch (UnknownObjectException unknownObjectException) {
            // empty catch block
        }
    }

    protected void assertRaisesUnknownObjectExceptionForMethodIsSet(RadioCheckCommon common) throws Exception {
        try {
            common.isSet();
            this.failUnknownObjectException();
        }
        catch (UnknownObjectException unknownObjectException) {
            // empty catch block
        }
    }

    protected void assertRaisesUnknownObjectExceptionForMethodSet(RadioCheckCommon common) throws Exception {
        try {
            common.set();
            this.failUnknownObjectException();
        }
        catch (UnknownObjectException unknownObjectException) {
            // empty catch block
        }
    }

    protected void assertRaisesUnknownObjectExceptionForMethodClear(RadioCheckCommon common) throws Exception {
        try {
            common.clear();
            this.failUnknownObjectException();
        }
        catch (UnknownObjectException unknownObjectException) {
            // empty catch block
        }
    }

    protected void assertRaisesUnknownObjectExceptionForMethodGetState(RadioCheckCommon common) throws Exception {
        try {
            common.getState();
            this.failUnknownObjectException();
        }
        catch (UnknownObjectException unknownObjectException) {
            // empty catch block
        }
    }

    protected void assertRaisesUnknownObjectExceptionForMethodHasLoaded(Image image) throws Exception {
        try {
            image.hasLoaded();
            this.failUnknownObjectException();
        }
        catch (UnknownObjectException unknownObjectException) {
            // empty catch block
        }
    }

    protected void assertRaisesUnknownObjectExceptionForMethodValue(Image image) throws Exception {
        try {
            image.value();
            this.failUnknownObjectException();
        }
        catch (UnknownObjectException unknownObjectException) {
            // empty catch block
        }
    }

    protected void assertRaisesUnknownObjectExceptionForMethodHeight(Image image) throws Exception {
        try {
            image.height();
            this.failUnknownObjectException();
        }
        catch (UnknownObjectException unknownObjectException) {
            // empty catch block
        }
    }

    protected void assertRaisesUnknownObjectExceptionForMethodWidth(Image image) throws Exception {
        try {
            image.width();
            this.failUnknownObjectException();
        }
        catch (UnknownObjectException unknownObjectException) {
            // empty catch block
        }
    }

    protected void assertRaisesUnknownObjectExceptionForMethodFileCreatedDate(Image image) throws Exception {
        try {
            image.fileCreatedDate();
            this.failUnknownObjectException();
        }
        catch (UnknownObjectException unknownObjectException) {
            // empty catch block
        }
    }

    protected void assertRaisesUnknownObjectExceptionForMethodFileSize(Image image) throws Exception {
        try {
            image.fileSize();
            this.failUnknownObjectException();
        }
        catch (UnknownObjectException unknownObjectException) {
            // empty catch block
        }
    }

    protected void assertRaisesUnknownObjectExceptionForMethodAlt(Image image) throws Exception {
        try {
            image.alt();
            this.failUnknownObjectException();
        }
        catch (UnknownObjectException unknownObjectException) {
            // empty catch block
        }
    }

    protected void assertRaisesUnknownObjectExceptionForMethodTitle(Image image) throws Exception {
        try {
            image.title();
            this.failUnknownObjectException();
        }
        catch (UnknownObjectException unknownObjectException) {
            // empty catch block
        }
    }

    protected void assertRaisesUnknownObjectExceptionForMethodSrc(Image image) throws Exception {
        try {
            image.src();
            this.failUnknownObjectException();
        }
        catch (UnknownObjectException unknownObjectException) {
            // empty catch block
        }
    }

    protected void assertRaisesUnknownObjectExceptionForMethodAppend(TextField field, String data) throws Exception {
        try {
            field.append(data);
            this.failUnknownObjectException();
        }
        catch (UnknownObjectException unknownObjectException) {
            // empty catch block
        }
    }

    protected void assertRaisesUnknownObjectExceptionForMethodText(Div div) throws Exception {
        try {
            div.text();
            this.failUnknownObjectException();
        }
        catch (UnknownObjectException unknownObjectException) {
            // empty catch block
        }
    }

    protected void assertRaisesUnknownObjectExceptionForMethodText(Span span) throws Exception {
        try {
            span.text();
            this.failUnknownObjectException();
        }
        catch (UnknownObjectException unknownObjectException) {
            // empty catch block
        }
    }

    protected void assertRaisesDisabledObjectExceptionForMethodClear(RadioCheckCommon common) throws Exception {
        try {
            common.clear();
            this.failObjectDisabledException();
        }
        catch (ObjectDisabledException objectDisabledException) {
            // empty catch block
        }
    }

    protected void assertRaisesDisabledObjectExceptionForMethodSet(RadioCheckCommon common) throws Exception {
        try {
            common.set();
            this.failObjectDisabledException();
        }
        catch (ObjectDisabledException objectDisabledException) {
            // empty catch block
        }
    }

    protected void assertRaisesObjectDisabledExceptionForMethodClick(HtmlElement element) throws Exception {
        try {
            element.click();
            this.failObjectDisabledException();
        }
        catch (ObjectDisabledException objectDisabledException) {
            // empty catch block
        }
    }

    protected void assertRaisesObjectReadOnlyExceptionForMethodAppend(TextField field, String text) throws Exception {
        try {
            field.append(text);
            this.failReadOnlyException();
        }
        catch (ObjectReadOnlyException objectReadOnlyException) {
            // empty catch block
        }
    }

    protected void assertRaisesObjectDisabledExceptionForMethodAppend(TextField field, String text) throws Exception {
        try {
            field.append(text);
            this.failObjectDisabledException();
        }
        catch (ObjectDisabledException objectDisabledException) {
            // empty catch block
        }
    }

    protected void assertRaisesNavigationException(IE ie, String nav) throws Exception {
        try {
            ie.goTo(nav);
            this.failNavigationException();
        }
        catch (NavigationException navigationException) {
            // empty catch block
        }
    }

    protected void failUnknownObjectException() {
        WatijTestCase.fail((String)"Should have thrown UnknownObjectException");
    }

    protected void failObjectDisabledException() {
        WatijTestCase.fail((String)"Should have thrown ObjectDisabledException");
    }

    protected void failMissingWayOfFindingObjectException() {
        WatijTestCase.fail((String)"Should have thrown MissingWayOfFindingObjectException");
    }

    protected void failNoValueFoundException() {
        WatijTestCase.fail((String)"Should have thrown NoValueFoundException");
    }

    protected void failNavigationException() {
        WatijTestCase.fail((String)"Should have thrown NavigationException");
    }

    protected void failReadOnlyException() {
        WatijTestCase.fail((String)"Should have thrown ReadOnlyException");
    }

    protected void assertMatches(String regex, String match) {
        WatijTestCase.assertTrue((boolean)StringUtils.matchesOrContains(regex, match));
    }

    static {
        try {
            WatijTestCase.initIEForTesting();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

