/*
 * Decompiled with CFR 0.152.
 */
package watij;

import watij.WatijTestCase;
import watij.dialogs.AlertDialog;
import watij.dialogs.ConfirmDialog;
import watij.dialogs.FileDownloadDialog;
import watij.dialogs.PromptDialog;
import watij.finders.SymbolFactory;
import watij.runtime.ie.IE;

public class PopupsTest
extends WatijTestCase {
    protected void setUp() throws Exception {
        super.setUp();
        ie.goTo(HTML_ROOT + "popups1.html");
    }

    private void clickButtonOnSeparateThread(final String value) {
        new Thread(new Runnable(){

            public void run() {
                try {
                    WatijTestCase.ie.button(value).click();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }).start();
    }

    public void testManySimple() throws Exception {
        for (int i = 0; i < 2; ++i) {
            ie.goTo(HTML_ROOT + "popups1.html");
            this.testSimple();
        }
    }

    public void testSimple() throws Exception {
        this.clickButtonOnSeparateThread("Alert");
        AlertDialog alertDialog = ie.alertDialog();
        PopupsTest.assertEquals((String)IE.TITLE, (String)alertDialog.title());
        PopupsTest.assertTrue((String)("This showed up instead: " + alertDialog.text()), (boolean)alertDialog.text().contains("This is an alert box"));
        alertDialog.ok();
        PopupsTest.assertFalse((boolean)alertDialog.exists());
    }

    public void testConfirmOK() throws Exception {
        this.clickButtonOnSeparateThread("Confirm");
        ConfirmDialog confirmDialog = ie.confirmDialog();
        PopupsTest.assertEquals((String)IE.TITLE, (String)confirmDialog.title());
        PopupsTest.assertTrue((boolean)confirmDialog.text().contains("Do you really want to do this"));
        confirmDialog.ok();
        PopupsTest.assertFalse((boolean)confirmDialog.exists());
        PopupsTest.assertTrue((boolean)ie.textField(SymbolFactory.name, "confirmtext").verifyContains("OK"));
    }

    public void testConfirmCancel() throws Exception {
        this.clickButtonOnSeparateThread("Confirm");
        ConfirmDialog confirmDialog = ie.confirmDialog();
        PopupsTest.assertEquals((String)IE.TITLE, (String)confirmDialog.title());
        PopupsTest.assertTrue((boolean)confirmDialog.text().contains("Do you really want to do this"));
        confirmDialog.cancel();
        PopupsTest.assertFalse((boolean)confirmDialog.exists());
        PopupsTest.assertTrue((boolean)ie.textField(SymbolFactory.name, "confirmtext").verifyContains("Cancel"));
    }

    public void testPromptCancel() throws Exception {
        this.clickButtonOnSeparateThread("Prompt");
        PromptDialog promptDialog = ie.promptDialog();
        PopupsTest.assertEquals((String)"Explorer User Prompt", (String)promptDialog.title());
        PopupsTest.assertTrue((boolean)promptDialog.text().contains("Enter something delightful"));
        promptDialog.cancel();
        PopupsTest.assertFalse((boolean)promptDialog.exists());
        PopupsTest.assertTrue((boolean)ie.textField(SymbolFactory.name, "prompttext").verifyContains("Cancel"));
    }

    public void testPromptEnterValue() throws Exception {
        this.clickButtonOnSeparateThread("Prompt");
        PromptDialog promptDialog = ie.promptDialog();
        PopupsTest.assertEquals((String)"Explorer User Prompt", (String)promptDialog.title());
        PopupsTest.assertTrue((boolean)promptDialog.text().contains("Enter something delightful"));
        PopupsTest.assertEquals((String)"hmm", (String)promptDialog.value());
        promptDialog.value("wow");
        PopupsTest.assertEquals((String)"wow", (String)promptDialog.value());
        promptDialog.ok();
        PopupsTest.assertFalse((boolean)promptDialog.exists());
        PopupsTest.assertTrue((boolean)ie.textField(SymbolFactory.name, "prompttext").verifyContains("wow"));
    }

    public void testFileDownladDialogCancel() throws Exception {
        FileDownloadDialog fileDownloadDialog = ie.fileDownloadDialog("http://watij.com/_media/wiki:test.zip");
        fileDownloadDialog.cancel();
        PopupsTest.assertFalse((boolean)fileDownloadDialog.exists());
    }

    public void testFileDownladDialogOpen() throws Exception {
        ie.fileDownloadDialog("http://watij.com/_media/wiki:test.zip").open();
    }

    public void testFileDownladDialogSaveAutoClose() throws Exception {
        FileDownloadDialog fileDownloadDialog = ie.fileDownloadDialog("http://watij.com/_media/wiki:test.zip");
        fileDownloadDialog.closeThisDialogBoxWhenDownloadCompletes(true);
        fileDownloadDialog.save("c:\\wow.zip");
    }

    public void testFileDownladDialogSaveNoAutoClose() throws Exception {
        FileDownloadDialog fileDownloadDialog = ie.fileDownloadDialog("http://watij.com/_media/wiki:test.zip");
        fileDownloadDialog.closeThisDialogBoxWhenDownloadCompletes(false);
        fileDownloadDialog.save("c:\\wow.zip");
        fileDownloadDialog.waitUntilDownloadComplete();
        fileDownloadDialog.close();
    }
}

