<!---//
////////////////////////////////////////////////////////////////////////////////
//	Copyright 2008 cfneo-Project, jp.sourceforge.cfneo and the Others.
//
//	http://sourceforge.jp/projects/cfneo
//
//	Licensed under the Apache License, Version 2.0 (the "License");
//	you may not use this file except in compliance with the License.
//	You may obtain a copy of the License at
//
//	    http://www.apache.org/licenses/LICENSE-2.0
//
//	Unless required by applicable law or agreed to in writing, software
//	distributed under the License is distributed on an "AS IS" BASIS,
//	WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
//	either express or implied. See the License for the specific language
//	governing permissions and limitations under the License.
////////////////////////////////////////////////////////////////////////////////
//--->
<?xml version="1.0" encoding="${encoding}" ?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
	<cfoutput>
		<cfset VARIABLES.pageTitle="Test driver list" />
		<head>
			<cfinclude template="#APPLICATION.ContentsRoot#/appcore/cfneounit/td_header.cfm" />
			<script>
				$(function() {
					$("##appcontext").click(function(e) {
						window.open("#APPLICATION.ContentsRoot#/appcore/common/appcontext.cfm");
					});
					$("##errorcodelist").click(function(e) {
						window.open("#APPLICATION.ContentsRoot#/appcore/common/CfneoUnitErrorCodeList.cfm");
					});
				});
			</script>
		</head>
		<body>
			<img src="#APPLICATION.ContentsRoot#/appcore/common/cfneo_logo.jpg" class="prjlogo" style="height: 50px;" />
			<input type="button" id="appcontext" name="appcontext" value="Show application Context" />
			<input type="button" id="errorcodelist" name="errorcodelist" value="Error Code List" />
			<h1>#VARIABLES.pageTitle#</h1>
			<a href="../../">Back</a>
			<cfif isExistValue("errmsg")>
				<div class="errmsg">#getValue("errmsg")#</div>
			</cfif>
			<cfif isExistValue("msg")>
				<div class="msg">#getValue("msg")#</div>
			</cfif>
			<table>
				<tr>
					<th>File name</th>
					<th>Link</th>
				</tr>
				<cfset VARIABLES.targetCount=0 />
				<cfset VARIABLES.driverCount=0 />
				<cfset writeFileList() />
				<caption>Target:[#VARIABLES.targetCount#] / Test driver:[#VARIABLES.driverCount#]</caption>
			</table>
		</body>
	</cfoutput>
</html>

<cffunction name="writeFileList" access="public" output="true" returntype="void">
	<cfargument name="root" type="string" required="false" />
	<cfset var rootPath="" />
	<cfset var dir="" />
	<cfset var path="" />
	<cfset var anchor="" />
	<cfset var pathutil=getComponentManager().getComponent("appcore.utils.PathUtil") />
	<cfset var other="" />
	<cfset var supporter=getComponentManager().getComponent("appcore.cfneounit.CfneoTestSupporter")>
	<cfset var relPath="" />
	<cfif IsDefined("ARGUMENTS.root")>
		<cfset rootPath=ARGUMENTS.root />
		<cfif not pathutil.isAbsolutePath(ARGUMENTS.root)>
			<cfset rootPath=ExpandPath(rootPath) />
		</cfif>
	<cfelse>
		<cfset rootPath=ExpandPath(APPLICATION.ContentsRoot) />
	</cfif>
	<cfdirectory action="list" directory="#rootPath#" name="dir" />
	<cfloop query="dir">
		<cfset path=dir.DIRECTORY & "\" & dir.NAME />
		<cfset relPath=pathutil.absolute2Relative(path) />
		<cfif dir.TYPE is "File">
			<cfif isViewable(path)>
				<cfset VARIABLES.targetCount=IncrementValue(VARIABLES.targetCount) />
				<tr>
					<td>#relPath#</td>
					<cfset anchor=supporter.getAnchor(path) />
					<cfif supporter.isExistTestDriver(path)>
						<td class="exist">
							<cfset VARIABLES.driverCount=IncrementValue(VARIABLES.driverCount) />
							<cfset timestamp="#DateFormat(dir.DATELASTMODIFIED, 'yyyymmdd')##TimeFormat(dir.DATELASTMODIFIED, 'hhmmss')#" />
							<a href="#anchor#?lastmodified=#timestamp#">Go test driver</a>
							<br />
							<div class="method">#getCompDetail(path)#</div>
						</td>
					<cfelse>
						<td class="noexist">
							<a href="./doCreateTestDriver.cfm?componentName=#relPath#">Create Test driver file.</a>
						</td>
					</cfif>
				</tr>
			</cfif>
		<cfelseif dir.TYPE is "Dir">
			<cfif dir.NAME neq "dev">
				<!---// appcoreĴׂ݂̈Skip(̃t@N^OK{I) //--->
				<cfif APPLICATION.ApplicationName is "cfneo"
						or (APPLICATION.ApplicationName neq "cfneo" and dir.NAME neq "appcore")>
					<cfset writeFileList(path) />
				</cfif>
			</cfif>
		</cfif>
	</cfloop>
</cffunction>

<cffunction name="getCompDetail" access="private" output="true" returntype="void">
	<cfargument name="modulePath" type="string" required="true" />
	<cfset var pathutil=getComponentManager().getComponent("appcore.utils.PathUtil") />
	<cfset var comutil=getComponentManager().getComponent("appcore.utils.ComponentUtil") />
	<cfset var mArray=comutil.getMethodNameArray(pathutil.absolute2Relative(ARGUMENTS.modulePath)) />
	<cfset var idx="" />
	<cfset var testDriver=pathutil.convertPathImpl2Test(ARGUMENTS.modulePath) />
	<cfset var f="" />
	<cfset var tableid=REReplace(pathutil.absolute2Relative(testDriver), "[\./]", "_", "all") />
	<cffile action="read" file="#ExpandPath(testDriver)#" variable="f" />
	<table class="testmethodlist" id="#tableid#">
		<tr>
			<th>Method</th>
			<th>Tested</th>
		</tr>
		<cfloop index="idx" from="1" to="#ArrayLen(mArray)#">
			<cfset find=REFindNoCase("<legend>#mArray[idx]#</legend>", f, 0, true) />
			<cfoutput>
			<tr>
				<td class="title">#mArray[idx]#</td>
				<cfif find.POS[1] gt 1 and find.LEN[1] gt 1>
					<td class="exist">쐬</td>
				<cfelse>
					<td class="noexist">쐬</td>
				</cfif>
			</tr>
			</cfoutput>
		</cfloop>
	</table>
</cffunction>

<cffunction name="isViewable" access="private" output="false" returntype="boolean">
	<cfargument name="path" type="string" required="true" />
	<cfset var pathutil=getComponentManager().getComponent("appcore.utils.PathUtil") />
	<cfset var supporter=getComponentManager().getComponent("appcore.cfneounit.CfneoTestSupporter")>
	<cfset var findset="" />
	<cfset var ret=true />
	<cfif supporter.isExistTestDriver(ARGUMENTS.path)>
		<cfset ret=true />
	</cfif>
	<cfif pathutil.getExtension(ARGUMENTS.path) neq ".cfc">
		<cfset ret=false />
	</cfif>
	<cfset findset=REFind(".*Facade.cfc$", ARGUMENTS.path, 0, true) />
	<cfif findset.POS[1] gt 0 or findset.LEN[1] gt 0>
		<cfset ret=false />
	</cfif>
	<cfreturn ret />
</cffunction>
