<!---//
////////////////////////////////////////////////////////////////////////////////
//	Copyright 2008 cfneo-Project, jp.sourceforge.cfneo and the Others.
//
//	http://sourceforge.jp/projects/cfneo
//
//	Licensed under the Apache License, Version 2.0 (the "License");
//	you may not use this file except in compliance with the License.
//	You may obtain a copy of the License at
//
//	    http://www.apache.org/licenses/LICENSE-2.0
//
//	Unless required by applicable law or agreed to in writing, software
//	distributed under the License is distributed on an "AS IS" BASIS,
//	WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
//	either express or implied. See the License for the specific language
//	governing permissions and limitations under the License.
////////////////////////////////////////////////////////////////////////////////
//--->
<?xml version="1.0" encoding="utf8"?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN"
 "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="ja" lang="ja">
	<cfoutput>
		<cfset pageTitle="Test driver [/examples/dao/TwDao]" />
		<head>
			<cfinclude template="#APPLICATION.ContentsRoot#/appcore/cfneounit/td_header.cfm" />
		</head>
		<body>
			<h1>#pageTitle#</h1>
			<fieldset>
				<legend>selectAll</legend>
				<table>
					<tr>
						<th>caseNo</th>
						<th>note</th>
						<th>input</th>
						<th>expected</th>
						<th>actual</th>
						<th>result</th>
					</tr>
					<cfset exp=createStatusArray() />
					<cfset act=getComponentManager().getComponent("examples.tw.dao.TwDao").selectAll() />
					<cfset assert("1", "invoke", "", exp, act) />
				</table>
			</fieldset>
			<fieldset>
				<legend>addStatus</legend>
				<table>
					<tr>
						<th>caseNo</th>
						<th>note</th>
						<th>input</th>
						<th>expected</th>
						<th>actual</th>
						<th>result</th>
					</tr>
					<cfset in=StructNew() />
					<cfset in.user="testuser" />
					<cfset in.status="teststatus" />
					<cfset exp=createStatusArray() />
					<cfset ArrayAppend(exp, in) />
					<cfset getComponentManager().getComponent("examples.tw.dao.TwDao")
							.addStatus(in.user, in.status) />
					<cfset act=createStatusArray() />
					<cfset assert("1", "invoke", in, exp, act) />

					<cfset in=StructNew() />
					<cfset in.user=" " />
					<cfset in.status="teststatus" />
					<cfset exp=createStatusArray() />
					<cfset ArrayAppend(exp, in) />
					<cfset getComponentManager().getComponent("examples.tw.dao.TwDao")
							.addStatus(in.user, in.status) />
					<cfset act=createStatusArray() />
					<cfset assert("2", "invoke", in, exp, act) />

					<cfset in=StructNew() />
					<cfset in.user="testuser" />
					<cfset in.status=" " />
					<cfset exp=createStatusArray() />
					<cfset ArrayAppend(exp, in) />
					<cfset getComponentManager().getComponent("examples.tw.dao.TwDao")
							.addStatus(in.user, in.status) />
					<cfset act=createStatusArray() />
					<cfset assert("3", "invoke", in, exp, act) />
				</table>
			</fieldset>
		</body>
	</cfoutput>
</html>
<cffunction name="createStatusArray" access="private" returntype="array">
	<cfset var f="" />
	<cfset var idx="" />
	<cfset var arr=ArrayNew(1) />
	<cfset var str="" />
	<cffile action="read" file="#ExpandPath('/cfneo/examples/tw/dao/files/status.txt')#" variable="f" />
	<cfloop index="idx" list="#f#" delimiters="#Chr(10)##Chr(13)#">
		<cfset str=StructNew() />
		<cfset str.user=ListGetAt(idx, 1, ",") />
		<cfset str.status=ListGetAt(idx, 2, ",") />
		<cfset ArrayAppend(arr, str) />
	</cfloop>
	<cfreturn arr />
</cffunction>
