<!---//
////////////////////////////////////////////////////////////////////////////////
//	Copyright 2008 cfneo-Project, jp.sourceforge.cfneo and the Others.
//
//	http://sourceforge.jp/projects/cfneo
//
//	Licensed under the Apache License, Version 2.0 (the "License");
//	you may not use this file except in compliance with the License.
//	You may obtain a copy of the License at
//
//	    http://www.apache.org/licenses/LICENSE-2.0
//
//	Unless required by applicable law or agreed to in writing, software
//	distributed under the License is distributed on an "AS IS" BASIS,
//	WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
//	either express or implied. See the License for the specific language
//	governing permissions and limitations under the License.
////////////////////////////////////////////////////////////////////////////////
//--->
<?xml version="1.0" encoding="utf8"?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN"
 "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="ja" lang="ja">
	<cfoutput>
		<cfset pageTitle="Test driver [appcore/cfneounit/CfneoTestRunner.cfc]" />
		<head>
			<cfinclude template="#APPLICATION.ContentsRoot#/appcore/cfneounit/td_header.cfm" />
		</head>
		<body>
			<h1>#pageTitle#</h1>
			<cfset com=getComponentManager().getComponent("appcore.cfneounit.CfneoTestRunner") />
			<fieldset>
				<legend>assert</legend>
				ȉŎgĂ܂B
			</fieldset>
			<fieldset>
				<legend>outputData</legend>
				<table>
					<tr>
						<th>caseNo</th>
						<th>note</th>
						<th>input</th>
						<th>expected</th>
						<th>actual</th>
						<th>result</th>
					</tr>
					<cfset caseNo=0 />

					<cfset caseNo=IncrementValue(caseNo) />
					<tr>
						<th>#caseNo#</th>
						<td colspan="5"><cfset com.outputData(1234) /></td>
					</tr>

					<cfset caseNo=IncrementValue(caseNo) />
					<tr>
						<th>#caseNo#</th>
						<td colspan="5"><cfset com.outputData(true) /></td>
					</tr>

					<cfset caseNo=IncrementValue(caseNo) />
					<tr>
						<th>#caseNo#</th>
						<td colspan="5"><cfset com.outputData(false) /></td>
					</tr>

					<cfset caseNo=IncrementValue(caseNo) />
					<tr>
						<th>#caseNo#</th>
						<td colspan="5"><cfset com.outputData("1234") /></td>
					</tr>

					<cfset caseNo=IncrementValue(caseNo) />
					<tr>
						<th>#caseNo#</th>
						<td colspan="5"><cfset com.outputData("abcde") /></td>
					</tr>

					<cfset caseNo=IncrementValue(caseNo) />
					<tr>
						<th>#caseNo#</th>
						<td colspan="5"><cfset com.outputData(Now()) /></td>
					</tr>

					<cfset caseNo=IncrementValue(caseNo) />
					<tr>
						<th>#caseNo#</th>
						<cfset in=ArrayNew(1) />
						<cfset ArrayAppend(in, "aaa") />
						<td colspan="5"><cfset com.outputData(in) /></td>
					</tr>

					<cfset caseNo=IncrementValue(caseNo) />
					<tr>
						<th>#caseNo#</th>
						<cfset in=StructNew() />
						<cfset in.aaa="aaa" />
						<td colspan="5"><cfset com.outputData(in) /></td>
					</tr>

					<cfset caseNo=IncrementValue(caseNo) />
					<tr>
						<th>#caseNo#</th>
						<cfset in=QueryNew("col1,col2", "VarChar,VarChar") />
						<cfset QueryAddRow(in, 1) />
						<cfset QuerySetCell(in, "col1", "aaaa", 1) />
						<cfset QuerySetCell(in, "col2", "bbbb", 1) />
						<td colspan="5"><cfset com.outputData(in) /></td>
					</tr>

				</table>
			</fieldset>
			<fieldset>
				<legend>assertData</legend>
				<table>
					<tr>
						<th>caseNo</th>
						<th>note</th>
						<th>input</th>
						<th>expected</th>
						<th>actual</th>
						<th>result</th>
					</tr>
					<cfset caseNo=0 />

					<cfset caseNo=IncrementValue(caseNo) />
					<cfset in=StructNew() />
					<cfset in.exp=0 />
					<cfset in.act=0 />
					<cfset exp="" />
					<cfset doAssertData(caseNo, "mOK", in, exp) />

					<cfset caseNo=IncrementValue(caseNo) />
					<cfset in=StructNew() />
					<cfset in.exp=1234 />
					<cfset in.act=1234 />
					<cfset exp="" />
					<cfset doAssertData(caseNo, "mOK", in, exp) />

					<cfset caseNo=IncrementValue(caseNo) />
					<cfset in=StructNew() />
					<cfset in.exp=-1234 />
					<cfset in.act=-1234 />
					<cfset exp="" />
					<cfset doAssertData(caseNo, "̐mOK", in, exp) />

					<cfset caseNo=IncrementValue(caseNo) />
					<cfset in=StructNew() />
					<cfset in.exp=1.5 />
					<cfset in.act=1.5 />
					<cfset exp="" />
					<cfset doAssertData(caseNo, "mOK", in, exp) />

					<cfset caseNo=IncrementValue(caseNo) />
					<cfset in=StructNew() />
					<cfset in.exp="" />
					<cfset in.act="" />
					<cfset exp="" />
					<cfset doAssertData(caseNo, "mOK", in, exp) />

					<cfset caseNo=IncrementValue(caseNo) />
					<cfset in=StructNew() />
					<cfset in.exp=" " />
					<cfset in.act=" " />
					<cfset exp="" />
					<cfset doAssertData(caseNo, "mOK", in, exp) />

					<cfset caseNo=IncrementValue(caseNo) />
					<cfset in=StructNew() />
					<cfset in.exp="abcde" />
					<cfset in.act="abcde" />
					<cfset exp="" />
					<cfset doAssertData(caseNo, "mOK", in, exp) />

					<cfset caseNo=IncrementValue(caseNo) />
					<cfset in=StructNew() />
					<cfset in.exp="" />
					<cfset in.act="" />
					<cfset exp="" />
					<cfset doAssertData(caseNo, "mOK", in, exp) />

					<cfset caseNo=IncrementValue(caseNo) />
					<cfset in=StructNew() />
					<cfset in.exp=true />
					<cfset in.act=true />
					<cfset exp="" />
					<cfset doAssertData(caseNo, "booleanmOK", in, exp) />

					<cfset caseNo=IncrementValue(caseNo) />
					<cfset in=StructNew() />
					<cfset in.exp=false />
					<cfset in.act=false />
					<cfset exp="" />
					<cfset doAssertData(caseNo, "booleanmOK", in, exp) />

					<cfset caseNo=IncrementValue(caseNo) />
					<cfset in=StructNew() />
					<cfset in.exp=CreateDateTime(2008, 9, 6, 13, 0, 0) />
					<cfset in.act=CreateDateTime(2008, 9, 6, 13, 0, 0) />
					<cfset exp="" />
					<cfset doAssertData(caseNo, "tmOK", in, exp) />

					<cfset caseNo=IncrementValue(caseNo) />
					<cfset in=StructNew() />
					<cfset in.exp=StructNew() />
					<cfset in.exp.aaa="aaa" />
					<cfset in.act=StructNew() />
					<cfset in.act.aaa="aaa" />
					<cfset exp="" />
					<cfset doAssertData(caseNo, "\̓mOK", in, exp) />

					<cfset caseNo=IncrementValue(caseNo) />
					<cfset in=StructNew() />
					<cfset in.exp=ArrayNew(1) />
					<cfset ArrayAppend(in.exp, "aaa") />
					<cfset in.act=ArrayNew(1) />
					<cfset ArrayAppend(in.act, "aaa") />
					<cfset exp="" />
					<cfset doAssertData(caseNo, "z񓯎mOK", in, exp) />

					<cfset caseNo=IncrementValue(caseNo) />
					<cfset in=StructNew() />
					<cfset in.exp=CreateObject("component", "cfneo.appcore.Application") />
					<cfset in.act=CreateObject("component", "cfneo.appcore.Application") />
					<cfset exp="" />
					<cfset doAssertData(caseNo, "ObjectmOK", in, exp) />

					<cfset caseNo=IncrementValue(caseNo) />
					<cfset in=StructNew() />
					<cfset in=StructNew() />
					<cfset in.exp=QueryNew("col1,col2", "VarChar,VarChar") />
					<cfset QueryAddRow(in.exp, 1) />
					<cfset QuerySetCell(in.exp, "col1", "aaaa", 1) />
					<cfset QuerySetCell(in.exp, "col2", "bbbb", 1) />
					<cfset in.act=QueryNew("col1,col2", "VarChar,VarChar") />
					<cfset QueryAddRow(in.act, 1) />
					<cfset QuerySetCell(in.act, "col1", "aaaa", 1) />
					<cfset QuerySetCell(in.act, "col2", "bbbb", 1) />
					<cfset exp="" />
					<cfset doAssertData(caseNo, "querymOK", in, exp) />

					<cfset caseNo=IncrementValue(caseNo) />
					<cfset in=StructNew() />
					<cfset in=StructNew() />
					<cfset in.exp=QueryNew("col1,col2", "VarChar,VarChar") />
					<cfset QueryAddRow(in.exp, 1) />
					<cfset QuerySetCell(in.exp, "col1", "aaaa", 1) />
					<cfset QuerySetCell(in.exp, "col2", "bbbb", 1) />
					<cfset in.act=QueryNew("col1,col2,col3", "VarChar,VarChar,VarChar") />
					<cfset QueryAddRow(in.act, 1) />
					<cfset QuerySetCell(in.act, "col1", "aaaa", 1) />
					<cfset QuerySetCell(in.act, "col2", "bbbb", 1) />
					<cfset QuerySetCell(in.act, "col3", "cccc", 1) />
					<cfset exp="assertQuery-002" />
					<cfset doAssertData(caseNo, "querymNG", in, exp) />

					<cfset caseNo=IncrementValue(caseNo) />
					<cfset in=StructNew() />
					<cfset in=StructNew() />
					<cfset in.exp=QueryNew("col1,col2", "VarChar,VarChar") />
					<cfset QueryAddRow(in.exp, 1) />
					<cfset QuerySetCell(in.exp, "col1", "aaaa", 1) />
					<cfset QuerySetCell(in.exp, "col2", "bbbb", 1) />
					<cfset in.act=QueryNew("col1,col2", "VarChar,VarChar") />
					<cfset QueryAddRow(in.act, 2) />
					<cfset QuerySetCell(in.act, "col1", "aaaa", 1) />
					<cfset QuerySetCell(in.act, "col2", "bbbb", 1) />
					<cfset QuerySetCell(in.act, "col1", "cccc", 2) />
					<cfset QuerySetCell(in.act, "col2", "dddd", 2) />
					<cfset exp="assertQuery-001" />
					<cfset doAssertData(caseNo, "querymNG", in, exp) />

					<cfset caseNo=IncrementValue(caseNo) />
					<cfset in=StructNew() />
					<cfset in.exp=CreateObject("component", "cfneo.appcore.Application") />
					<cfset in.act=CreateObject("component", "cfneo.appcore.ComponentManager") />
					<cfset exp="assertStruct-001" />
					<cfset doAssertData(caseNo, "ObjectmNG", in, exp) />

					<cfset caseNo=IncrementValue(caseNo) />
					<cfset in=StructNew() />
					<cfset in.exp=ArrayNew(1) />
					<cfset ArrayAppend(in.exp, "bbb") />
					<cfset in.act=ArrayNew(1) />
					<cfset ArrayAppend(in.act, "aaa") />
					<cfset exp="assertArray-002" />
					<cfset doAssertData(caseNo, "z񓯎mNG", in, exp) />

					<cfset caseNo=IncrementValue(caseNo) />
					<cfset in=StructNew() />
					<cfset in.exp=ArrayNew(1) />
					<cfset ArrayAppend(in.exp, "aaa") />
					<cfset ArrayAppend(in.exp, "bbb") />
					<cfset in.act=ArrayNew(1) />
					<cfset ArrayAppend(in.act, "aaa") />
					<cfset exp="assertArray-001" />
					<cfset doAssertData(caseNo, "z񓯎mNG", in, exp) />

					<cfset caseNo=IncrementValue(caseNo) />
					<cfset in=StructNew() />
					<cfset in.exp=StructNew() />
					<cfset in.exp.aaa="aaa" />
					<cfset in.act=StructNew() />
					<cfset in.act.aaa="bbb" />
					<cfset exp="assertStruct-002" />
					<cfset doAssertData(caseNo, "\̓mNG", in, exp) />

					<cfset caseNo=IncrementValue(caseNo) />
					<cfset in=StructNew() />
					<cfset in.exp=StructNew() />
					<cfset in.exp.aaa="aaa" />
					<cfset in.exp.bbb="bbb" />
					<cfset in.act=StructNew() />
					<cfset in.act.aaa="aaa" />
					<cfset exp="assertStruct-001" />
					<cfset doAssertData(caseNo, "\̓mNG", in, exp) />

					<cfset caseNo=IncrementValue(caseNo) />
					<cfset in=StructNew() />
					<cfset in.exp=CreateDateTime(2008, 9, 6, 13, 0, 0) />
					<cfset in.act=CreateDateTime(2007, 9, 6, 13, 0, 0) />
					<cfset exp="assertData-002" />
					<cfset doAssertData(caseNo, "tmNG", in, exp) />

					<cfset caseNo=IncrementValue(caseNo) />
					<cfset in=StructNew() />
					<cfset in.exp=CreateDateTime(2008, 9, 6, 13, 0, 0) />
					<cfset in.act=CreateDateTime(2008, 9, 6, 12, 59, 59) />
					<cfset exp="assertData-002" />
					<cfset doAssertData(caseNo, "tmNG", in, exp) />

					<cfset caseNo=IncrementValue(caseNo) />
					<cfset in=StructNew() />
					<cfset in.exp=true />
					<cfset in.act=false />
					<cfset exp="assertData-003" />
					<cfset doAssertData(caseNo, "booleanmNG", in, exp) />

					<cfset caseNo=IncrementValue(caseNo) />
					<cfset in=StructNew() />
					<cfset in.exp=false />
					<cfset in.act=true />
					<cfset exp="assertData-003" />
					<cfset doAssertData(caseNo, "booleanmNG", in, exp) />

					<cfset caseNo=IncrementValue(caseNo) />
					<cfset in=StructNew() />
					<cfset in.exp="123" />
					<cfset in.act="PQR" />
					<cfset exp="assertData-001" />
					<cfset doAssertData(caseNo, "mNG", in, exp) />

					<cfset caseNo=IncrementValue(caseNo) />
					<cfset in=StructNew() />
					<cfset in.exp="abcde" />
					<cfset in.act="ABCDE" />
					<cfset exp="assertData-004" />
					<cfset doAssertData(caseNo, "mNG", in, exp) />

					<cfset caseNo=IncrementValue(caseNo) />
					<cfset in=StructNew() />
					<cfset in.exp=" " />
					<cfset in.act="@" />
					<cfset exp="assertData-002" />
					<cfset doAssertData(caseNo, "Xy[XmNG", in, exp) />
					
					<cfset caseNo=IncrementValue(caseNo) />
					<cfset in=StructNew() />
					<cfset in.exp="String" />
					<cfset in.act=Now() />
					<cfset exp="assertData-001" />
					<cfset doAssertData(caseNo, "^قȂꍇiString-Datej", in, exp) />

					<cfset caseNo=IncrementValue(caseNo) />
					<cfset in=StructNew() />
					<cfset in.exp="String" />
					<cfset in.act=True />
					<cfset exp="assertData-001" />
					<cfset doAssertData(caseNo, "^قȂꍇiString-Booleanj", in, exp) />

					<cfset caseNo=IncrementValue(caseNo) />
					<cfset in=StructNew() />
					<cfset in.exp="String" />
					<cfset in.act=1234 />
					<cfset exp="assertData-001" />
					<cfset doAssertData(caseNo, "^قȂꍇiString-Numericj", in, exp) />
					
					<cfset caseNo=IncrementValue(caseNo) />
					<cfset in=StructNew() />
					<cfset in.exp="String" />
					<cfset in.act=QueryNew("col1,col2", "VarChar,VarChar") />
					<cfset QueryAddRow(in.act, 2) />
					<cfset QuerySetCell(in.act, "col1", "aaaa", 1) />
					<cfset QuerySetCell(in.act, "col2", "bbbb", 1) />
					<cfset exp="assertData-001" />
					<cfset doAssertData(caseNo, "^قȂꍇiString-Queryj", in, exp) />
					
					<cfset caseNo=IncrementValue(caseNo) />
					<cfset in=StructNew() />
					<cfset in.exp="String" />
					<cfset in.act=ArrayNew(1) />
					<cfset in.act[1]=0 />
					<cfset in.act[2]=1 />
					<cfset in.act[3]=2 />
					<cfset exp="assertData-001" />
					<cfset doAssertData(caseNo, "^قȂꍇiString-Arrayj", in, exp) />
					
					<cfset caseNo=IncrementValue(caseNo) />
					<cfset in=StructNew() />
					<cfset in.exp="String" />
					<cfset in.act=StructNew() />
					<cfset in.act.val1=123 />
					<cfset in.act.val2=234 />
					<cfset exp="assertData-001" />
					<cfset doAssertData(caseNo, "^قȂꍇiString-Structj", in, exp) />
					
					<cfset caseNo=IncrementValue(caseNo) />
					<cfset in=StructNew() />
					<cfset in.exp="String" />
					<cfset in.act=CreateObject("component", "cfneo.appcore.Application") />
					<cfset exp="assertData-001" />
					<cfset doAssertData(caseNo, "^قȂꍇiString-Objectj", in, exp) />
										
					<cfset caseNo=IncrementValue(caseNo) />
					<cfset in=StructNew() />
					<cfset in.exp="String" />
					<cfset in.act="STRING" />
					<cfset exp="assertData-004" />
					<cfset doAssertData(caseNo, "ŁANearyEqual(啶̑̂)̏ꍇ", in, exp) />

					<cfset caseNo=IncrementValue(caseNo) />
					<cfset filePath=ExpandPath("./CfneoTestRunnerTest/5lines.txt")>
					<cflock scope="application" type="readonly" throwontimeout="true" timeout="0">
						<cffile action="read" file="#filePath#" variable="fexp" />
					</cflock>
					<cflock scope="application" type="readonly" throwontimeout="true" timeout="0">
						<cffile action="read" file="#filePath#" variable="fact" />
					</cflock>
					<cfset in=StructNew() />
					<cfset in.exp=fexp />
					<cfset in.act=fact />
					<cfset exp="" />
					<cfset doAssertData(caseNo, "t@CȅꍇisOKj", in, exp) />


					<cfset caseNo=IncrementValue(caseNo) />
					<cfset filePath=ExpandPath("./CfneoTestRunnerTest/5lines.txt")>
					<cflock scope="application" type="readonly" throwontimeout="true" timeout="0">
						<cffile action="read" file="#filePath#" variable="fexp" />
					</cflock>
					<cfset filePathAct=ExpandPath("./CfneoTestRunnerTest/4lines.txt")>
					<cflock scope="application" type="readonly" throwontimeout="true" timeout="0">
						<cffile action="read" file="#filePathAct#" variable="fact" />
					</cflock>
					<cfset in=StructNew() />
					<cfset in.exp=fexp />
					<cfset in.act=fact />
					<cfset exp="assertArray-001" />
					<cfset doAssertData(caseNo, "t@CȅꍇisNGj", in, exp) />

				</table>
			</fieldset>
			<fieldset>
				<legend>assertArray</legend>
				<table>
					<tr>
						<th>caseNo</th>
						<th>note</th>
						<th>input</th>
						<th>expected</th>
						<th>actual</th>
						<th>result</th>
					</tr>
					<cfset caseNo=0 />

					<cfset caseNo=IncrementValue(caseNo) />
					<cfset in=StructNew() />
					<cfset in.exp=ArrayNew(1) />
					<cfset in.act=ArrayNew(1) />
					<cfset exp="" />
					<cfset act="" />
					<cftry>
						<cfset com.assertArray(in.exp, in.act) />
						<cfcatch>
							<cfset act=cfcatch.ErrorCode />
						</cfcatch>
					</cftry>
					<cfset assert(caseNo, "󓯎m", in, exp, act) />

					<cfset caseNo=IncrementValue(caseNo) />
					<cfset in=StructNew() />
					<cfset in.exp=ArrayNew(1) />
					<cfset ArrayAppend(in.exp, "aaa") />
					<cfset in.act=ArrayNew(1) />
					<cfset ArrayAppend(in.act, "aaa") />
					<cfset exp="" />
					<cfset act="" />
					<cftry>
						<cfset com.assertArray(in.exp, in.act) />
						<cfcatch>
							<cfset act=cfcatch.ErrorCode />
						</cfcatch>
					</cftry>
					<cfset assert(caseNo, "1sm", in, exp, act) />

					<cfset caseNo=IncrementValue(caseNo) />
					<cfset in=StructNew() />
					<cfset in.exp=ArrayNew(1) />
					<cfset ArrayAppend(in.exp, "aaa") />
					<cfset ArrayAppend(in.exp, "bbb") />
					<cfset in.act=ArrayNew(1) />
					<cfset ArrayAppend(in.act, "aaa") />
					<cfset ArrayAppend(in.act, "bbb") />
					<cfset exp="" />
					<cfset act="" />
					<cftry>
						<cfset com.assertArray(in.exp, in.act) />
						<cfcatch>
							<cfset act=cfcatch.ErrorCode />
						</cfcatch>
					</cftry>
					<cfset assert(caseNo, "2sm", in, exp, act) />

					<cfset caseNo=IncrementValue(caseNo) />
					<cfset in=StructNew() />
					<cfset in.exp=ArrayNew(1) />
					<cfset in.act=ArrayNew(1) />
					<cfset ArrayAppend(in.act, "aaa") />
					<cfset exp="assertArray-001" />
					<cfset act="" />
					<cftry>
						<cfset com.assertArray(in.exp, in.act) />
						<cfcatch>
							<cfset act=cfcatch.ErrorCode />
						</cfcatch>
					</cftry>
					<cfset assert(caseNo, "0s1s", in, exp, act) />

					<cfset caseNo=IncrementValue(caseNo) />
					<cfset in=StructNew() />
					<cfset in.exp=ArrayNew(1) />
					<cfset ArrayAppend(in.exp, "aaa") />
					<cfset in.act=ArrayNew(1) />
					<cfset ArrayAppend(in.act, "aaa") />
					<cfset ArrayAppend(in.act, "bbb") />
					<cfset exp="assertArray-001" />
					<cfset act="" />
					<cftry>
						<cfset com.assertArray(in.exp, in.act) />
						<cfcatch>
							<cfset act=cfcatch.ErrorCode />
						</cfcatch>
					</cftry>
					<cfset assert(caseNo, "1s2s", in, exp, act) />

					<cfset caseNo=IncrementValue(caseNo) />
					<cfset in=StructNew() />
					<cfset in.exp=ArrayNew(1) />
					<cfset ArrayAppend(in.exp, "aaa") />
					<cfset ArrayAppend(in.exp, "bbb") />
					<cfset in.act=ArrayNew(1) />
					<cfset ArrayAppend(in.act, "aaa") />
					<cfset ArrayAppend(in.act, "bbb") />
					<cfset ArrayAppend(in.act, "ccc") />
					<cfset exp="assertArray-001" />
					<cfset act="" />
					<cftry>
						<cfset com.assertArray(in.exp, in.act) />
						<cfcatch>
							<cfset act=cfcatch.ErrorCode />
						</cfcatch>
					</cftry>
					<cfset assert(caseNo, "2s3s", in, exp, act) />

					<cfset caseNo=IncrementValue(caseNo) />
					<cfset in=StructNew() />
					<cfset in.exp=ArrayNew(1) />
					<cfset ArrayAppend(in.exp, "aaa") />
					<cfset ArrayAppend(in.exp, "bbb") />
					<cfset in.act=ArrayNew(1) />
					<cfset ArrayAppend(in.act, "aaa") />
					<cfset ArrayAppend(in.act, "bbbd") />
					<cfset exp="assertArray-002" />
					<cfset act="" />
					<cftry>
						<cfset com.assertArray(in.exp, in.act) />
						<cfcatch>
							<cfset act=cfcatch.ErrorCode />
						</cfcatch>
					</cftry>
					<cfset assert(caseNo, "gႤ(1s)", in, exp, act) />

					<cfset caseNo=IncrementValue(caseNo) />
					<cfset in=StructNew() />
					<cfset in.exp=ArrayNew(1) />
					<cfset ArrayAppend(in.exp, "aaad") />
					<cfset ArrayAppend(in.exp, "bbb") />
					<cfset in.act=ArrayNew(1) />
					<cfset ArrayAppend(in.act, "aaa") />
					<cfset ArrayAppend(in.act, "bbb") />
					<cfset exp="assertArray-002" />
					<cfset act="" />
					<cftry>
						<cfset com.assertArray(in.exp, in.act) />
						<cfcatch>
							<cfset act=cfcatch.ErrorCode />
						</cfcatch>
					</cftry>
					<cfset assert(caseNo, "gႤ(2s)", in, exp, act) />
					<cfset caseNo=IncrementValue(caseNo) />

					<cfset caseNo=IncrementValue(caseNo) />
					<cfset in=StructNew() />
					<cfset in.exp=ArrayNew(1) />
					<cfset ArrayAppend(in.exp, ArrayNew(1)) />
					<cfset ArrayAppend(in.exp, ArrayNew(1)) />
					<cfset in.act=ArrayNew(1) />
					<cfset ArrayAppend(in.act, ArrayNew(1)) />
					<cfset ArrayAppend(in.act, ArrayNew(1)) />
					<cfset exp="" />
					<cfset act="" />
					<cftry>
						<cfset com.assertArray(in.exp, in.act) />
						<cfcatch>
							<cfset act=cfcatch.ErrorCode />
						</cfcatch>
					</cftry>
					<cfset assert(caseNo, "dzij<br>l`FbN", in, exp, act) />

					<cfset caseNo=IncrementValue(caseNo) />
					<cfset in=StructNew() />
					<cfset in.exp=ArrayNew(1) />
					<cfset ArrayAppend(in.exp, ArrayNew(1)) />
					<cfset ArrayAppend(in.exp, ArrayNew(1)) />
					<cfset ArrayAppend(in.exp[1], "aaa")>
					<cfset in.act=ArrayNew(1) />
					<cfset ArrayAppend(in.act, ArrayNew(1)) />
					<cfset ArrayAppend(in.act, ArrayNew(1)) />
					<cfset ArrayAppend(in.exp[1], "aaa")>
					<cfset exp="assertArray-001" />
					<cfset act="" />
					<cftry>
						<cfset com.assertArray(in.exp, in.act) />
						<cfcatch>
							<cfset act=cfcatch.ErrorCode />
						</cfcatch>
					</cftry>
					<cfset assert(caseNo, "dz(l)<br>l`FbN", in, exp, act) />

					<cfset caseNo=IncrementValue(caseNo) />
					<cfset in=StructNew() />
					<cfset in.exp=ArrayNew(1) />
					<cfset ArrayAppend(in.exp, ArrayNew(1)) />
					<cfset ArrayAppend(in.exp, ArrayNew(1)) />
					<cfset ArrayAppend(in.exp[1], "aaa")>
					<cfset in.act=ArrayNew(1) />
					<cfset ArrayAppend(in.act, ArrayNew(1)) />
					<cfset ArrayAppend(in.act, ArrayNew(1)) />
					<cfset ArrayAppend(in.act[1], "AAA")>
					<cfset exp="assertData-004" />
					<cfset act="" />
					<cftry>
						<cfset com.assertArray(in.exp, in.act) />
						<cfcatch>
							<cfset act=cfcatch.ErrorCode />
						</cfcatch>
					</cftry>
					<cfset assert(caseNo, "dz(l)<br>`FbN", in, exp, act) />
				</table>
			</fieldset>
			<fieldset>
				<legend>assertStruct</legend>
				<table>
					<tr>
						<th>caseNo</th>
						<th>note</th>
						<th>input</th>
						<th>expected</th>
						<th>actual</th>
						<th>result</th>
					</tr>
					<cfset caseNo=0 />

					<cfset caseNo=IncrementValue(caseNo) />
					<cfset in=StructNew() />
					<cfset in.exp=StructNew() />
					<cfset in.exp.aaa="aaa" />
					<cfset in.act=StructNew() />
					<cfset in.act.aaa="aaa" />
					<cfset exp="" />
					<cfset doAssertData(caseNo, "\̓mOK", in, exp) />

					<cfset caseNo=IncrementValue(caseNo) />
					<cfset in=StructNew() />
					<cfset in.exp=StructNew() />
					<cfset in.exp.aaa="aaa" />
					<cfset in.act=StructNew() />
					<cfset in.act.aaa="bbb" />
					<cfset exp="assertStruct-002" />
					<cfset doAssertData(caseNo, "\̓mNG", in, exp) />

					<cfset caseNo=IncrementValue(caseNo) />
					<cfset in=StructNew() />
					<cfset in.exp=StructNew() />
					<cfset in.exp.aaa="aaa" />
					<cfset in.exp.bbb="bbb" />
					<cfset in.act=StructNew() />
					<cfset in.act.aaa="aaa" />
					<cfset exp="assertStruct-001" />
					<cfset doAssertData(caseNo, "\̓mNG", in, exp) />
				</table>
			</fieldset>
			<fieldset>
				<legend>assertQuery</legend>
				<table>
					<tr>
						<th>caseNo</th>
						<th>note</th>
						<th>input</th>
						<th>expected</th>
						<th>actual</th>
						<th>result</th>
					</tr>
					<cfset caseNo=0 />

					<cfset caseNo=IncrementValue(caseNo) />
					<cfset in=StructNew() />
					<cfset in.exp=QueryNew("col1,col2", "VarChar,VarChar") />
					<cfset in.act=QueryNew("col1,col2", "VarChar,VarChar") />
					<cfset exp="" />
					<cfset act="" />
					<cftry>
						<cfset com.assertQuery(in.exp, in.act) />
						<cfcatch>
							<cfset act=cfcatch.ErrorCode />
						</cfcatch>
					</cftry>
					<cfset assert(caseNo, "0s", in, exp, act) />

					<cfset caseNo=IncrementValue(caseNo) />
					<cfset in=StructNew() />
					<cfset in.exp=QueryNew("col1,col2", "VarChar,VarChar") />
					<cfset QueryAddRow(in.exp, 2) />
					<cfset QuerySetCell(in.exp, "col1", "aaaa", 1) />
					<cfset QuerySetCell(in.exp, "col2", "bbbb", 1) />
					<cfset in.act=QueryNew("col1,col2", "VarChar,VarChar") />
					<cfset QueryAddRow(in.act, 2) />
					<cfset QuerySetCell(in.act, "col1", "aaaa", 1) />
					<cfset QuerySetCell(in.act, "col2", "bbbb", 1) />
					<cfset exp="" />
					<cfset act="" />
					<cftry>
						<cfset com.assertQuery(in.exp, in.act) />
						<cfcatch>
							<cfset act=cfcatch.ErrorCode />
						</cfcatch>
					</cftry>
					<cfset assert(caseNo, "1s", in, exp, act) />

					<cfset caseNo=IncrementValue(caseNo) />
					<cfset in=StructNew() />
					<cfset in.exp=QueryNew("col1,col2", "VarChar,VarChar") />
					<cfset QueryAddRow(in.exp, 2) />
					<cfset QuerySetCell(in.exp, "col1", "aaaa", 1) />
					<cfset QuerySetCell(in.exp, "col2", "bbbb", 1) />
					<cfset QuerySetCell(in.exp, "col1", "ccccc", 2) />
					<cfset QuerySetCell(in.exp, "col2", "ddddd", 2) />
					<cfset in.act=QueryNew("col1,col2", "VarChar,VarChar") />
					<cfset QueryAddRow(in.act, 2) />
					<cfset QuerySetCell(in.act, "col1", "aaaa", 1) />
					<cfset QuerySetCell(in.act, "col2", "bbbb", 1) />
					<cfset QuerySetCell(in.act, "col1", "ccccc", 2) />
					<cfset QuerySetCell(in.act, "col2", "ddddd", 2) />
					<cfset exp="" />
					<cfset act="" />
					<cftry>
						<cfset com.assertQuery(in.exp, in.act) />
						<cfcatch>
							<cfset act=cfcatch.ErrorCode />
						</cfcatch>
					</cftry>
					<cfset assert(caseNo, "2s", in, exp, act) />

					<cfset caseNo=IncrementValue(caseNo) />
					<cfset in=StructNew() />
					<cfset in.exp=QueryNew("col1,col2", "VarChar,VarChar") />
					<cfset in.act=QueryNew("col1,col2", "VarChar,VarChar") />
					<cfset QueryAddRow(in.act, 2) />
					<cfset QuerySetCell(in.act, "col1", "aaaa", 1) />
					<cfset QuerySetCell(in.act, "col2", "bbbb", 1) />
					<cfset exp="assertQuery-001" />
					<cfset act="" />
					<cftry>
						<cfset com.assertQuery(in.exp, in.act) />
						<cfcatch>
							<cfset act=cfcatch.ErrorCode />
						</cfcatch>
					</cftry>
					<cfset assert(caseNo, "0s1s", in, exp, act) />

					<cfset caseNo=IncrementValue(caseNo) />
					<cfset in=StructNew() />
					<cfset in.exp=QueryNew("col1,col2", "VarChar,VarChar") />
					<cfset QueryAddRow(in.exp, 2) />
					<cfset QuerySetCell(in.exp, "col1", "aaaa", 1) />
					<cfset QuerySetCell(in.exp, "col2", "bbbb", 1) />
					<cfset QuerySetCell(in.exp, "col1", "ccccc", 2) />
					<cfset QuerySetCell(in.exp, "col2", "ddddd", 2) />
					<cfset in.act=QueryNew("col1,col2,col3", "VarChar,VarChar,VarChar") />
					<cfset QueryAddRow(in.act, 2) />
					<cfset QuerySetCell(in.act, "col1", "aaaaa", 1) />
					<cfset QuerySetCell(in.act, "col2", "bbbbb", 1) />
					<cfset QuerySetCell(in.act, "col3", "ccccc", 1) />
					<cfset QuerySetCell(in.act, "col1", "dddd", 2) />
					<cfset QuerySetCell(in.act, "col2", "eeee", 2) />
					<cfset QuerySetCell(in.act, "col3", "ffff", 2) />
					<cfset exp="assertQuery-002" />
					<cfset act="" />
					<cftry>
						<cfset com.assertQuery(in.exp, in.act) />
						<cfcatch>
							<cfset act=cfcatch.ErrorCode />
						</cfcatch>
					</cftry>
					<cfset assert(caseNo, "JႤ", in, exp, act) />

					<cfset caseNo=IncrementValue(caseNo) />
					<cfset in=StructNew() />
					<cfset in.exp=QueryNew("col1,col2", "VarChar,VarChar") />
					<cfset QueryAddRow(in.exp, 2) />
					<cfset QuerySetCell(in.exp, "col1", "aaaa", 1) />
					<cfset QuerySetCell(in.exp, "col2", "bbbb", 1) />
					<cfset QuerySetCell(in.exp, "col1", "ccccc", 2) />
					<cfset QuerySetCell(in.exp, "col2", "ddddd", 2) />
					<cfset in.act=QueryNew("col1,col2", "VarChar,VarChar") />
					<cfset QueryAddRow(in.act, 2) />
					<cfset QuerySetCell(in.act, "col1", "aaaa", 1) />
					<cfset QuerySetCell(in.act, "col2", "bbbb", 1) />
					<cfset QuerySetCell(in.act, "col1", "ccccc", 2) />
					<cfset QuerySetCell(in.act, "col2", "dddd", 2) />
					<cfset exp="assertStruct-002" />
					<cfset act="" />
					<cftry>
						<cfset com.assertQuery(in.exp, in.act) />
						<cfcatch>
							<cfset act=cfcatch.ErrorCode />
						</cfcatch>
					</cftry>
					<cfset assert(caseNo, "኱Ⴄ4s", in, exp, act) />

					<cfset caseNo=IncrementValue(caseNo) />
					<cfset in=StructNew() />
					<cfset in.exp=QueryNew("col1,col2", "VarChar,VarChar") />
					<cfset QueryAddRow(in.exp, 2) />
					<cfset QuerySetCell(in.exp, "col1", "aaaa", 1) />
					<cfset QuerySetCell(in.exp, "col2", "bbbb", 1) />
					<cfset QuerySetCell(in.exp, "col1", "ccccc", 2) />
					<cfset QuerySetCell(in.exp, "col2", "ddddd", 2) />
					<cfset in.act=QueryNew("col1,col2", "VarChar,VarChar") />
					<cfset QueryAddRow(in.act, 2) />
					<cfset QuerySetCell(in.act, "col1", "aaaa", 1) />
					<cfset QuerySetCell(in.act, "col2", "bbbb", 1) />
					<cfset QuerySetCell(in.act, "col1", "cccc", 2) />
					<cfset QuerySetCell(in.act, "col2", "ddddd", 2) />
					<cfset exp="assertStruct-002" />
					<cfset act="" />
					<cftry>
						<cfset com.assertQuery(in.exp, in.act) />
						<cfcatch>
							<cfset act=cfcatch.ErrorCode />
						</cfcatch>
					</cftry>
					<cfset assert(caseNo, "኱Ⴄ3s", in, exp, act) />
				</table>
			</fieldset>
			<fieldset>
				<legend>convertQ4Struct</legend>
				<table>
					<tr>
						<th>caseNo</th>
						<th>note</th>
						<th>input</th>
						<th>expected</th>
						<th>actual</th>
						<th>result</th>
						<cfset caseNo=0 />

						<cfset caseNo=IncrementValue(caseNo) />
						<cfset in=QueryNew("col1,col2", "VarChar,VarChar") />
						<cfset exp=StructNew() />
						<cfset act=com.convertQ4Struct(in) />
						<cfset assert(caseNo, "0s", in, exp, act) />

						<cfset caseNo=IncrementValue(caseNo) />
						<cfset in=QueryNew("col1,col2", "VarChar,VarChar") />
						<cfset QueryAddRow(in, 1) />
						<cfset QuerySetCell(in, "col1", "aaaa", 1) />
						<cfset QuerySetCell(in, "col2", "bbbb", 1) />
						<cfset exp=StructNew() />
						<cfset exp[1]=StructNew() />
						<cfset exp[1].col1="aaaa" />
						<cfset exp[1].col2="bbbb" />
						<cfset act=com.convertQ4Struct(in) />
						<cfset assert(caseNo, "1s", in, exp, act) />

						<cfset caseNo=IncrementValue(caseNo) />
						<cfset in=QueryNew("col1,col2", "VarChar,VarChar") />
						<cfset QueryAddRow(in, 2) />
						<cfset QuerySetCell(in, "col1", "aaaa", 1) />
						<cfset QuerySetCell(in, "col2", "bbbb", 1) />
						<cfset QuerySetCell(in, "col1", "ccccc", 2) />
						<cfset QuerySetCell(in, "col2", "ddddd", 2) />
						<cfset exp=StructNew() />
						<cfset exp[1]=StructNew() />
						<cfset exp[1].col1="aaaa" />
						<cfset exp[1].col2="bbbb" />
						<cfset exp[2]=StructNew() />
						<cfset exp[2].col1="ccccc" />
						<cfset exp[2].col2="ddddd" />
						<cfset act=com.convertQ4Struct(in) />
						<cfset assert(caseNo, "2s", in, exp, act) />
					</tr>
				</table>
			</fieldset>
			<fieldset>
				<legend>convertString4Array</legend>
				<table>
					<tr>
						<th>caseNo</th>
						<th>note</th>
						<th>input</th>
						<th>expected</th>
						<th>actual</th>
						<th>result</th>
					</tr>
					<cfset caseNo=0 />

					<cfset caseNo=IncrementValue(caseNo) />
					<cfset in="" />
					<cfset exp=ArrayNew(1) />
					<cfset act=com.convertString4Array(in) />
					<cfset assert(caseNo, "0s" ,in , exp, act) />

					<cfset caseNo=IncrementValue(caseNo) />
					<cfset in="aaaa" />
					<cfset exp=ArrayNew(1) />
					<cfset ArrayAppend(exp, "aaaa") />
					<cfset act=com.convertString4Array(in) />
					<cfset assert(caseNo, "1s" ,in , exp, act) />

					<cfset caseNo=IncrementValue(caseNo) />
					<cfset in="aaaa#Chr(10)#bbbb" />
					<cfset exp=ArrayNew(1) />
					<cfset ArrayAppend(exp, "aaaa") />
					<cfset ArrayAppend(exp, "bbbb") />
					<cfset act=com.convertString4Array(in) />
					<cfset assert(caseNo, "2s" ,in , exp, act) />

					<cfset caseNo=IncrementValue(caseNo) />
					<cfset in="aaaa#Chr(10)##Chr(10)#bbbb" />
					<cfset exp=ArrayNew(1) />
					<cfset ArrayAppend(exp, "aaaa") />
					<cfset ArrayAppend(exp, "bbbb") />
					<cfset act=com.convertString4Array(in) />
					<cfset assert(caseNo, "Rs(s܂)<br>s͖AÂł̂" ,in , exp, act) />

				</table>
			</fieldset>
		</body>
	</cfoutput>
</html>
<cffunction name="doAssertData" access="private" output="true" returntype="void">
	<cfargument name="caseNo" type="string" required="true" />
	<cfargument name="note" type="string" required="true" />
	<cfargument name="in" type="any" required="true" />
	<cfargument name="exp" type="string" required="true" />
	<cfset var act="" />
	<cftry>
		<cfset com.assertData(in.exp, in.act) />
		<cfcatch>
			<cfset act=cfcatch.ErrorCode />
		</cfcatch>
	</cftry>
	<cfset assert(ARGUMENTS.caseNo, ARGUMENTS.note, ARGUMENTS.in, ARGUMENTS.exp, act) />
</cffunction>
