<!---//
////////////////////////////////////////////////////////////////////////////////
//	Copyright 2008 cfneo-Project, jp.sourceforge.cfneo and the Others.
//
//	http://sourceforge.jp/projects/cfneo
//
//	Licensed under the Apache License, Version 2.0 (the "License");
//	you may not use this file except in compliance with the License.
//	You may obtain a copy of the License at
//
//	    http://www.apache.org/licenses/LICENSE-2.0
//
//	Unless required by applicable law or agreed to in writing, software
//	distributed under the License is distributed on an "AS IS" BASIS,
//	WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
//	either express or implied. See the License for the specific language
//	governing permissions and limitations under the License.
////////////////////////////////////////////////////////////////////////////////
//--->
<cfcomponent output="false">

	<cffunction name="tailRead" access="public" output="false" returntype="string">
		<cfargument name="filepath" type="string" require="true" />
		<cfargument name="rowcount" type="numeric" required="false" />
		<cfset var _rowcount=1 />
		<cfset var regex="" />
		<cfset var idx=0 />
		<cfset var f="" />
		<cfset var find="" />
		<cfset var ret="" />
		<cfset validateFile(ARGUMENTS.filepath) />
		<cfif IsDefined("ARGUMENTS.rowcount")>
			<cfset _rowcount=ARGUMENTS.rowcount />
		</cfif>
		<cfif _rowcount LT 1>
			<cfthrow type="Application" errorcode="FileUtil-1" message="rowcount is smaller than 1." />
		</cfif>
		<cfset regex="(\n|^)[^\n]*(\n[^\n]*){#_rowcount-1#}$" />
		<cflock scope="application" type="readonly" throwontimeout="true" timeout="0">
			<cffile action="read" file="#ARGUMENTS.filepath#" variable="f" />
		</cflock>
		<cfset find=REFind(regex, f, 0, true) />
		<cfif find.POS[1] gt 0 and find.LEN[1] gt 0>
			<cfset ret=Mid(f, find.POS[1], find.LEN[1]) />
			<cfset ret=REReplace(ret, "[\n\r]", "", "all") />
		<cfelse>
			<cfthrow type="Application" errorcode="FileUtil-3" message="RegEx pattern un match." />
		</cfif>
		<cfreturn ret />
	</cffunction>

	<cffunction name="createFileArray" access="public" output="false" returntype="array">
		<cfargument name="rootPath" type="string" required="true" />
		<cfargument name="returnArray" type="array" required="false" />
		<cfset var pathutil=THIS.comMgr.getComponent("appcore.utils.PathUtil") />
		<cfset var ret="" />
		<cfset var dir="" />
		<cfset var path="" />
		<cfif Not DirectoryExists(ARGUMENTS.rootPath) >
			<cfthrow type="Application" errorcode="FileUtil-2" message="Directory:[#ARGUMENTS.rootPath#] is not found." />
		</cfif>
		<cfif IsDefined("ARGUMENTS.returnArray")>
			<cfset ret=ARGUMENTS.returnArray />
		<cfelse>
			<cfset APPLICATION.logger.debuglog("create") />
			<cfset ret=ArrayNew(1) />
		</cfif>
		<cfdirectory action="list" directory="#ARGUMENTS.rootPath#" name="dir" />
		<cfloop query="dir">
			<cfset path="#dir.DIRECTORY#\#dir.NAME#" />
			<cfif dir.TYPE is "File">
				<cfset ArrayAppend(ret, pathutil.absolute2Relative(path)) />
				<cfset APPLICATION.logger.debuglog("add=" & path) />
			<cfelseif dir.TYPE is "Dir">]
				<cfif dir.NAME neq ".svn">
					<cfset ret=createFileArray(path, ret) />
				</cfif>
			</cfif>
		</cfloop>
		<cfreturn ret />
	</cffunction>

	<cffunction name="createContentsArray" access="public" output="false" returntype="array">
		<cfargument name="filepath" type="string" required="true" />
		<cfset var list=ArrayNew(1) />
		<cfset var file="" />
		<cfset var idx="" />
		<cfset validateFile(ARGUMENTS.filepath) />
		<cflock scope="application" type="exclusive" throwontimeout="true" timeout="0">
			<cffile action="read" file="#ARGUMENTS.filepath#" variable="file" />
		</cflock>
		<cfloop index="idx" list="#file#" delimiters="#Chr(10)##Chr(13)#">
			<cfset ArrayAppend(list, idx) />
		</cfloop>
		<cfreturn list />
	</cffunction>

	<cffunction name="createNewFile" access="public" output="false" returntype="void">
		<cfargument name="filepath" type="string" required="true" />
		<cfset var findret=REFind("[^\\]*$", ARGUMENTS.filepath, 0, true) />
		<cfset var filename=ARGUMENTS.filepath />
		<cfset var dirname="" />
		<cfif findret.POS[1] gt 0 and findret.LEN[1] gt 0>
			<cfset filename=Mid(ARGUMENTS.filepath, findret.POS[1], findret.LEN[1]) />
		</cfif>
		<cfset dirname=REReplace(ARGUMENTS.filepath, "[^\\]*$", "", "all") />
		<cflock scope="application" type="exclusive" throwontimeout="true" timeout="0">
			<cfif not DirectoryExists(dirname)>
				<cfdirectory action="create" directory="#dirname#" />
			</cfif>
			<cffile action="write" file="#ARGUMENTS.filepath#" output="" />
		</cflock>
	</cffunction>

	<cffunction name="validateFile" access="private" output="false" returntype="void">
		<cfargument name="filepath" type="string" required="true" />
		<cfif not FileExists(ARGUMENTS.filepath)>
			<cfthrow type="FileUtil" errorcode="FileUtil-4" message="File[#ARGUMENTS.filepath#] is not found." />
		</cfif>
	</cffunction>

	<cffunction name="updateFile" access="public" output="false" returntype="void">
		<cfargument name="filepath" type="string" required="true" />
		<cfargument name="output" type="string" required="true" />
		<cflock scope="Application" type="exclusive" throwontimeout="true" timeout="0">
			<cffile action="write" file="#ARGUMENTS.filepath#" output="#ARGUMENTS.output#" />
		</cflock>
	</cffunction>

</cfcomponent>
