<!---//
////////////////////////////////////////////////////////////////////////////////
//	Copyright 2008 cfneo-Project, jp.sourceforge.cfneo and the Others.
//
//	http://sourceforge.jp/projects/cfneo
//
//	Licensed under the Apache License, Version 2.0 (the "License");
//	you may not use this file except in compliance with the License.
//	You may obtain a copy of the License at
//
//	    http://www.apache.org/licenses/LICENSE-2.0
//
//	Unless required by applicable law or agreed to in writing, software
//	distributed under the License is distributed on an "AS IS" BASIS,
//	WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
//	either express or implied. See the License for the specific language
//	governing permissions and limitations under the License.
////////////////////////////////////////////////////////////////////////////////
//--->
<cfcomponent output="false">

	<cffunction name="getComponent" access="public" output="false" returntype="any">
		<cfargument name="name" type="string" required="true" />
		<cfset var obj="" />
		<cfset obj=createComponent(ARGUMENTS.name) />
		<cfset obj.comMgr=THIS />
		<cfreturn obj />
	</cffunction>

	<cffunction name="createComponent" access="private" output="false" returntype="any">
		<cfargument name="name" type="string" required="true" />
		<cfset var obj="" />
		<cfset var componentName="#APPLICATION.ApplicationName#.#ARGUMENTS.name#" />
		<cfif Trim(ARGUMENTS.name) is "">
			<cfthrow type="APPlication" errorcode="1" message="R|[lgwB" />
		</cfif>
		<cftry>
			<cfobject component="#componentName#" name="obj" />
			<cfcatch>
				<cfif IsDefined("cfcatch.MissingFileName")
						and cfcatch.MissingFileName is componentName>
					<!---//
						appcore.ComponentManager͗p^C~OɂāAApplicationContext
						ݒlقȂP[Xz肳ׁAMȎOɂꂼ̑݃`FbN{B
					//--->
					<cfif IsDefined("APPLICATION.debugMode") and APPLICATION.debugMode
						and IsDefined("APPLICATION.logger") and IsObject(APPLICATION.logger)>
						<cfset APPLICATION.logger.debuglog('cfcatch.MissingFileName:[#cfcatch.MissingFileName#]') />
						<cfset APPLICATION.logger.debuglog('ARGUMENTS.name:[#ARGUMENTS.name#]') />
					</cfif>
					<cfthrow type="COMPONENTMANAGER" errorcode="2" message="[#ARGUMENTS.name#(#componentName#)] is Nothing!" />
				<cfelse>
					<cfrethrow />
				</cfif>
			</cfcatch>
		</cftry>
		<cfreturn obj />
	</cffunction>

</cfcomponent>
