<?xml version="1.0" encoding="utf8"?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN"
 "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="ja" lang="ja">
	<cfoutput>
		<cfset VARIABLES.pageTitle="Test driver [dao/EventTypeMasterDao.cfc]" />
		<head>
			<meta http-equiv="Content-Style-Type" content="text/css"/>
			<link rel="stylesheet" href="#APPLICATION.ContentsRoot#/dev/test/style.css" type="text/css" />
			<title>#VARIABLES.pageTitle#</title>
		</head>
		<body>
			<a href="../">back</a>
			<h1>#VARIABLES.pageTitle#</h1>
			<cfset VARIABLES.dao=getComponentManager().getComponent("dao.EventTypeMasterDao") />
			<fieldset>
				<legend>selectByEventTypeId</legend>
				<table>
					<tr>
						<th>caseNo</th>
						<th>note</th>
						<th>input</th>
						<th>expected</th>
						<th>actual</th>
						<th>result</th>
					</tr>
					<cfset VARIABLES.in=1 />
					<cfquery datasource="#APPLICATION.DataSource#" name="VARIABLES.exp">
						SELECT
							1 AS EVENT_TYPE_ID
						,	'init' AS EVENT_TYPE_NAME
					</cfquery>
					<cfset Variables.act=VARIABLES.dao.selectByEventTypeId(VARIABLES.in) />
					<cfset assert(1, "qbg", VARIABLES.in,
							VARIABLES.exp, VARIABLES.act) />

					<cfset VARIABLES.in=99 />
					<cfset Variables.act=VARIABLES.dao.selectByEventTypeId(VARIABLES.in) />
					<cfset assert(2, "qbgȂ", VARIABLES.in,
							0, VARIABLES.act.RECORDCOUNT) />
				</table>
			</fieldset>
			<fieldset>
				<legend>create</legend>
				<cftransaction isolation="read_committed">
					<table>
						<tr>
							<th>caseNo</th>
							<th>note</th>
							<th>input</th>
							<th>expected</th>
							<th>actual</th>
							<th>result</th>
						</tr>
						<cfset VARIABLES.in=StructNew() />
						<cfset VARIABLES.in.id=99 />
						<cfset VARIABLES.in.name="test1" />
						<cfquery datasource="#APPLICATION.DataSource#" name="VARIABLES.exp">
							SELECT
								99 AS EVENT_TYPE_ID
							,	'test1' AS EVENT_TYPE_NAME
						</cfquery>
						<cfset VARIABLES.dao.create(VARIABLES.in.id, VARIABLES.in.name) />
						<cfset VARIABLES.act=VARIABLES.dao.selectByEventTypeId(VARIABLES.in.id) />
						<cfset assert(1, "", VARIABLES.in,
								VARIABLES.exp, VARIABLES.act) />

						<cfset VARIABLES.in=StructNew() />
						<cfset VARIABLES.in.id=4 />
						<cfset VARIABLES.in.name="button" />
						<cfset VARIABLES.exp="23505" />
						<cfset VARIABLES.act="" />
						<cftry>
							<cfset VARIABLES.dao.create(VARIABLES.in.id, VARIABLES.in.name) />
							<cfcatch>
								<cfset VARIABLES.act=cfcatch.ErrorCode />
							</cfcatch>
						</cftry>
						<cfset assert(2, "s", VARIABLES.in,
								VARIABLES.exp, VARIABLES.act) />

					</table>
					<cftransaction action="rollback" />
				</cftransaction>
			</fieldset>
			<fieldset>
				<legend>update</legend>
				<cftransaction isolation="read_committed">
					<table>
						<tr>
							<th>caseNo</th>
							<th>note</th>
							<th>input</th>
							<th>expected</th>
							<th>actual</th>
							<th>result</th>
						</tr>
						<cfset VARIABLES.in=StructNew() />
						<cfset VARIABLES.in.id=1 />
						<cfset VARIABLES.in.name="initialize" />
						<cfquery datasource="#APPLICATION.DataSource#" name="VARIABLES.exp">
							SELECT
								1 AS EVENT_TYPE_ID
							,	'initialize' AS EVENT_TYPE_NAME
						</cfquery>
						<cfset VARIABLES.dao.update(VARIABLES.in.id, VARIABLES.in.name) />
						<cfset VARIABLES.act=VARIABLES.dao.selectByEventTypeId(VARIABLES.in.id) />
						<cfset assert(1, "", VARIABLES.in,
								VARIABLES.exp, VARIABLES.act) />
						<cftransaction action="rollback" />

						<cfset VARIABLES.in=StructNew() />
						<cfset VARIABLES.in.id=99 />
						<cfset VARIABLES.in.name="failed" />
						<cfquery datasource="#APPLICATION.DataSource#" name="VARIABLES.exp">
							SELECT
								1 AS EVENT_TYPE_ID
							,	'init' AS EVENT_TYPE_NAME
							UNION
							SELECT
								2 AS EVENT_TYPE_ID
							,	'button' AS EVENT_TYPE_NAME
							UNION
							SELECT
								3 AS EVENT_TYPE_ID
							,	'link' AS EVENT_TYPE_NAME
							UNION
							SELECT
								4 AS EVENT_TYPE_ID
							,	'timer' AS EVENT_TYPE_NAME
						</cfquery>
						<cfset VARIABLES.dao.update(VARIABLES.in.id, VARIABLES.in.name) />
						<cfset VARIABLES.act=getComponentManager().getComponent("dao.ledgerdao.EventTypeMasterLedgerDao")
								.getAll() />
						<cfset assert(2, "s", VARIABLES.in,
								VARIABLES.exp, VARIABLES.act) />
					</table>
					<cftransaction action="rollback" />
				</cftransaction>
			</fieldset>
			<fieldset>
				<legend>deleteByEventTypeId</legend>
				<cftransaction isolation="read_committed">
					<table>
						<tr>
							<th>caseNo</th>
							<th>note</th>
							<th>input</th>
							<th>expected</th>
							<th>actual</th>
							<th>result</th>
						</tr>
						<cfset VARIABLES.in=StructNew() />
						<cfset VARIABLES.in.id=5 />
						<cfset VARIABLES.in.name="test3" />
						<cfset VARIABLES.dao.create(VARIABLES.in.id, VARIABLES.in.name) />
						<cfquery datasource="#APPLICATION.DataSource#" name="VARIABLES.exp">
							SELECT COUNT(*) AS C FROM EVENT_TYPE_MASTER
						</cfquery>
						<cfset VARIABLES.dao.deleteByEventTypeId(VARIABLES.in.id) />
						<cfquery datasource="#APPLICATION.DataSource#" name="VARIABLES.act">
							SELECT COUNT(*) AS C FROM EVENT_TYPE_MASTER
						</cfquery>
						<cfset assert(1, "ΏۃA", VARIABLES.in.id,
								(VARIABLES.exp.C - 1), VARIABLES.act.C)>

						<cfset VARIABLES.in=StructNew() />
						<cfset VARIABLES.in.id=555 />
						<cfquery datasource="#APPLICATION.DataSource#" name="VARIABLES.exp">
							SELECT COUNT(*) AS C FROM EVENT_TYPE_MASTER
						</cfquery>
						<cfset VARIABLES.dao.deleteByEventTypeId(VARIABLES.in.id) />
						<cfquery datasource="#APPLICATION.DataSource#" name="VARIABLES.act">
							SELECT COUNT(*) AS C FROM EVENT_TYPE_MASTER
						</cfquery>
						<cfset assert(2, "ΏۂȂ", VARIABLES.in.id,
								(VARIABLES.exp.C), VARIABLES.act.C)>
					</table>
					<cftransaction action="rollback" />
				</cftransaction>
			</fieldset>
		</body>
	</cfoutput>
</html>
