<!---//
////////////////////////////////////////////////////////////////////////////////
//	Copyright 2008 cfneo-Project, jp.sourceforge.cfneo and the Others.
//
//	http://sourceforge.jp/projects/cfneo
//
//	Licensed under the Apache License, Version 2.0 (the "License");
//	you may not use this file except in compliance with the License.
//	You may obtain a copy of the License at
//
//	    http://www.apache.org/licenses/LICENSE-2.0
//
//	Unless required by applicable law or agreed to in writing, software
//	distributed under the License is distributed on an "AS IS" BASIS,
//	WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
//	either express or implied. See the License for the specific language
//	governing permissions and limitations under the License.
////////////////////////////////////////////////////////////////////////////////
//--->
<cfcomponent output="false">

	<cffunction name="debuglog" access="public" output="false" returntype="void">
		<cfargument name="msg" type="string" required="true" />
		<cfif APPLICATION.debugMode>
			<cfset putlog(ARGUMENTS.msg) />
		</cfif>
	</cffunction>

	<cffunction name="putlog" access="public" output="false" returntype="void">
		<cfargument name="msg" type="string" required="true" />
		<cfset append(formatMessage(ARGUMENTS.msg)) />
	</cffunction>

	<cffunction name="resetLogfile" access="public" output="false" returntype="void">
		<cflock scope="APPLICATION" type="exclusive" throwontimeout="true" timeout="0">
			<cfif FileExists(APPLICATION.logfile)>
				<cffile action="delete" file="#APPLICATION.logfile#" />
			</cfif>
		</cflock>
		<cfset write("") />
	</cffunction>

	<cffunction name="formatMessage" access="private" output="false" returntype="string">
		<cfargument name="msg" type="string" required="true" />
		<cfreturn "[#APPLICATION.ApplicationName#] #DateFormat(Now(), 'YYYY-MM-DD')# #TimeFormat(Now(), 'HH:MM:SS')# - #ARGUMENTS.msg#" />
	</cffunction>

	<cffunction name="append" access="private" output="false" returntype="void">
		<cfargument name="msg" type="string" required="true" />
		<cfset var outmsg=Replace(Replace(ARGUMENTS.msg, Chr(13), " ", "all"), Chr(10), " ", "all")>
		<cfset var fileutil=getFileUtil() />
		<cfif not FileExists(APPLICATION.logfile)>
			<cfset fileutil.createNewFile(APPLICATION.logfile) />
		</cfif>
		<cflock scope="APPLICATION" type="exclusive" throwontimeout="true" timeout="0">
			<cffile action="append" file="#APPLICATION.logfile#"
					addnewline="true" charset="#APPLICATION.logfile_charset#" output="#outmsg#" />
		</cflock>
	</cffunction>

	<cffunction name="write" access="private" output="false" returntype="void">
		<cfargument name="msg" type="string" required="true" />
		<cflock scope="APPLICATION" type="exclusive" throwontimeout="true" timeout="0">
			<cffile action="write" file="#APPLICATION.logfile#"
					charset="#APPLICATION.logfile_charset#"
					addnewline="no" output="#ARGUMENTS.msg#" />
		</cflock>
	</cffunction>

	<cffunction name="getFileUtil" access="private" output="false" returntype="any">
		<cfif IsDefined("THIS.comMgr")>
			<cfreturn THIS.comMgr.getComponent("appcore.utils.FileUtil") />
		</cfif>
		<cfreturn createObject("component", "#APPLICATION.ApplicationName#.appcore.utils.FileUtil") />
	</cffunction>

</cfcomponent>

