<!---//
////////////////////////////////////////////////////////////////////////////////
//	Copyright 2008 cfneo-Project, jp.sourceforge.cfneo and the Others.
//
//	http://sourceforge.jp/projects/cfneo
//
//	Licensed under the Apache License, Version 2.0 (the "License");
//	you may not use this file except in compliance with the License.
//	You may obtain a copy of the License at
//
//	    http://www.apache.org/licenses/LICENSE-2.0
//
//	Unless required by applicable law or agreed to in writing, software
//	distributed under the License is distributed on an "AS IS" BASIS,
//	WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
//	either express or implied. See the License for the specific language
//	governing permissions and limitations under the License.
////////////////////////////////////////////////////////////////////////////////
//--->
<cfcomponent output="false">

	<cffunction name="getDataType" access="public" output="false" returntype="string">
		<cfargument name="data" type="any" required="true" />
		<cfif not IsDefined("ARGUMENTS.data")>
			<cfreturn "" />
		</cfif>
		<cfif IsDefined("ARGUMENTS.data.metadata")>
			<cfreturn "method" />
		</cfif>
		<cfif IsObject(ARGUMENTS.data)>
			<cfreturn "object" />
		<cfelseif IsStruct(ARGUMENTS.data)>
			<cfreturn "struct" />
		<cfelseif IsArray(ARGUMENTS.data)>
			<cfreturn "array" />
		<cfelseif IsQuery(ARGUMENTS.data)>
			<cfreturn "query" />
		<cfelseif IsNumeric(ARGUMENTS.data)>
			<cfreturn "numeric" />
		<cfelseif IsBoolean(ARGUMENTS.data)>
			<cfreturn "boolean" />
		<cfelseif IsDate(ARGUMENTS.data)>
			<cfreturn "date" />
		<cfelse>
			<cfreturn "string" />
		</cfif>
	</cffunction>

	<cffunction name="getRealComponentName" access="public" output="false" returntype="string">
		<cfargument name="compName" type="any" required="true" />
		<cfset var ret=REReplace(ARGUMENTS.compName, "[/\\]", ".", "all") />
		<cfset var find="" />
		<cfset ret=REReplace(ret, "^\.", "") />
		<cfset ret=Replace(ret, ".cfc", "") />
		<cfset APPLICATION.logger.debuglog("getRealComponentName ret:[#ret#]") />
		<cfset find=REFind(APPLICATION.ApplicationName, ret, 0, true) />
		<cfset APPLICATION.logger.debuglog("getRealComponentName pos:[#find.POS[1]#] / len:[#find.LEN[1]#]") />
		<cfif find.POS[1] is 0 and find.LEN[1] is 0>
			<cfset ret=APPLICATION.ApplicationName & "." & ret />
		</cfif>
		<cfset APPLICATION.logger.debuglog("getRealComponentName return:[#ret#]") />
		<cfreturn ret />
	</cffunction>

	<cffunction name="getMethodNameArray" access="public" output="false" returntype="array">
		<cfargument name="compName" type="any" required="true" />
		<cfset var comname=getRealComponentName(ARGUMENTS.compName) />
		<cfset var obj=CreateObject("component", comname) />
		<cfset var ret=ArrayNew(1) />
		<cfset var nameList=StructKeyList(obj) />
		<cfset var idx="" />
		<cfset nameList=ListSort(nameList, "text") />
		<cfloop index="idx" list="#nameList#">
			<cfif getDataType(obj[idx]) is "method">
				<cfset ArrayAppend(ret, idx) />
			</cfif>
		</cfloop>
		<cfreturn ret />
	</cffunction>

</cfcomponent>

