package jp.sourceforge.cfneo.at4ie2;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertTrue;
import static org.junit.Assert.fail;
import jp.sourceforge.cfneo.at4ie2.api.browser.Browser;
import jp.sourceforge.cfneo.at4ie2.api.browser.impl.ie.BTInternetExplorer;

import org.junit.Test;

public class BrowserIntegrationTest2 {

	@Test
	public void test() {
		Browser browser = new BTInternetExplorer();
		try {
			browser.open(TestSupport.TARGET_PATH + TestSupport.TARGET_FILE);

			/*
			 * Popup-window
			 */
			browser.getButton("btn3").click();
			assertEquals(1, browser.getChildBrowserCount());
			Browser child1 = browser.getChildeBrowser(0);
			assertEquals("Test Popup 1", child1.getTitle());
			child1.getButton("btn1").click();
			assertTrue(child1.isOpened());
			child1.close();

			assertEquals(0, browser.getChildBrowserCount());
			browser.getButton("btn4").click();
			assertEquals(1, browser.getChildBrowserCount());
			Browser child2 = browser.getChildeBrowser(1);
			assertEquals("Test Popup 2", child2.getTitle());
			child2.getButton("btn1").click();
			child2.close();

//			// 2グđIB
//			browser.getButton("btn3").click();
//			browser.getButton("btn4").click();
//			Browser choise1 = browser.getChildeBrowser(0);
//			assertEquals("Test Popup 1", choise1.getTitle());
//			Browser choise2 = browser.getChildeBrowser(1);
//			assertEquals("Test Popup 2", choise2.getTitle());
//			choise1.close();
//			choise2.close();
			browser.close();
		} catch (Exception e) {
			e.printStackTrace();
			fail();
		}
	}

}
