package jp.sourceforge.cfneo.at4ie2;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertTrue;

import java.util.List;

import jp.sourceforge.cfneo.at4ie2.api.browser.Browser;
import jp.sourceforge.cfneo.at4ie2.api.browser.Option;
import jp.sourceforge.cfneo.at4ie2.api.browser.Radio;
import jp.sourceforge.cfneo.at4ie2.api.browser.impl.ie.BTInternetExplorer;
import jp.sourceforge.cfneo.at4ie2.utils.StringUtil;

import org.junit.Test;

public class BrowserIntegrationTest1 {

	@Test
	public void test() {
		Browser browser = new BTInternetExplorer();
		browser.open(TestSupport.TARGET_PATH + TestSupport.TARGET_FILE);

		/*
		 * Simple components
		 */
		browser.getTextField("txt0").setValue("aaaa");
		assertEquals("aaaa", browser.getTextField("txt0").getValue());
		browser.getButton("btn0").click();
		assertEquals("btn0", browser.getTextField("txt0").getValue());
		assertEquals("file:///" + TestSupport.TARGET_PATH.replaceAll("\\\\", "/") + "/watijtest1.html?param=aaa", browser.getAnchor("link0").getHref());
		assertEquals("test link", browser.getAnchor("link0").getLable());

		/*
		 * AlertButton
		 */
		// alert
		browser.getButton("btn1").click();
		assertTrue(browser.getAlertDialog().exists());
		assertEquals("aaa", browser.getAlertDialog().getLabel());
		browser.getAlertDialog().clickOk();
		assertFalse(browser.getAlertDialog().exists());
		// confirm:ok
		browser.getButton("btn2").click();
		assertTrue(browser.getConfirmDialog().exists());
		assertEquals("bbb", browser.getConfirmDialog().getLabel());
		browser.getAlertDialog().clickOk();
		assertFalse(browser.getAlertDialog().exists());
		assertEquals("yes", browser.getTextField("txt1").getValue());
		// TODO confirm:cancel

		/*
		 * select-option
		 */
		String[] valueList = {"aaa", "bbb", "ccc"};
		String[] labelList = {"a:abcde", "b:bcdef", "c:cdefg"};
		List<Option> options = browser.getSelect("select1").getOptionList();
		int i = 0;
		for (Option option: options) {
			assertEquals(valueList[i], option.getValue());
			assertEquals(labelList[i], option.getLabel());
			i++;
		}
		Option selectedOption = browser.getSelect("select1").getSelectedOption();
		assertEquals("aaa", selectedOption.getValue());
		assertEquals("a:abcde", selectedOption.getLabel());
		browser.getSelect("select1").getOption("op3").select();
		selectedOption = browser.getSelect("select1").getSelectedOption();
		assertEquals("ccc", selectedOption.getValue());
		assertEquals("c:cdefg", selectedOption.getLabel());

		/*
		 * radio
		 */
		Radio radio1 = browser.getRadioByName("radio1");
		assertEquals(2, radio1.getCount());
		String expectedIdList1 = "rd1,rd2";
		String actualIdList1 = StringUtil.createLine(radio1.getIdList());
		assertEquals(expectedIdList1, actualIdList1);

		Radio radio2 = browser.getRadioByName("radio2");
		assertEquals(1, radio2.getCount());
		String expectedIdList2 = "rd3";
		String actualIdList2 = StringUtil.createLine(radio2.getIdList());
		assertEquals(expectedIdList2, actualIdList2);

		/*
		 * div
		 */

		browser.close();
	}

}
