package jp.sourceforge.cfneo.at4ie2.api.test.impl.invoker;

import jp.sourceforge.cfneo.at4ie2.api.browser.HtmlDataComponent;
import jp.sourceforge.cfneo.at4ie2.api.test.AbstractInvoker;
import jp.sourceforge.cfneo.at4ie2.api.test.Context;
import jp.sourceforge.cfneo.at4ie2.api.test.LocatorTypeEnum;
import jp.sourceforge.cfneo.at4ie2.api.test.TestCase;

public class StoreValueInvoker extends AbstractInvoker {

	public StoreValueInvoker(Context context) {
		super(context);
	}

	@Override
	public void invoke(TestCase testCase) {
		LocatorTypeEnum locatorType = testCase.getTarget().getLocatorType();
		HtmlDataComponent htmlDataComponent = null;
		switch (locatorType) {
		case DOM:
			break;
		case ID:
			htmlDataComponent = this.getBrowser().getHtmlDataComponent(testCase.getTarget().getValue());
			break;
		case IDENTIFIER:
			htmlDataComponent = this.getBrowser().getHtmlDataComponent(testCase.getTarget().getValue());
			if (htmlDataComponent.exists() == false) {
				htmlDataComponent = this.getBrowser().gethtmlDataComponentByName(testCase.getTarget().getValue());
			}
			break;
		case LINK:
			break;
		case NAME:
			htmlDataComponent = this.getBrowser().gethtmlDataComponentByName(testCase.getTarget().getValue());
			break;
		case OTHER:
			break;
		case VALUE:
			break;
		case XPATH:
			break;
		default:
			;
		}

		this.getContext().setStoreValue(testCase.getValue(), htmlDataComponent.getValue());
	}

}
