package jp.sourceforge.cfneo.at4ie2.api.test.impl.invoker;

import jp.sourceforge.cfneo.at4ie2.api.test.AbstractInvoker;
import jp.sourceforge.cfneo.at4ie2.api.test.BTTestCaseInvalidExceptioin;
import jp.sourceforge.cfneo.at4ie2.api.test.Context;
import jp.sourceforge.cfneo.at4ie2.api.test.TestCase;
import jp.sourceforge.cfneo.at4ie2.api.test.TestCaseValidator;

public class OpenInvoker extends AbstractInvoker implements TestCaseValidator {

	public OpenInvoker(Context context) {
		super(context);
	}

	@Override
	public void invoke(TestCase testCase) {
		this.getBrowser().open(testCase.getTarget().getValue());
	}
	@Override
	public void validate(TestCase testCase) {
		String url = testCase.getTarget().getValue();
		if (url == null) {
			throw new BTTestCaseInvalidExceptioin(
					"URL is null.");
		}
		if ("http".equals(url.subSequence(0, 4))) {
			throw new BTTestCaseInvalidExceptioin(
					"URL is invalid.[" + url + "]");
		}
	}

}
