package jp.sourceforge.cfneo.at4ie2.api.test.impl;

import java.util.ArrayList;
import java.util.List;

import jp.sourceforge.cfneo.at4ie2.api.test.CommandEnum;
import jp.sourceforge.cfneo.at4ie2.api.test.Context;
import jp.sourceforge.cfneo.at4ie2.api.test.TestCase;
import jp.sourceforge.cfneo.at4ie2.api.test.TestCaseList;

public class DefaultTestCaseList implements TestCaseList {

	int index;
	Context context;
	List<TestCase> testCaseList;

	public DefaultTestCaseList(Context context) {
		this.context = context;
		this.testCaseList = new ArrayList<TestCase>();
	}

	@Override
	public void addTestCase(int testCaseId, CommandEnum command, String target, String value) {
		this.testCaseList.add(new DefaultTestCase(this.context, testCaseId, command, target, value));
	}
	@Override
	public int size() {
		return this.testCaseList.size();
	}
	@Override
	public TestCase getTestCase(int index) {
		return this.testCaseList.get(index);
	}
	@Override
	public boolean hasNext() {
		return this.index < this.testCaseList.size();
	}
	@Override
	public TestCase next() {
		this.index++;
		return this.testCaseList.get(this.index);
	}
	@Override
	public void remove() {
		this.testCaseList.remove(this.index);
	}

}
