package jp.sourceforge.cfneo.at4ie2.api.test.impl;

import java.util.HashMap;
import java.util.Map;

import jp.sourceforge.cfneo.at4ie2.api.browser.Browser;
import jp.sourceforge.cfneo.at4ie2.api.browser.impl.ie.BTInternetExplorer;
import jp.sourceforge.cfneo.at4ie2.api.test.Context;
import jp.sourceforge.cfneo.at4ie2.api.test.InvokerFactory;
import jp.sourceforge.cfneo.at4ie2.api.test.ResultLogger;

public class DefaultContext implements Context {

	static Context _instance;

	public static Context getInstance() {
		if (_instance == null) {
			_instance = new DefaultContext();
		}
		return _instance;
	}

	Map<String, String> store;
	Browser browser;
	InvokerFactory invokerFactory;
	boolean toolTest;

	protected DefaultContext() {
		this.store = new HashMap<String, String>();
		this.invokerFactory = new DefaultInvokerFactory(this);
		this.browser = new BTInternetExplorer();
		this.toolTest = false;
	}

	@Override
	public String getContextName() {
		return this.getClass().getName();
	}
	@Override
	public String getLogFile() {
		return "src/test/resources/at4ie2result.log";
	}
	@Override
	public String getPlatformName() {
		return "at4ie browser tester.";
	}
	@Override
	public boolean isToolTest() {
		return this.toolTest;
	}
	@Override
	public void setToolTest(boolean flag) {
		this.toolTest = flag;
	}
	@Override
	public void setStoreValue(String key, String value) {
		this.store.put(key, value);
	}
	@Override
	public String getStoreValue(String key) {
		return this.store.get(key);
	}
	@Override
	public void reset() {
		this.store = new HashMap<String, String>();
	}
	@Override
	public Browser getBrowser() {
		return this.browser;
	}
	@Override
	public void setBrowser(Browser browser) {
		this.browser = browser;
	}
	@Override
	public InvokerFactory getInvokerFactory() {
		return this.invokerFactory;
	}
	@Override
	public ResultLogger getResultLogger() {
		return DefaultResultLogger.getInstance();
	}
	@Override
	public String toString() {
		return "context name=[" + this.getContextName() + "]";
	}

}
