package jp.sourceforge.cfneo.at4ie2.api.test;

public enum CommandEnum {

	/*
	 * nR}hB
	 */
	OPEN("open"),
	CLICK("click"),
	CLICK_AND_WAIT("clickAndWait"),
	TYPE("type"),
	SELECT("select"),
	SELECT_WINDOW("selectWindow"),
	GO_BACK("goBack"),
	CLOSE("close"),
	PAUSE("pause"),
	FIRE_EVENT("fireEvent"),
	WAIT_FOR_VALUE("waitForValue"),
	STORE("store"),
	STORE_VALUE("storeValue"),
	STORE_TEXT("storeText"),
	STORE_ATTRIBUTE("storeAttribute"),
	CHOOSE_CANCEL_ON_NEXT_CONFIRMATION("chooseCancelOnNextConfirmation"),
	ANSWER_ON_NEXT_PROMPT("answerOnNextPrompt"),
	CLICK_ALERT_DIALOG_OK("clickAlertDialogOk"),

	/*
	 * nR}h(assert)B
	 */
	ASSERT_LOCATION("assertLocation"),
	ASSERT_TITLE("assertTitle"),
	ASSERT_VALUE("assertValue"),
	ASSERT_SELECTED("assertSelected"),
	ASSERT_SELECTED_OPTIONS("assertSelectOptions"),
	ASSERT_TEXT("assertText"),
	ASSERT_ATTRIBUTE("assertAttribute"),
	ASSERT_TEXT_PRESENT("assertTextPresent"),
	ASSERT_TEXT_NOT_PRESENT("ssertTextNotPresent"),
	ASSERT_ELEMENT_PRESENT("assertElementPresent"),
	ASSERT_ELEMENT_NOT_PRESENT("assertElementNotPresent"),
	ASSERT_TABLE("assertTable"),
	ASSERT_VISIBLE("assertVisible"),
	ASSERT_NOT_VISIBLE("assertNotVisible"),
	ASSERT_EDIT_TABLE("assertEditable"),
	ASSERT_NOT_EDIT_TABLE("assertNotEditable"),
	ASSERT_ALERT("assertAlert"),
	ASSERT_CONFIRMATION("assertConfirmation"),
	ASSERT_PROMPT("assertPrompt"),

	/*
	 * nR}h(verify)B
	 */
	VERIFY_LOCATION("verifyLocation"),
	VERIFY_TITLE("verifyTitle"),
	VERIFY_VALUE("verifyValue"),
	VERIFY_SELECTED("verifySelected"),
	VERIFY_SELECTED_OPTIONS("verifySelectOptions"),
	VERIFY_TEXT("verifyText"),
	VERIFY_ATTRIBUTE("verifyAttribute"),
	VERIFY_TEXT_PRESENT("verifyTextPresent"),
	VERIFY_TEXT_NOT_PRESENT("ssertTextNotPresent"),
	VERIFY_ELEMENT_PRESENT("verifyElementPresent"),
	VERIFY_ELEMENT_NOT_PRESENT("verifyElementNotPresent"),
	VERIFY_TABLE("verifyTable"),
	VERIFY_VISIBLE("verifyVisible"),
	VERIFY_NOT_VISIBLE("verifyNotVisible"),
	VERIFY_EDIT_TABLE("verifyEditable"),
	VERIFY_NOT_EDIT_TABLE("verifyNotEditable"),
	VERIFY_ALERT("verifyAlert"),
	VERIFY_CONFIRMATION("verifyConfirmation"),
	VERIFY_PROMPT("verifyPrompt"),

	/*
	 * IWiR}hB
	 */
	WAIT("wait"),
	SCREEN_SHOT("screenshot"),
	INJECTION("injection"),
	UNKNOWN("unknown"),

	/*
	 * _~[R}hB
	 */
	DUMMY("dummy")
	;

	private String value;

	private CommandEnum(String value) {
		this.value = value;
	}
	public static CommandEnum get(String value) {
		CommandEnum[] items = CommandEnum.values();
		for (CommandEnum item :items) {
			if (item.toString().equals(value)) {
				return item;
			}
		}
		return UNKNOWN;
	}
	public String toString() {
		return this.value;
	}

}
