package jp.sourceforge.cfneo.at4ie2.api.test;

import jp.sourceforge.cfneo.at4ie2.api.browser.Browser;

public abstract class AbstractInvoker implements CommandInvoker {

	Context context;

	public AbstractInvoker(Context context) {
		this.context = context;
	}

	public void doTest(TestCase testCase) {
		if (this instanceof TestCaseValidator) {
			((TestCaseValidator) this).validate(testCase);
		}
		this.invoke(testCase);
	}

	@Override
	abstract public void invoke(TestCase testCase);

	protected Browser getBrowser() {
		return this.context.getBrowser();
	}
	protected Context getContext() {
		return this.context;
	}
	protected void setContext(Context context) {
		this.context = context;
	}

}
